/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.core.util;

import java.util.StringJoiner;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public final class AqlUtils {
    private AqlUtils() {
    }

    public static String buildLimitClause(Pageable pageable) {
        if (pageable.isUnpaged()) {
            return "";
        }
        StringJoiner clause = new StringJoiner(", ", "LIMIT ", "");
        clause.add(String.valueOf(pageable.getOffset()));
        clause.add(String.valueOf(pageable.getPageSize()));
        return clause.toString();
    }

    public static String buildPageableClause(Pageable pageable) {
        return AqlUtils.buildPageableClause(pageable, null);
    }

    public static String buildPageableClause(Pageable pageable, @Nullable String varName) {
        return AqlUtils.buildPageableClause(pageable, varName, new StringBuilder()).toString();
    }

    private static StringBuilder buildPageableClause(Pageable pageable, @Nullable String varName, StringBuilder clause) {
        if (pageable.isUnpaged()) {
            return clause;
        }
        Sort sort = pageable.getSort();
        AqlUtils.buildSortClause(sort, varName, clause);
        if (sort.isSorted()) {
            clause.append(' ');
        }
        clause.append("LIMIT ").append(pageable.getOffset()).append(", ").append(pageable.getPageSize());
        return clause;
    }

    public static String buildSortClause(Sort sort) {
        return AqlUtils.buildSortClause(sort, null);
    }

    public static String buildSortClause(Sort sort, @Nullable String varName) {
        return AqlUtils.buildSortClause(sort, varName, new StringBuilder()).toString();
    }

    private static StringBuilder buildSortClause(Sort sort, @Nullable String varName, StringBuilder clause) {
        if (sort.isUnsorted()) {
            return clause;
        }
        String prefix = StringUtils.hasText((String)varName) ? AqlUtils.escapeSortProperty(varName) : null;
        clause.append("SORT ");
        boolean first = true;
        for (Sort.Order order : sort) {
            if (!first) {
                clause.append(", ");
            } else {
                first = false;
            }
            if (prefix != null) {
                clause.append(prefix).append('.');
            }
            String escapedProperty = AqlUtils.escapeSortProperty(order.getProperty());
            clause.append(escapedProperty).append(' ').append(order.getDirection());
        }
        return clause;
    }

    private static String escapeSortProperty(String str) {
        if (str.charAt(0) == '.' || str.charAt(str.length() - 1) == '.') {
            throw new IllegalArgumentException("Sort properties must not begin or end with a dot!");
        }
        StringBuilder escaped = new StringBuilder();
        escaped.append('`');
        boolean inEscapedSeq = false;
        for (int i = 0; i < str.length(); ++i) {
            char nextChar;
            char currChar = str.charAt(i);
            boolean hasNext = i + 1 < str.length();
            char c = nextChar = hasNext ? str.charAt(i + 1) : (char)'\u0000';
            if (currChar == '\\') {
                if (nextChar == '`') {
                    escaped.append("\\`");
                    ++i;
                    continue;
                }
                escaped.append("\\\\");
                continue;
            }
            if (currChar == '`') {
                boolean isNextCharDotOutsideEscapedSeq;
                inEscapedSeq = !inEscapedSeq;
                boolean isStartOrEnd = i == 0 || !hasNext;
                boolean bl = isNextCharDotOutsideEscapedSeq = nextChar == '.' && !inEscapedSeq;
                if (isStartOrEnd || isNextCharDotOutsideEscapedSeq) continue;
                throw new IllegalArgumentException("Sort properties must only contain backticks at beginning/end of attributes or when escaped.");
            }
            if (currChar == '.') {
                if (inEscapedSeq) {
                    escaped.append('.');
                    continue;
                }
                if (nextChar == '.') {
                    throw new IllegalArgumentException("Sort properties may not contain 2+ consecutive dots when outside a backtick escape sequence!");
                }
                if (nextChar == '`') {
                    inEscapedSeq = !inEscapedSeq;
                    ++i;
                }
                escaped.append("`.`");
                continue;
            }
            if (currChar == '[' || currChar == ']') {
                if (inEscapedSeq) {
                    escaped.append(currChar);
                    continue;
                }
                if (currChar == '[') {
                    escaped.append("`");
                }
                escaped.append(currChar);
                if (nextChar != '.') continue;
                escaped.append(".`");
                ++i;
                continue;
            }
            escaped.append(currChar);
        }
        if (inEscapedSeq) {
            throw new IllegalArgumentException("A sort property contains an unclosed backtick escape sequence! The cause may be a missing backtick.");
        }
        escaped.append('`');
        return escaped.toString();
    }

    public static String buildCollectionName(String collection) {
        return collection.contains("-") ? "`" + collection + "`" : collection;
    }
}

