/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.core.util;

import com.arangodb.ArangoDBException;
import com.arangodb.springframework.ArangoUncategorizedException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.dao.PermissionDeniedDataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;

public class ArangoExceptionTranslator
implements PersistenceExceptionTranslator {
    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        ArangoDBException exception;
        Integer responseCode;
        Object dae = null;
        if (ex instanceof DataAccessException) {
            dae = (DataAccessException)DataAccessException.class.cast(ex);
        } else if (ex instanceof ArangoDBException && (responseCode = (exception = (ArangoDBException)((Object)ArangoDBException.class.cast(ex))).getResponseCode()) != null) {
            switch (responseCode) {
                case 401: 
                case 403: {
                    dae = new PermissionDeniedDataAccessException(exception.getMessage(), (Throwable)exception);
                    break;
                }
                case 400: 
                case 405: {
                    dae = new InvalidDataAccessApiUsageException(exception.getMessage(), (Throwable)exception);
                    break;
                }
                case 404: {
                    dae = new InvalidDataAccessResourceUsageException(exception.getMessage(), (Throwable)exception);
                    break;
                }
                case 409: {
                    dae = new DataIntegrityViolationException(exception.getMessage(), (Throwable)exception);
                    break;
                }
                case 412: 
                case 503: {
                    dae = new DataAccessResourceFailureException(exception.getMessage(), (Throwable)exception);
                    break;
                }
                default: {
                    dae = new ArangoUncategorizedException(exception.getMessage(), exception);
                }
            }
        }
        if (dae == null) {
            throw ex;
        }
        return dae;
    }
}

