/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.repository;

import com.arangodb.ArangoCursor;
import com.arangodb.springframework.core.ArangoOperations;
import com.arangodb.springframework.core.mapping.ArangoPersistentEntity;
import com.arangodb.springframework.core.mapping.ArangoPersistentProperty;
import com.arangodb.springframework.repository.ArangoEntityInformation;
import com.arangodb.springframework.repository.ArangoPersistentEntityInformation;
import com.arangodb.springframework.repository.SimpleArangoRepository;
import com.arangodb.springframework.repository.query.ArangoQueryMethod;
import com.arangodb.springframework.repository.query.DerivedArangoQuery;
import com.arangodb.springframework.repository.query.StringBasedArangoQuery;
import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.AnnotationRepositoryMetadata;
import org.springframework.data.repository.core.support.DefaultRepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class ArangoRepositoryFactory
extends RepositoryFactorySupport {
    private final ArangoOperations arangoOperations;
    private final MappingContext<? extends ArangoPersistentEntity<?>, ArangoPersistentProperty> context;

    public ArangoRepositoryFactory(ArangoOperations arangoOperations) {
        this.arangoOperations = arangoOperations;
        this.context = arangoOperations.getConverter().getMappingContext();
    }

    public <T, ID> ArangoEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        return new ArangoPersistentEntityInformation((ArangoPersistentEntity)this.context.getRequiredPersistentEntity(domainClass));
    }

    protected Object getTargetRepository(RepositoryInformation metadata) {
        return new SimpleArangoRepository(this.arangoOperations, metadata.getDomainType());
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleArangoRepository.class;
    }

    protected RepositoryMetadata getRepositoryMetadata(Class<?> repositoryInterface) {
        Assert.notNull(repositoryInterface, (String)"Repository interface must not be null!");
        return Repository.class.isAssignableFrom(repositoryInterface) ? new DefaultArangoRepositoryMetadata(repositoryInterface) : new AnnotationArangoRepositoryMetadata(repositoryInterface);
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        DefaultArangoQueryLookupStrategy strategy = null;
        switch (key) {
            case CREATE_IF_NOT_FOUND: {
                strategy = new DefaultArangoQueryLookupStrategy(this.arangoOperations);
                break;
            }
            case CREATE: {
                break;
            }
        }
        return Optional.ofNullable(strategy);
    }

    static class AnnotationArangoRepositoryMetadata
    extends AnnotationRepositoryMetadata {
        private final TypeInformation<?> typeInformation;

        public AnnotationArangoRepositoryMetadata(Class<?> repositoryInterface) {
            super(repositoryInterface);
            this.typeInformation = ClassTypeInformation.from(repositoryInterface);
        }

        public Class<?> getReturnedDomainClass(Method method) {
            if (ArangoCursor.class.isAssignableFrom(method.getReturnType())) {
                return this.typeInformation.getReturnType(method).getRequiredComponentType().getType();
            }
            return super.getReturnedDomainClass(method);
        }
    }

    static class DefaultArangoRepositoryMetadata
    extends DefaultRepositoryMetadata {
        private final TypeInformation<?> typeInformation;

        public DefaultArangoRepositoryMetadata(Class<?> repositoryInterface) {
            super(repositoryInterface);
            this.typeInformation = ClassTypeInformation.from(repositoryInterface);
        }

        public Class<?> getReturnedDomainClass(Method method) {
            if (ArangoCursor.class.isAssignableFrom(method.getReturnType())) {
                return this.typeInformation.getReturnType(method).getRequiredComponentType().getType();
            }
            return super.getReturnedDomainClass(method);
        }
    }

    static class DefaultArangoQueryLookupStrategy
    implements QueryLookupStrategy {
        private final ArangoOperations operations;

        public DefaultArangoQueryLookupStrategy(ArangoOperations operations) {
            this.operations = operations;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            ArangoQueryMethod queryMethod = new ArangoQueryMethod(method, metadata, factory);
            String namedQueryName = queryMethod.getNamedQueryName();
            if (namedQueries.hasQuery(namedQueryName)) {
                String namedQuery = namedQueries.getQuery(namedQueryName);
                return new StringBasedArangoQuery(namedQuery, queryMethod, this.operations);
            }
            if (queryMethod.hasAnnotatedQuery()) {
                return new StringBasedArangoQuery(queryMethod, this.operations);
            }
            return new DerivedArangoQuery(queryMethod, this.operations);
        }
    }
}

