/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.repository.query;

import com.arangodb.ArangoCursor;
import com.arangodb.model.AqlQueryOptions;
import com.arangodb.springframework.core.ArangoOperations;
import com.arangodb.springframework.repository.query.ArangoParameterAccessor;
import com.arangodb.springframework.repository.query.ArangoParametersParameterAccessor;
import com.arangodb.springframework.repository.query.ArangoQueryMethod;
import com.arangodb.springframework.repository.query.ArangoResultConverter;
import com.arangodb.velocypack.VPackSlice;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.util.Assert;

public abstract class AbstractArangoQuery
implements RepositoryQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractArangoQuery.class);
    protected final ArangoQueryMethod method;
    protected final ArangoOperations operations;
    protected final Class<?> domainClass;

    public AbstractArangoQuery(ArangoQueryMethod method, ArangoOperations operations) {
        Assert.notNull((Object)((Object)method), (String)"ArangoQueryMethod must not be null!");
        Assert.notNull((Object)operations, (String)"ArangoOperations must not be null!");
        this.method = method;
        this.operations = operations;
        this.domainClass = method.getEntityInformation().getJavaType();
    }

    public Object execute(Object[] parameters) {
        ArangoParametersParameterAccessor accessor = new ArangoParametersParameterAccessor(this.method, parameters);
        HashMap<String, Object> bindVars = new HashMap<String, Object>();
        AqlQueryOptions options = this.mergeQueryOptions(this.method.getAnnotatedQueryOptions(), accessor.getQueryOptions());
        if (options == null) {
            options = new AqlQueryOptions();
        }
        if (this.method.isPageQuery()) {
            options.fullCount(Boolean.valueOf(true));
        }
        String query = this.createQuery(accessor, bindVars, options);
        ResultProcessor processor = this.method.getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        Class<?> typeToRead = this.getTypeToRead(processor);
        ArangoCursor<?> result = this.operations.query(query, bindVars, options, typeToRead);
        this.logWarningsIfNecessary(result);
        return processor.processResult(this.convertResult(result, accessor));
    }

    private void logWarningsIfNecessary(ArangoCursor<?> result) {
        result.getWarnings().forEach(warning -> LOGGER.warn("Query warning at [" + (Object)((Object)this.method) + "]: " + warning.getCode() + " - " + warning.getMessage()));
    }

    public ArangoQueryMethod getQueryMethod() {
        return this.method;
    }

    protected abstract String createQuery(ArangoParameterAccessor var1, Map<String, Object> var2, AqlQueryOptions var3);

    protected abstract boolean isCountQuery();

    protected abstract boolean isExistsQuery();

    protected AqlQueryOptions mergeQueryOptions(AqlQueryOptions oldStatic, AqlQueryOptions newDynamic) {
        Collection rules;
        Boolean profile;
        Boolean fullCount;
        Boolean count;
        Boolean cache;
        Integer ttl;
        Integer maxPlans;
        if (oldStatic == null) {
            return newDynamic;
        }
        if (newDynamic == null) {
            return oldStatic;
        }
        Integer batchSize = newDynamic.getBatchSize();
        if (batchSize != null) {
            oldStatic.batchSize(batchSize);
        }
        if ((maxPlans = newDynamic.getMaxPlans()) != null) {
            oldStatic.maxPlans(maxPlans);
        }
        if ((ttl = newDynamic.getTtl()) != null) {
            oldStatic.ttl(ttl);
        }
        if ((cache = newDynamic.getCache()) != null) {
            oldStatic.cache(cache);
        }
        if ((count = newDynamic.getCount()) != null) {
            oldStatic.count(count);
        }
        if ((fullCount = newDynamic.getFullCount()) != null) {
            oldStatic.fullCount(fullCount);
        }
        if ((profile = newDynamic.getProfile()) != null) {
            oldStatic.profile(profile);
        }
        if ((rules = newDynamic.getRules()) != null) {
            oldStatic.rules(rules);
        }
        return oldStatic;
    }

    private Class<?> getTypeToRead(ResultProcessor processor) {
        if (this.isExistsQuery()) {
            return Integer.class;
        }
        if (this.method.isGeoQuery()) {
            return VPackSlice.class;
        }
        Class<Map> typeToRead = processor.getReturnedType().getTypeToRead();
        return typeToRead != null ? typeToRead : Map.class;
    }

    private Object convertResult(ArangoCursor<?> result, ArangoParameterAccessor accessor) {
        if (this.isExistsQuery()) {
            if (!result.hasNext()) {
                return false;
            }
            return (Integer)result.next() > 0;
        }
        ArangoResultConverter resultConverter = new ArangoResultConverter(accessor, result, this.operations, this.domainClass);
        return resultConverter.convertResult(this.method.getReturnType().getType());
    }
}

