/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.repository.query;

import com.arangodb.model.AqlQueryOptions;
import com.arangodb.springframework.annotation.BindVars;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.springframework.core.MethodParameter;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.util.Assert;

public class ArangoParameters
extends Parameters<ArangoParameters, ArangoParameter> {
    private final int queryOptionsIndex;
    private final int bindVarsIndex;

    public ArangoParameters(Method method) {
        super(method);
        this.assertSingleSpecialParameter(ArangoParameter::isQueryOptions, "Multiple AqlQueryOptions parameters are not allowed! Offending method: " + method);
        this.assertSingleSpecialParameter(ArangoParameter::isBindVars, "Multiple @BindVars parameters are not allowed! Offending method: " + method);
        this.assertNonDuplicateParamNames(method);
        this.queryOptionsIndex = this.getIndexOfSpecialParameter(ArangoParameter::isQueryOptions);
        this.bindVarsIndex = this.getIndexOfSpecialParameter(ArangoParameter::isBindVars);
    }

    private ArangoParameters(List<ArangoParameter> parameters, int queryOptionsIndex, int bindVarsIndex) {
        super(parameters);
        this.queryOptionsIndex = queryOptionsIndex;
        this.bindVarsIndex = bindVarsIndex;
    }

    protected ArangoParameter createParameter(MethodParameter parameter) {
        return new ArangoParameter(parameter);
    }

    protected ArangoParameters createFrom(List<ArangoParameter> parameters) {
        return new ArangoParameters(parameters, this.queryOptionsIndex, this.bindVarsIndex);
    }

    public boolean hasQueryOptions() {
        return this.queryOptionsIndex != -1;
    }

    public int getQueryOptionsIndex() {
        return this.queryOptionsIndex;
    }

    public boolean hasBindVars() {
        return this.bindVarsIndex != -1;
    }

    public int getBindVarsIndex() {
        return this.bindVarsIndex;
    }

    private int getIndexOfSpecialParameter(Predicate<ArangoParameter> condition) {
        for (int index = 0; index < this.getNumberOfParameters(); ++index) {
            ArangoParameter param = (ArangoParameter)this.getParameter(index);
            if (!condition.test(param)) continue;
            return index;
        }
        return -1;
    }

    private void assertSingleSpecialParameter(Predicate<ArangoParameter> condition, String message) {
        boolean found = false;
        for (int index = 0; index < this.getNumberOfParameters(); ++index) {
            ArangoParameter param = (ArangoParameter)this.getParameter(index);
            if (!condition.test(param)) continue;
            Assert.isTrue((!found ? 1 : 0) != 0, (String)message);
            found = true;
        }
    }

    private void assertNonDuplicateParamNames(Method method) {
        ArangoParameters bindableParams = (ArangoParameters)this.getBindableParameters();
        int bindableParamsSize = bindableParams.getNumberOfParameters();
        HashSet paramNames = new HashSet(bindableParamsSize);
        for (int i = 0; i < bindableParamsSize; ++i) {
            ArangoParameter param = (ArangoParameter)bindableParams.getParameter(i);
            Optional name = param.getName();
            if (!name.isPresent()) continue;
            Assert.isTrue((!paramNames.contains(name.get()) ? 1 : 0) != 0, (String)("Duplicate parameter name! Offending method: " + method));
            paramNames.add(name.get());
        }
    }

    static class ArangoParameter
    extends Parameter {
        private static final Pattern BIND_PARAM_PATTERN = Pattern.compile("^@?[A-Za-z0-9][A-Za-z0-9_]*$");
        private static final String NAMED_PARAMETER_TEMPLATE = "@%s";
        private static final String POSITION_PARAMETER_TEMPLATE = "@%d";
        private final MethodParameter parameter;

        public ArangoParameter(MethodParameter parameter) {
            super(parameter);
            this.parameter = parameter;
            this.assertCorrectBindParamPattern();
            this.assertCorrectBindVarsType();
        }

        public boolean isSpecialParameter() {
            return super.isSpecialParameter() || this.isQueryOptions() || this.isBindVars();
        }

        public boolean isQueryOptions() {
            return AqlQueryOptions.class.isAssignableFrom(this.parameter.getParameterType());
        }

        public boolean isBindVars() {
            return this.parameter.hasParameterAnnotation(BindVars.class);
        }

        public String getPlaceholder() {
            if (this.isNamedParameter()) {
                return String.format(NAMED_PARAMETER_TEMPLATE, this.getName().get());
            }
            return String.format(POSITION_PARAMETER_TEMPLATE, this.getIndex());
        }

        private void assertCorrectBindParamPattern() {
            if (this.isExplicitlyNamed()) {
                String name = (String)this.getName().get();
                boolean matches = BIND_PARAM_PATTERN.matcher(name).matches();
                Assert.isTrue((boolean)matches, (String)("@Param has invalid format! Offending parameter: parameter " + this.parameter.getParameterIndex() + " on method " + this.parameter.getMethod()));
            }
        }

        private void assertCorrectBindVarsType() {
            String errorMsg = "@BindVars parameter must be of type Map<String, Object>! Offending parameter: parameter " + this.parameter.getParameterIndex() + " on method " + this.parameter.getMethod();
            if (this.isBindVars()) {
                Assert.isTrue((boolean)Map.class.equals((Object)this.parameter.getParameterType()), (String)errorMsg);
                Type type = this.parameter.getGenericParameterType();
                Assert.isTrue((boolean)ParameterizedType.class.isInstance(type), (String)errorMsg);
                Type[] genericTypes = ((ParameterizedType)type).getActualTypeArguments();
                Assert.isTrue((genericTypes.length == 2 ? 1 : 0) != 0, (String)errorMsg);
                Type keyType = genericTypes[0];
                Type valueType = genericTypes[1];
                Assert.isTrue((boolean)Class.class.isInstance(keyType), (String)errorMsg);
                Assert.isTrue((boolean)Class.class.isInstance(valueType), (String)errorMsg);
                Assert.isTrue((boolean)String.class.equals((Object)keyType), (String)errorMsg);
                Assert.isTrue((boolean)Object.class.equals((Object)valueType), (String)errorMsg);
            }
        }
    }
}

