/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.repository.query;

import com.arangodb.ArangoCursor;
import com.arangodb.springframework.core.ArangoOperations;
import com.arangodb.springframework.repository.query.ArangoParameterAccessor;
import com.arangodb.velocypack.VPackSlice;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Slice;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoPage;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Metrics;
import org.springframework.data.mapping.MappingException;
import org.springframework.util.Assert;

public class ArangoResultConverter {
    private static final String MISSING_FULL_COUNT = "Query result does not contain the full result count! The most likely cause is a forgotten LIMIT clause in the query.";
    private final ArangoParameterAccessor accessor;
    private final ArangoCursor<?> result;
    private final ArangoOperations operations;
    private final Class<?> domainClass;
    private static Map<Object, Method> TYPE_MAP = new HashMap<Object, Method>();

    public ArangoResultConverter(ArangoParameterAccessor accessor, ArangoCursor<?> result, ArangoOperations operations, Class<?> domainClass) {
        this.accessor = accessor;
        this.result = result;
        this.operations = operations;
        this.domainClass = domainClass;
    }

    public Object convertResult(Class<?> type) {
        try {
            if (type.isArray()) {
                return TYPE_MAP.get("array").invoke((Object)this, new Object[0]);
            }
            if (!TYPE_MAP.containsKey(type)) {
                return this.getNext(this.result);
            }
            return TYPE_MAP.get(type).invoke((Object)this, new Object[0]);
        }
        catch (Exception e) {
            throw new MappingException(String.format("Can't convert result to type %s!", type.getName()), (Throwable)e);
        }
    }

    private Set<?> buildSet(ArangoCursor<?> cursor) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(cursor, 0), false).collect(Collectors.toSet());
    }

    private GeoResult<?> buildGeoResult(ArangoCursor<?> cursor) {
        GeoResult geoResult = null;
        while (cursor.hasNext() && geoResult == null) {
            Double distanceInMeters;
            Object object = cursor.next();
            if (!(object instanceof VPackSlice)) continue;
            VPackSlice slice = (VPackSlice)object;
            VPackSlice distSlice = slice.get("_distance");
            Double d = distanceInMeters = distSlice.isDouble() ? Double.valueOf(distSlice.getAsDouble()) : null;
            if (distanceInMeters == null) continue;
            Object entity = this.operations.getConverter().read(this.domainClass, slice);
            Distance distance = new Distance(distanceInMeters / 1000.0, (Metric)Metrics.KILOMETERS);
            geoResult = new GeoResult(entity, distance);
        }
        return geoResult;
    }

    private GeoResult<?> buildGeoResult(Object object) {
        Double distanceInMeters;
        if (object == null || !(object instanceof VPackSlice)) {
            return null;
        }
        VPackSlice slice = (VPackSlice)object;
        VPackSlice distSlice = slice.get("_distance");
        Double d = distanceInMeters = distSlice.isDouble() ? Double.valueOf(distSlice.getAsDouble()) : null;
        if (distanceInMeters == null) {
            return null;
        }
        Object entity = this.operations.getConverter().read(this.domainClass, slice);
        Distance distance = new Distance(distanceInMeters / 1000.0, (Metric)Metrics.KILOMETERS);
        return new GeoResult(entity, distance);
    }

    private GeoResults<?> buildGeoResults(ArangoCursor<?> cursor) {
        LinkedList list = new LinkedList();
        cursor.forEachRemaining(o -> {
            GeoResult<?> geoResult = this.buildGeoResult(o);
            if (geoResult != null) {
                list.add(geoResult);
            }
        });
        return new GeoResults(list);
    }

    public Optional<?> convertOptional() {
        return Optional.ofNullable(this.getNext(this.result));
    }

    public List<?> convertList() {
        return this.result.asListRemaining();
    }

    public PageImpl<?> convertPage() {
        Assert.notNull((Object)this.result.getStats().getFullCount(), (String)MISSING_FULL_COUNT);
        return new PageImpl(this.result.asListRemaining(), this.accessor.getPageable(), this.result.getStats().getFullCount().longValue());
    }

    public Set<?> convertSet() {
        return this.buildSet(this.result);
    }

    public ArangoCursor<?> convertArangoCursor() {
        return this.result;
    }

    public GeoResult<?> convertGeoResult() {
        return this.buildGeoResult(this.result);
    }

    public GeoResults<?> convertGeoResults() {
        return this.buildGeoResults(this.result);
    }

    public GeoPage<?> convertGeoPage() {
        Assert.notNull((Object)this.result.getStats().getFullCount(), (String)MISSING_FULL_COUNT);
        return new GeoPage(this.buildGeoResults(this.result), this.accessor.getPageable(), this.result.getStats().getFullCount().longValue());
    }

    public Object convertArray() {
        return this.result.asListRemaining().toArray();
    }

    private Object getNext(ArangoCursor<?> cursor) {
        return cursor.hasNext() ? cursor.next() : null;
    }

    static {
        try {
            TYPE_MAP.put(List.class, ArangoResultConverter.class.getMethod("convertList", new Class[0]));
            TYPE_MAP.put(Iterable.class, ArangoResultConverter.class.getMethod("convertList", new Class[0]));
            TYPE_MAP.put(Collection.class, ArangoResultConverter.class.getMethod("convertList", new Class[0]));
            TYPE_MAP.put(Page.class, ArangoResultConverter.class.getMethod("convertPage", new Class[0]));
            TYPE_MAP.put(Slice.class, ArangoResultConverter.class.getMethod("convertPage", new Class[0]));
            TYPE_MAP.put(Set.class, ArangoResultConverter.class.getMethod("convertSet", new Class[0]));
            TYPE_MAP.put(ArangoCursor.class, ArangoResultConverter.class.getMethod("convertArangoCursor", new Class[0]));
            TYPE_MAP.put(GeoResult.class, ArangoResultConverter.class.getMethod("convertGeoResult", new Class[0]));
            TYPE_MAP.put(GeoResults.class, ArangoResultConverter.class.getMethod("convertGeoResults", new Class[0]));
            TYPE_MAP.put(GeoPage.class, ArangoResultConverter.class.getMethod("convertGeoPage", new Class[0]));
            TYPE_MAP.put(Optional.class, ArangoResultConverter.class.getMethod("convertOptional", new Class[0]));
            TYPE_MAP.put("array", ArangoResultConverter.class.getMethod("convertArray", new Class[0]));
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }
}

