/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.repository.query;

import com.arangodb.entity.IndexEntity;
import com.arangodb.entity.IndexType;
import com.arangodb.model.AqlQueryOptions;
import com.arangodb.springframework.core.ArangoOperations;
import com.arangodb.springframework.core.mapping.ArangoPersistentEntity;
import com.arangodb.springframework.core.mapping.ArangoPersistentProperty;
import com.arangodb.springframework.repository.query.AbstractArangoQuery;
import com.arangodb.springframework.repository.query.ArangoParameterAccessor;
import com.arangodb.springframework.repository.query.ArangoQueryMethod;
import com.arangodb.springframework.repository.query.derived.BindParameterBinding;
import com.arangodb.springframework.repository.query.derived.DerivedQueryCreator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.parser.PartTree;

public class DerivedArangoQuery
extends AbstractArangoQuery {
    private final PartTree tree;
    private final MappingContext<? extends ArangoPersistentEntity<?>, ArangoPersistentProperty> context;
    private final List<String> geoFields;

    public DerivedArangoQuery(ArangoQueryMethod method, ArangoOperations operations) {
        super(method, operations);
        this.tree = new PartTree(method.getName(), this.domainClass);
        this.context = operations.getConverter().getMappingContext();
        this.geoFields = this.getGeoFields();
    }

    @Override
    protected String createQuery(ArangoParameterAccessor accessor, Map<String, Object> bindVars, AqlQueryOptions options) {
        return (String)new DerivedQueryCreator(this.context, this.domainClass, this.tree, accessor, new BindParameterBinding(bindVars), this.geoFields).createQuery();
    }

    @Override
    protected boolean isCountQuery() {
        return this.tree.isCountProjection();
    }

    @Override
    protected boolean isExistsQuery() {
        return this.tree.isExistsProjection();
    }

    private List<String> getGeoFields() {
        LinkedList<String> geoFields = new LinkedList<String>();
        if (this.method.isGeoQuery()) {
            for (IndexEntity index : this.operations.collection(this.domainClass).getIndexes()) {
                IndexType type = index.getType();
                if (type != IndexType.geo && type != IndexType.geo1 && type != IndexType.geo2) continue;
                geoFields.addAll(index.getFields());
            }
        }
        return geoFields;
    }
}

