/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.repository.query.derived;

import com.arangodb.springframework.annotation.Relations;
import com.arangodb.springframework.core.mapping.ArangoPersistentEntity;
import com.arangodb.springframework.core.mapping.ArangoPersistentProperty;
import com.arangodb.springframework.core.util.AqlUtils;
import com.arangodb.springframework.repository.query.ArangoParameterAccessor;
import com.arangodb.springframework.repository.query.derived.BindParameterBinding;
import com.arangodb.springframework.repository.query.derived.Criteria;
import com.arangodb.springframework.repository.query.derived.geo.Ring;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Range;
import org.springframework.data.domain.Sort;
import org.springframework.data.geo.Box;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Point;
import org.springframework.data.geo.Polygon;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.Assert;

public class DerivedQueryCreator
extends AbstractQueryCreator<String, Criteria> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DerivedQueryCreator.class);
    private static final Set<Part.Type> UNSUPPORTED_IGNORE_CASE = new HashSet<Part.Type>();
    private final MappingContext<? extends ArangoPersistentEntity<?>, ArangoPersistentProperty> context;
    private final String collectionName;
    private final PartTree tree;
    private final ArangoParameterAccessor accessor;
    private final List<String> geoFields;
    private final Set<String> withCollections;
    private final BindParameterBinding binding;
    private Point uniquePoint = null;
    private String uniqueLocation = null;
    private Boolean isUnique = null;
    private int bindingCounter = 0;

    public DerivedQueryCreator(MappingContext<? extends ArangoPersistentEntity<?>, ArangoPersistentProperty> context, Class<?> domainClass, PartTree tree, ArangoParameterAccessor accessor, BindParameterBinding binder, List<String> geoFields) {
        super(tree, (ParameterAccessor)accessor);
        this.context = context;
        this.collectionName = AqlUtils.buildCollectionName(((ArangoPersistentEntity)context.getPersistentEntity(domainClass)).getCollection());
        this.tree = tree;
        this.accessor = accessor;
        this.geoFields = geoFields;
        this.binding = binder;
        this.withCollections = new HashSet<String>();
    }

    protected Criteria create(Part part, Iterator<Object> iterator) {
        return this.and(part, new Criteria(), iterator);
    }

    protected Criteria and(Part part, Criteria base, Iterator<Object> iterator) {
        return base.and(this.createCriteria(part, iterator));
    }

    protected Criteria or(Criteria base, Criteria criteria) {
        return base.or(criteria);
    }

    protected String complete(Criteria criteria, Sort sort) {
        Pageable pageable;
        if (this.tree.isDistinct() && !this.tree.isCountProjection()) {
            LOGGER.debug("Use of 'Distinct' is meaningful only in count queries");
        }
        StringBuilder query = new StringBuilder();
        String with = this.withCollections.stream().collect(Collectors.joining(", "));
        if (!with.isEmpty()) {
            query.append("WITH ").append(with).append(" ");
        }
        query.append("FOR ").append("e").append(" IN ").append(this.collectionName);
        if (!criteria.getPredicate().isEmpty()) {
            query.append(" FILTER ").append(criteria.getPredicate());
        }
        if (this.tree.isCountProjection() || this.tree.isExistsProjection()) {
            if (this.tree.isDistinct()) {
                query.append(" COLLECT entity = ").append("e");
            }
            query.append(" COLLECT WITH COUNT INTO length");
        }
        String sortString = " " + AqlUtils.buildSortClause(sort, "e");
        if (!(this.geoFields.isEmpty() && (this.isUnique == null || !this.isUnique.booleanValue()) || this.tree.isDelete() || this.tree.isCountProjection() || this.tree.isExistsProjection())) {
            String distanceSortKey = " SORT " + Criteria.distance(this.uniqueLocation, this.bind(this.getUniquePoint()[0]), this.bind(this.getUniquePoint()[1])).getPredicate();
            sortString = sort.isUnsorted() ? distanceSortKey : distanceSortKey + ", " + sortString.substring(5, sortString.length());
        }
        query.append(sortString);
        if (this.tree.isLimiting()) {
            query.append(" LIMIT ").append(this.tree.getMaxResults());
        }
        if ((pageable = this.accessor.getPageable()) != null && pageable.isPaged()) {
            query.append(" ").append(AqlUtils.buildLimitClause(pageable));
        }
        if (this.tree.isDelete()) {
            query.append(" REMOVE e IN ").append(this.collectionName);
        } else if (this.tree.isCountProjection() || this.tree.isExistsProjection()) {
            query.append(" RETURN length");
        } else {
            query.append(" RETURN ");
            if (this.geoFields.isEmpty()) {
                query.append("e");
            } else {
                query.append(this.format("MERGE(e, { '_distance': %s })", Criteria.distance(this.uniqueLocation, this.bind(this.getUniquePoint()[0]), this.bind(this.getUniquePoint()[1])).getPredicate()));
            }
        }
        return query.toString();
    }

    public double[] getUniquePoint() {
        if (this.uniquePoint == null) {
            return new double[2];
        }
        return new double[]{this.uniquePoint.getY(), this.uniquePoint.getX()};
    }

    private String ignorePropertyCase(Part part) {
        String property = this.getProperty(part);
        return this.ignorePropertyCase(part, property);
    }

    private String ignorePropertyCase(Part part, String property) {
        if (!this.shouldIgnoreCase(part)) {
            return property;
        }
        if (!part.getProperty().getLeafProperty().isCollection()) {
            return "LOWER(" + property + ")";
        }
        return this.format("(FOR i IN TO_ARRAY(%s) RETURN LOWER(i))", property);
    }

    private String getProperty(Part part) {
        return "e." + this.context.getPersistentPropertyPath(part.getProperty()).toPath(".", ArangoPersistentProperty::getFieldName);
    }

    private String[] createPredicateTemplateAndPropertyString(Part part) {
        int varsUsed = 0;
        String PREDICATE_TEMPLATE = "(%s FILTER %%s RETURN 1)[0] == 1";
        PersistentPropertyPath persistentPropertyPath = this.context.getPersistentPropertyPath(part.getProperty());
        StringBuilder simpleProperties = new StringBuilder();
        String predicateTemplate = "";
        int propertiesLeft = persistentPropertyPath.getLength();
        for (Object object : persistentPropertyPath) {
            String predicate;
            String iteration;
            String name;
            String collection;
            String entity;
            String prevEntity;
            String TEMPLATE;
            ArangoPersistentProperty property = (ArangoPersistentProperty)object;
            if (--propertiesLeft == 0) {
                simpleProperties.append("." + property.getFieldName());
                break;
            }
            if (property.getRelations().isPresent()) {
                TEMPLATE = "FOR %s IN %s %s %s%s._id %s";
                String nested = simpleProperties.toString();
                Relations relations = property.getRelations().get();
                String direction = relations.direction().name();
                String depths = this.format("%s..%d", relations.minDepth(), relations.maxDepth());
                Class<?>[] edgeClasses = relations.edges();
                StringBuilder edgesBuilder = new StringBuilder();
                for (Class<?> edge : edgeClasses) {
                    String collection2 = ((ArangoPersistentEntity)this.context.getPersistentEntity(edge)).getCollection();
                    if (collection2.split("-").length > 1) {
                        collection2 = "`" + collection2 + "`";
                    }
                    edgesBuilder.append((edgesBuilder.length() == 0 ? "" : ", ") + collection2);
                }
                String prevEntity2 = "e" + (varsUsed == 0 ? "" : Integer.toString(varsUsed));
                String entity2 = "e" + Integer.toString(++varsUsed);
                String edges = edgesBuilder.toString();
                simpleProperties = new StringBuilder();
                String iteration2 = this.format("FOR %s IN %s %s %s%s._id %s", entity2, depths, direction, prevEntity2, nested, edges);
                String predicate2 = this.format("(%s FILTER %%s RETURN 1)[0] == 1", iteration2);
                predicateTemplate = predicateTemplate.length() == 0 ? predicate2 : this.format(predicateTemplate, predicate2);
                continue;
            }
            if (property.isCollectionLike()) {
                if (property.getRef().isPresent()) {
                    TEMPLATE = "FOR %s IN %s FILTER %s._id IN %s%s";
                    prevEntity = "e" + (varsUsed == 0 ? "" : Integer.toString(varsUsed));
                    entity = "e" + Integer.toString(++varsUsed);
                    collection = ((ArangoPersistentEntity)this.context.getPersistentEntity(property.getComponentType())).getCollection();
                    if (collection.split("-").length > 1) {
                        collection = "`" + collection + "`";
                    }
                    name = simpleProperties.toString() + "." + property.getFieldName();
                    simpleProperties = new StringBuilder();
                    iteration = this.format("FOR %s IN %s FILTER %s._id IN %s%s", entity, collection, entity, prevEntity, name);
                    predicate = this.format("(%s FILTER %%s RETURN 1)[0] == 1", iteration);
                    predicateTemplate = predicateTemplate.length() == 0 ? predicate : this.format(predicateTemplate, predicate);
                    continue;
                }
                TEMPLATE = "FOR %s IN TO_ARRAY(%s%s)";
                prevEntity = "e" + (varsUsed == 0 ? "" : Integer.toString(varsUsed));
                entity = "e" + Integer.toString(++varsUsed);
                String name2 = simpleProperties.toString() + "." + property.getFieldName();
                simpleProperties = new StringBuilder();
                String iteration3 = this.format("FOR %s IN TO_ARRAY(%s%s)", entity, prevEntity, name2);
                String predicate3 = this.format("(%s FILTER %%s RETURN 1)[0] == 1", iteration3);
                predicateTemplate = predicateTemplate.length() == 0 ? predicate3 : this.format(predicateTemplate, predicate3);
                continue;
            }
            if (property.getRef().isPresent() || property.getFrom().isPresent() || property.getTo().isPresent()) {
                TEMPLATE = "FOR %s IN %s FILTER %s._id == %s%s";
                prevEntity = "e" + (varsUsed == 0 ? "" : Integer.toString(varsUsed));
                entity = "e" + Integer.toString(++varsUsed);
                collection = ((ArangoPersistentEntity)this.context.getPersistentEntity(property.getType())).getCollection();
                if (collection.split("-").length > 1) {
                    collection = "`" + collection + "`";
                }
                name = simpleProperties.toString() + "." + property.getFieldName();
                simpleProperties = new StringBuilder();
                iteration = this.format("FOR %s IN %s FILTER %s._id == %s%s", entity, collection, entity, prevEntity, name);
                predicate = this.format("(%s FILTER %%s RETURN 1)[0] == 1", iteration);
                predicateTemplate = predicateTemplate.length() == 0 ? predicate : this.format(predicateTemplate, predicate);
                continue;
            }
            simpleProperties.append("." + property.getFieldName());
        }
        return new String[]{predicateTemplate, "e" + (varsUsed == 0 ? "" : Integer.toString(varsUsed)) + simpleProperties.toString()};
    }

    private boolean shouldIgnoreCase(Part part) {
        boolean shouldIgnoreCase;
        Class propertyClass = part.getProperty().getLeafProperty().getType();
        boolean isLowerable = String.class.isAssignableFrom(propertyClass);
        boolean bl = shouldIgnoreCase = part.shouldIgnoreCase() != Part.IgnoreCaseType.NEVER && isLowerable && !UNSUPPORTED_IGNORE_CASE.contains(part.getType());
        if (part.shouldIgnoreCase() == Part.IgnoreCaseType.ALWAYS && (!isLowerable || UNSUPPORTED_IGNORE_CASE.contains(part.getType()))) {
            LOGGER.debug("Ignoring case for \"{}\" type is meaningless", (Object)propertyClass);
        }
        return shouldIgnoreCase;
    }

    private void checkUniquePoint(Point point) {
        boolean isStillUnique;
        boolean bl = isStillUnique = this.uniquePoint == null || this.uniquePoint.equals((Object)point);
        if (!isStillUnique) {
            this.isUnique = false;
        }
        if (!this.geoFields.isEmpty()) {
            Assert.isTrue((this.uniquePoint == null || this.uniquePoint.equals((Object)point) ? 1 : 0) != 0, (String)"Different Points are used - Distance is ambiguous");
            this.uniquePoint = point;
        }
    }

    private void checkUniqueLocation(Part part) {
        this.isUnique = this.isUnique == null ? true : this.isUnique;
        this.isUnique = this.uniqueLocation == null || this.uniqueLocation.equals(this.ignorePropertyCase(part)) ? this.isUnique : false;
        if (!this.geoFields.isEmpty()) {
            Assert.isTrue((boolean)this.isUnique, (String)"Different location fields are used - Distance is ambiguous");
        }
        this.uniqueLocation = this.ignorePropertyCase(part);
    }

    private Criteria createCriteria(Part part, Iterator<Object> iterator) {
        this.collectWithCollections(part.getProperty());
        String[] templateAndProperty = this.createPredicateTemplateAndPropertyString(part);
        String template = templateAndProperty[0];
        String property = templateAndProperty[1];
        Criteria criteria = null;
        boolean checkUnique = part.getProperty().toDotPath().split(".").length <= 1;
        switch (part.getType()) {
            case SIMPLE_PROPERTY: {
                criteria = Criteria.eql(this.ignorePropertyCase(part, property), this.bind(part, iterator));
                break;
            }
            case NEGATING_SIMPLE_PROPERTY: {
                criteria = Criteria.neql(this.ignorePropertyCase(part, property), this.bind(part, iterator));
                break;
            }
            case TRUE: {
                criteria = Criteria.isTrue(this.ignorePropertyCase(part, property));
                break;
            }
            case FALSE: {
                criteria = Criteria.isFalse(this.ignorePropertyCase(part, property));
                break;
            }
            case IS_NULL: {
                criteria = Criteria.isNull(this.ignorePropertyCase(part, property));
                break;
            }
            case IS_NOT_NULL: {
                criteria = Criteria.isNotNull(this.ignorePropertyCase(part, property));
                break;
            }
            case EXISTS: {
                String document = property.substring(0, property.lastIndexOf("."));
                String attribute = property.substring(property.lastIndexOf(".") + 1, property.length());
                criteria = Criteria.exists(document, attribute);
                break;
            }
            case BEFORE: 
            case LESS_THAN: {
                criteria = Criteria.lt(this.ignorePropertyCase(part, property), this.bind(part, iterator));
                break;
            }
            case AFTER: 
            case GREATER_THAN: {
                criteria = Criteria.gt(this.ignorePropertyCase(part, property), this.bind(part, iterator));
                break;
            }
            case LESS_THAN_EQUAL: {
                criteria = Criteria.lte(this.ignorePropertyCase(part, property), this.bind(part, iterator));
                break;
            }
            case GREATER_THAN_EQUAL: {
                criteria = Criteria.gte(this.ignorePropertyCase(part, property), this.bind(part, iterator));
                break;
            }
            case BETWEEN: {
                criteria = Criteria.gte(this.ignorePropertyCase(part, property), this.bind(part, iterator)).and(Criteria.lte(this.ignorePropertyCase(part, property), this.bind(part, iterator)));
                break;
            }
            case LIKE: {
                criteria = Criteria.like(this.ignorePropertyCase(part, property), this.bind(part, iterator));
                break;
            }
            case NOT_LIKE: {
                criteria = Criteria.notLike(this.ignorePropertyCase(part, property), this.bind(part, iterator));
                break;
            }
            case STARTING_WITH: {
                criteria = Criteria.like(this.ignorePropertyCase(part, property), this.bind(part, iterator, (Boolean)true));
                break;
            }
            case ENDING_WITH: {
                criteria = Criteria.like(this.ignorePropertyCase(part, property), this.bind(part, iterator, (Boolean)false));
                break;
            }
            case REGEX: {
                criteria = Criteria.regex(this.ignorePropertyCase(part, property), this.bind(part, iterator), this.shouldIgnoreCase(part));
                break;
            }
            case IN: {
                criteria = Criteria.in(this.ignorePropertyCase(part, property), this.bind(part, iterator));
                break;
            }
            case NOT_IN: {
                criteria = Criteria.nin(this.ignorePropertyCase(part, property), this.bind(part, iterator));
                break;
            }
            case CONTAINING: {
                if (part.getProperty().getTypeInformation().isCollectionLike()) {
                    criteria = Criteria.in(this.bind(part, iterator), this.ignorePropertyCase(part, property));
                    break;
                }
                criteria = Criteria.contains(this.ignorePropertyCase(part, property), this.bind(part, iterator));
                break;
            }
            case NOT_CONTAINING: {
                criteria = Criteria.nin(this.bind(part, iterator), this.ignorePropertyCase(part, property));
                break;
            }
            case NEAR: {
                if (checkUnique) {
                    this.checkUniqueLocation(part);
                }
                Assert.isTrue((boolean)iterator.hasNext(), (String)"Too few arguments passed");
                Object nearValue = iterator.next();
                Class<?> nearClazz = nearValue.getClass();
                if (nearClazz != Point.class) {
                    this.bindingCounter = this.binding.bind(nearValue, this.shouldIgnoreCase(part), null, point -> this.checkUniquePoint(point), this.bindingCounter);
                }
                criteria = null;
                break;
            }
            case WITHIN: {
                if (checkUnique) {
                    this.checkUniqueLocation(part);
                }
                int index = this.bindingCounter;
                for (int i = 0; iterator.hasNext() && i < 2; ++i) {
                    Object value = iterator.next();
                    Class<?> clazz = value.getClass();
                    if (clazz == Range.class || clazz == Ring.class) {
                        if (checkUnique) {
                            this.checkUniqueLocation(part);
                        }
                        criteria = Criteria.lte(index + 2, Criteria.distance(this.ignorePropertyCase(part, property), index, index + 1).getPredicate()).and(Criteria.lte(Criteria.distance(this.ignorePropertyCase(part, property), index, index + 1).getPredicate(), index + 3));
                        if (clazz == Range.class) {
                            this.bindRange(part, value);
                            break;
                        }
                        this.bindRing(part, value);
                        break;
                    }
                    if (clazz == Box.class) {
                        criteria = Criteria.lte(index, this.ignorePropertyCase(part, property) + "[0]").and(Criteria.lte(this.ignorePropertyCase(part, property) + "[0]", index + 1)).and(Criteria.lte(index + 2, this.ignorePropertyCase(part, property) + "[1]")).and(Criteria.lte(this.ignorePropertyCase(part, property) + "[1]", index + 3));
                        this.bindBox(part, value);
                        break;
                    }
                    if (clazz == Polygon.class) {
                        criteria = Criteria.isInPolygon(this.bindPolygon(part, value), this.ignorePropertyCase(part, property));
                        break;
                    }
                    if (clazz == Circle.class) {
                        this.bindCircle(part, value);
                        break;
                    }
                    if (clazz == Point.class) {
                        this.bindPoint(part, value);
                        continue;
                    }
                    this.bind(part, value, null);
                }
                if (criteria != null) break;
                criteria = Criteria.lte(Criteria.distance(this.ignorePropertyCase(part, property), index, index + 1).getPredicate(), index + 2);
                break;
            }
            default: {
                throw new IllegalArgumentException(this.format("Part.Type \"%s\" not supported", part.getType().toString()));
            }
        }
        if (!this.geoFields.isEmpty()) {
            Assert.isTrue((this.isUnique == null || this.isUnique != false ? 1 : 0) != 0, (String)"Distance is ambiguous for multiple locations");
        }
        return template.isEmpty() ? criteria : new Criteria(this.format(template, criteria.getPredicate()));
    }

    private int bind(Part part, Iterator<Object> iterator) {
        return this.bind(part, iterator, null);
    }

    private int bind(Part part, Iterator<Object> iterator, Boolean borderStatus) {
        Assert.isTrue((boolean)iterator.hasNext(), (String)"Too few arguments passed");
        return this.bind(part, iterator.next(), borderStatus);
    }

    private int bind(Part part, Object value, Boolean borderStatus) {
        int index = this.bindingCounter;
        this.bindingCounter = this.binding.bind(value, this.shouldIgnoreCase(part), borderStatus, point -> this.checkUniquePoint(point), this.bindingCounter);
        return index;
    }

    private int bind(Object value) {
        int index = this.bindingCounter;
        this.bindingCounter = this.binding.bind(value, false, null, point -> this.checkUniquePoint(point), this.bindingCounter);
        return index;
    }

    private void bindPoint(Part part, Object value) {
        this.bindingCounter = this.binding.bindPoint(value, this.shouldIgnoreCase(part), point -> this.checkUniquePoint(point), this.bindingCounter);
    }

    private void bindCircle(Part part, Object value) {
        this.bindingCounter = this.binding.bindCircle(value, this.shouldIgnoreCase(part), point -> this.checkUniquePoint(point), this.bindingCounter);
    }

    private void bindRange(Part part, Object value) {
        this.bindingCounter = this.binding.bindRange(value, this.shouldIgnoreCase(part), this.bindingCounter);
    }

    private void bindRing(Part part, Object value) {
        this.bindingCounter = this.binding.bindRing(value, this.shouldIgnoreCase(part), point -> this.checkUniquePoint(point), this.bindingCounter);
    }

    private void bindBox(Part part, Object value) {
        this.bindingCounter = this.binding.bindBox(value, this.shouldIgnoreCase(part), this.bindingCounter);
    }

    private int bindPolygon(Part part, Object value) {
        int index = this.bindingCounter;
        this.bindingCounter = this.binding.bindPolygon(value, this.shouldIgnoreCase(part), this.bindingCounter);
        return index;
    }

    private void collectWithCollections(PropertyPath propertyPath) {
        propertyPath.stream().map(property -> property.isCollection() ? property.getTypeInformation().getComponentType() : property.getTypeInformation()).map(type -> (ArangoPersistentEntity)this.context.getPersistentEntity(type)).filter(entity -> entity != null).map(entity -> AqlUtils.buildCollectionName(entity.getCollection())).forEach(this.withCollections::add);
    }

    private String format(String format, Object ... args) {
        return String.format(Locale.ENGLISH, format, args);
    }

    static {
        UNSUPPORTED_IGNORE_CASE.add(Part.Type.EXISTS);
        UNSUPPORTED_IGNORE_CASE.add(Part.Type.TRUE);
        UNSUPPORTED_IGNORE_CASE.add(Part.Type.FALSE);
        UNSUPPORTED_IGNORE_CASE.add(Part.Type.IS_NULL);
        UNSUPPORTED_IGNORE_CASE.add(Part.Type.IS_NOT_NULL);
        UNSUPPORTED_IGNORE_CASE.add(Part.Type.NEAR);
        UNSUPPORTED_IGNORE_CASE.add(Part.Type.WITHIN);
    }
}

