/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.config;

import java.util.Objects;

public class HostDescription {
    private final String host;
    private final int port;

    public static HostDescription parse(CharSequence value) {
        Objects.requireNonNull(value);
        String[] split = value.toString().split(":");
        if (split.length != 2) {
            throw new IllegalArgumentException("Could not parse host. Expected hostname:port, but got: " + value);
        }
        return new HostDescription(split[0], Integer.parseInt(split[1]));
    }

    public HostDescription(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return String.format("host[addr=%s,port=%s]", this.host, this.port);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostDescription that = (HostDescription)o;
        return this.port == that.port && Objects.equals(this.host, that.host);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }
}

