/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoCollection;
import com.arangodb.ArangoDBException;
import com.arangodb.ArangoDatabase;
import com.arangodb.entity.CollectionEntity;
import com.arangodb.entity.CollectionPropertiesEntity;
import com.arangodb.entity.CollectionRevisionEntity;
import com.arangodb.entity.DocumentCreateEntity;
import com.arangodb.entity.DocumentDeleteEntity;
import com.arangodb.entity.DocumentImportEntity;
import com.arangodb.entity.DocumentUpdateEntity;
import com.arangodb.entity.IndexEntity;
import com.arangodb.entity.InvertedIndexEntity;
import com.arangodb.entity.MultiDocumentEntity;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.ShardEntity;
import com.arangodb.internal.ArangoDatabaseImpl;
import com.arangodb.internal.ArangoErrors;
import com.arangodb.internal.InternalArangoCollection;
import com.arangodb.internal.serde.SerdeUtils;
import com.arangodb.model.CollectionCountOptions;
import com.arangodb.model.CollectionCreateOptions;
import com.arangodb.model.CollectionPropertiesOptions;
import com.arangodb.model.CollectionTruncateOptions;
import com.arangodb.model.DocumentCreateOptions;
import com.arangodb.model.DocumentDeleteOptions;
import com.arangodb.model.DocumentExistsOptions;
import com.arangodb.model.DocumentImportOptions;
import com.arangodb.model.DocumentReadOptions;
import com.arangodb.model.DocumentReplaceOptions;
import com.arangodb.model.DocumentUpdateOptions;
import com.arangodb.model.FulltextIndexOptions;
import com.arangodb.model.GeoIndexOptions;
import com.arangodb.model.InvertedIndexOptions;
import com.arangodb.model.MDIndexOptions;
import com.arangodb.model.MDPrefixedIndexOptions;
import com.arangodb.model.PersistentIndexOptions;
import com.arangodb.model.TtlIndexOptions;
import com.arangodb.model.ZKDIndexOptions;
import com.arangodb.util.RawData;
import java.lang.reflect.Type;
import java.util.Collection;

public class ArangoCollectionImpl
extends InternalArangoCollection
implements ArangoCollection {
    private final ArangoDatabase db;

    protected ArangoCollectionImpl(ArangoDatabaseImpl db, String name) {
        super(db, db.name(), name);
        this.db = db;
    }

    @Override
    public ArangoDatabase db() {
        return this.db;
    }

    @Override
    public DocumentCreateEntity<Void> insertDocument(Object value) {
        return (DocumentCreateEntity)this.executorSync().execute(this.insertDocumentRequest(value, new DocumentCreateOptions()), SerdeUtils.constructParametricType(DocumentCreateEntity.class, new Type[]{Void.class}));
    }

    @Override
    public <T> DocumentCreateEntity<T> insertDocument(T value, DocumentCreateOptions options) {
        return this.insertDocument(value, options, value.getClass());
    }

    @Override
    public <T> DocumentCreateEntity<T> insertDocument(T value, DocumentCreateOptions options, Class<T> type) {
        return (DocumentCreateEntity)this.executorSync().execute(this.insertDocumentRequest(value, options), SerdeUtils.constructParametricType(DocumentCreateEntity.class, type));
    }

    @Override
    public MultiDocumentEntity<DocumentCreateEntity<Void>> insertDocuments(RawData values) {
        return this.executorSync().execute(this.insertDocumentsRequest(values, new DocumentCreateOptions()), this.insertDocumentsResponseDeserializer(Void.class));
    }

    @Override
    public MultiDocumentEntity<DocumentCreateEntity<RawData>> insertDocuments(RawData values, DocumentCreateOptions options) {
        return this.executorSync().execute(this.insertDocumentsRequest(values, options), this.insertDocumentsResponseDeserializer(values.getClass()));
    }

    @Override
    public MultiDocumentEntity<DocumentCreateEntity<Void>> insertDocuments(Iterable<?> values) {
        return this.insertDocuments(values, new DocumentCreateOptions());
    }

    @Override
    public MultiDocumentEntity<DocumentCreateEntity<Void>> insertDocuments(Iterable<?> values, DocumentCreateOptions options) {
        return this.executorSync().execute(this.insertDocumentsRequest(values, options), this.insertDocumentsResponseDeserializer(Void.class));
    }

    @Override
    public <T> MultiDocumentEntity<DocumentCreateEntity<T>> insertDocuments(Iterable<? extends T> values, DocumentCreateOptions options, Class<T> type) {
        return this.executorSync().execute(this.insertDocumentsRequest(values, options), this.insertDocumentsResponseDeserializer(type));
    }

    @Override
    public DocumentImportEntity importDocuments(Iterable<?> values) {
        return this.importDocuments(values, new DocumentImportOptions());
    }

    @Override
    public DocumentImportEntity importDocuments(Iterable<?> values, DocumentImportOptions options) {
        return (DocumentImportEntity)this.executorSync().execute(this.importDocumentsRequest(values, options), (Type)((Object)DocumentImportEntity.class));
    }

    @Override
    public DocumentImportEntity importDocuments(RawData values) {
        return this.importDocuments(values, new DocumentImportOptions());
    }

    @Override
    public DocumentImportEntity importDocuments(RawData values, DocumentImportOptions options) {
        return (DocumentImportEntity)this.executorSync().execute(this.importDocumentsRequest(values, options), (Type)((Object)DocumentImportEntity.class));
    }

    @Override
    public <T> T getDocument(String key, Class<T> type) {
        return this.getDocument(key, type, new DocumentReadOptions());
    }

    @Override
    public <T> T getDocument(String key, Class<T> type, DocumentReadOptions options) {
        try {
            return this.executorSync().execute(this.getDocumentRequest(key, options), this.getDocumentResponseDeserializer(type));
        }
        catch (ArangoDBException e) {
            if (ArangoErrors.matches(e, 304) || ArangoErrors.matches(e, 404, ArangoErrors.ERROR_ARANGO_DOCUMENT_NOT_FOUND) || ArangoErrors.matches(e, 412, ArangoErrors.ERROR_ARANGO_CONFLICT)) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public <T> MultiDocumentEntity<T> getDocuments(Iterable<String> keys, Class<T> type) {
        return this.getDocuments(keys, type, new DocumentReadOptions());
    }

    @Override
    public <T> MultiDocumentEntity<T> getDocuments(Iterable<String> keys, Class<T> type, DocumentReadOptions options) {
        return this.executorSync().execute(this.getDocumentsRequest(keys, options), this.getDocumentsResponseDeserializer(type));
    }

    @Override
    public DocumentUpdateEntity<Void> replaceDocument(String key, Object value) {
        return (DocumentUpdateEntity)this.executorSync().execute(this.replaceDocumentRequest(key, value, new DocumentReplaceOptions()), SerdeUtils.constructParametricType(DocumentUpdateEntity.class, new Type[]{Void.class}));
    }

    @Override
    public <T> DocumentUpdateEntity<T> replaceDocument(String key, T value, DocumentReplaceOptions options) {
        return this.replaceDocument(key, value, options, value.getClass());
    }

    @Override
    public <T> DocumentUpdateEntity<T> replaceDocument(String key, T value, DocumentReplaceOptions options, Class<T> type) {
        return (DocumentUpdateEntity)this.executorSync().execute(this.replaceDocumentRequest(key, value, options), SerdeUtils.constructParametricType(DocumentUpdateEntity.class, type));
    }

    @Override
    public MultiDocumentEntity<DocumentUpdateEntity<Void>> replaceDocuments(RawData values) {
        return this.executorSync().execute(this.replaceDocumentsRequest(values, new DocumentReplaceOptions()), this.replaceDocumentsResponseDeserializer(Void.class));
    }

    @Override
    public MultiDocumentEntity<DocumentUpdateEntity<RawData>> replaceDocuments(RawData values, DocumentReplaceOptions options) {
        return this.executorSync().execute(this.replaceDocumentsRequest(values, options), this.replaceDocumentsResponseDeserializer(values.getClass()));
    }

    @Override
    public MultiDocumentEntity<DocumentUpdateEntity<Void>> replaceDocuments(Iterable<?> values) {
        return this.replaceDocuments(values, new DocumentReplaceOptions());
    }

    @Override
    public MultiDocumentEntity<DocumentUpdateEntity<Void>> replaceDocuments(Iterable<?> values, DocumentReplaceOptions options) {
        return this.executorSync().execute(this.replaceDocumentsRequest(values, options), this.replaceDocumentsResponseDeserializer(Void.class));
    }

    @Override
    public <T> MultiDocumentEntity<DocumentUpdateEntity<T>> replaceDocuments(Iterable<? extends T> values, DocumentReplaceOptions options, Class<T> type) {
        return this.executorSync().execute(this.replaceDocumentsRequest(values, options), this.replaceDocumentsResponseDeserializer(type));
    }

    @Override
    public DocumentUpdateEntity<Void> updateDocument(String key, Object value) {
        return this.updateDocument(key, value, new DocumentUpdateOptions(), Void.class);
    }

    @Override
    public <T> DocumentUpdateEntity<T> updateDocument(String key, T value, DocumentUpdateOptions options) {
        return this.updateDocument(key, value, options, value.getClass());
    }

    @Override
    public <T> DocumentUpdateEntity<T> updateDocument(String key, Object value, DocumentUpdateOptions options, Class<T> returnType) {
        return (DocumentUpdateEntity)this.executorSync().execute(this.updateDocumentRequest(key, value, options), SerdeUtils.constructParametricType(DocumentUpdateEntity.class, returnType));
    }

    @Override
    public MultiDocumentEntity<DocumentUpdateEntity<Void>> updateDocuments(RawData values) {
        return this.executorSync().execute(this.updateDocumentsRequest(values, new DocumentUpdateOptions()), this.updateDocumentsResponseDeserializer(Void.class));
    }

    @Override
    public MultiDocumentEntity<DocumentUpdateEntity<RawData>> updateDocuments(RawData values, DocumentUpdateOptions options) {
        return this.executorSync().execute(this.updateDocumentsRequest(values, options), this.updateDocumentsResponseDeserializer(values.getClass()));
    }

    @Override
    public MultiDocumentEntity<DocumentUpdateEntity<Void>> updateDocuments(Iterable<?> values) {
        return this.updateDocuments(values, new DocumentUpdateOptions());
    }

    @Override
    public MultiDocumentEntity<DocumentUpdateEntity<Void>> updateDocuments(Iterable<?> values, DocumentUpdateOptions options) {
        return this.updateDocuments(values, options, Void.class);
    }

    @Override
    public <T> MultiDocumentEntity<DocumentUpdateEntity<T>> updateDocuments(Iterable<?> values, DocumentUpdateOptions options, Class<T> returnType) {
        return this.executorSync().execute(this.updateDocumentsRequest(values, options), this.updateDocumentsResponseDeserializer(returnType));
    }

    @Override
    public DocumentDeleteEntity<Void> deleteDocument(String key) {
        return this.deleteDocument(key, new DocumentDeleteOptions());
    }

    @Override
    public DocumentDeleteEntity<Void> deleteDocument(String key, DocumentDeleteOptions options) {
        return this.deleteDocument(key, options, Void.class);
    }

    @Override
    public <T> DocumentDeleteEntity<T> deleteDocument(String key, DocumentDeleteOptions options, Class<T> type) {
        return (DocumentDeleteEntity)this.executorSync().execute(this.deleteDocumentRequest(key, options), SerdeUtils.constructParametricType(DocumentDeleteEntity.class, type));
    }

    @Override
    public MultiDocumentEntity<DocumentDeleteEntity<Void>> deleteDocuments(RawData values) {
        return this.executorSync().execute(this.deleteDocumentsRequest(values, new DocumentDeleteOptions()), this.deleteDocumentsResponseDeserializer(Void.class));
    }

    @Override
    public MultiDocumentEntity<DocumentDeleteEntity<RawData>> deleteDocuments(RawData values, DocumentDeleteOptions options) {
        return this.executorSync().execute(this.deleteDocumentsRequest(values, options), this.deleteDocumentsResponseDeserializer(values.getClass()));
    }

    @Override
    public MultiDocumentEntity<DocumentDeleteEntity<Void>> deleteDocuments(Iterable<?> values) {
        return this.deleteDocuments(values, new DocumentDeleteOptions());
    }

    @Override
    public MultiDocumentEntity<DocumentDeleteEntity<Void>> deleteDocuments(Iterable<?> values, DocumentDeleteOptions options) {
        return this.deleteDocuments(values, options, Void.class);
    }

    @Override
    public <T> MultiDocumentEntity<DocumentDeleteEntity<T>> deleteDocuments(Iterable<?> values, DocumentDeleteOptions options, Class<T> type) {
        return this.executorSync().execute(this.deleteDocumentsRequest(values, options), this.deleteDocumentsResponseDeserializer(type));
    }

    @Override
    public Boolean documentExists(String key) {
        return this.documentExists(key, new DocumentExistsOptions());
    }

    @Override
    public Boolean documentExists(String key, DocumentExistsOptions options) {
        try {
            this.executorSync().execute(this.documentExistsRequest(key, options), (Type)((Object)Void.class));
            return true;
        }
        catch (ArangoDBException e) {
            if (ArangoErrors.matches(e, 304) || ArangoErrors.matches(e, 404) || ArangoErrors.matches(e, 412)) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public IndexEntity getIndex(String id) {
        return (IndexEntity)this.executorSync().execute(this.getIndexRequest(id), (Type)((Object)IndexEntity.class));
    }

    @Override
    public InvertedIndexEntity getInvertedIndex(String id) {
        return (InvertedIndexEntity)this.executorSync().execute(this.getIndexRequest(id), (Type)((Object)InvertedIndexEntity.class));
    }

    @Override
    public String deleteIndex(String id) {
        return this.executorSync().execute(this.deleteIndexRequest(id), this.deleteIndexResponseDeserializer());
    }

    @Override
    public IndexEntity ensurePersistentIndex(Iterable<String> fields, PersistentIndexOptions options) {
        return (IndexEntity)this.executorSync().execute(this.createPersistentIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    public InvertedIndexEntity ensureInvertedIndex(InvertedIndexOptions options) {
        return (InvertedIndexEntity)this.executorSync().execute(this.createInvertedIndexRequest(options), (Type)((Object)InvertedIndexEntity.class));
    }

    @Override
    public IndexEntity ensureGeoIndex(Iterable<String> fields, GeoIndexOptions options) {
        return (IndexEntity)this.executorSync().execute(this.createGeoIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    @Deprecated
    public IndexEntity ensureFulltextIndex(Iterable<String> fields, FulltextIndexOptions options) {
        return (IndexEntity)this.executorSync().execute(this.createFulltextIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    public IndexEntity ensureTtlIndex(Iterable<String> fields, TtlIndexOptions options) {
        return (IndexEntity)this.executorSync().execute(this.createTtlIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    public IndexEntity ensureZKDIndex(Iterable<String> fields, ZKDIndexOptions options) {
        return (IndexEntity)this.executorSync().execute(this.createZKDIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    public IndexEntity ensureMDIndex(Iterable<String> fields, MDIndexOptions options) {
        return (IndexEntity)this.executorSync().execute(this.createMDIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    public IndexEntity ensureMDPrefixedIndex(Iterable<String> fields, MDPrefixedIndexOptions options) {
        return (IndexEntity)this.executorSync().execute(this.createMDIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    public Collection<IndexEntity> getIndexes() {
        return this.executorSync().execute(this.getIndexesRequest(), this.getIndexesResponseDeserializer());
    }

    @Override
    public Collection<InvertedIndexEntity> getInvertedIndexes() {
        return this.executorSync().execute(this.getIndexesRequest(), this.getInvertedIndexesResponseDeserializer());
    }

    @Override
    public boolean exists() {
        try {
            this.getInfo();
            return true;
        }
        catch (ArangoDBException e) {
            if (ArangoErrors.matches(e, 404, ArangoErrors.ERROR_ARANGO_DATA_SOURCE_NOT_FOUND)) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public CollectionEntity truncate() {
        return this.truncate(null);
    }

    @Override
    public CollectionEntity truncate(CollectionTruncateOptions options) {
        return (CollectionEntity)this.executorSync().execute(this.truncateRequest(options), (Type)((Object)CollectionEntity.class));
    }

    @Override
    public CollectionPropertiesEntity count() {
        return this.count(null);
    }

    @Override
    public CollectionPropertiesEntity count(CollectionCountOptions options) {
        return (CollectionPropertiesEntity)this.executorSync().execute(this.countRequest(options), (Type)((Object)CollectionPropertiesEntity.class));
    }

    @Override
    public CollectionEntity create() {
        return this.db().createCollection(this.name());
    }

    @Override
    public CollectionEntity create(CollectionCreateOptions options) {
        return this.db().createCollection(this.name(), options);
    }

    @Override
    public void drop() {
        this.executorSync().execute(this.dropRequest(null), (Type)((Object)Void.class));
    }

    @Override
    public void drop(boolean isSystem) {
        this.executorSync().execute(this.dropRequest(isSystem), (Type)((Object)Void.class));
    }

    @Override
    public CollectionEntity getInfo() {
        return (CollectionEntity)this.executorSync().execute(this.getInfoRequest(), (Type)((Object)CollectionEntity.class));
    }

    @Override
    public CollectionPropertiesEntity getProperties() {
        return (CollectionPropertiesEntity)this.executorSync().execute(this.getPropertiesRequest(), (Type)((Object)CollectionPropertiesEntity.class));
    }

    @Override
    public CollectionPropertiesEntity changeProperties(CollectionPropertiesOptions options) {
        return (CollectionPropertiesEntity)this.executorSync().execute(this.changePropertiesRequest(options), (Type)((Object)CollectionPropertiesEntity.class));
    }

    @Override
    public CollectionEntity rename(String newName) {
        return (CollectionEntity)this.executorSync().execute(this.renameRequest(newName), (Type)((Object)CollectionEntity.class));
    }

    @Override
    public ShardEntity getResponsibleShard(Object value) {
        return (ShardEntity)this.executorSync().execute(this.responsibleShardRequest(value), (Type)((Object)ShardEntity.class));
    }

    @Override
    public CollectionRevisionEntity getRevision() {
        return (CollectionRevisionEntity)this.executorSync().execute(this.getRevisionRequest(), (Type)((Object)CollectionRevisionEntity.class));
    }

    @Override
    public void grantAccess(String user, Permissions permissions) {
        this.executorSync().execute(this.grantAccessRequest(user, permissions), (Type)((Object)Void.class));
    }

    @Override
    public void revokeAccess(String user) {
        this.executorSync().execute(this.grantAccessRequest(user, Permissions.NONE), (Type)((Object)Void.class));
    }

    @Override
    public void resetAccess(String user) {
        this.executorSync().execute(this.resetAccessRequest(user), (Type)((Object)Void.class));
    }

    @Override
    public Permissions getPermissions(String user) {
        return this.executorSync().execute(this.getPermissionsRequest(user), this.getPermissionsResponseDeserialzer());
    }
}

