/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.model;

import com.arangodb.internal.serde.UserDataInside;
import java.util.Collection;
import java.util.Map;

public final class AqlQueryExplainOptions {
    private Map<String, Object> bindVars;
    private String query;
    private Options options;

    @UserDataInside
    public Map<String, Object> getBindVars() {
        return this.bindVars;
    }

    AqlQueryExplainOptions bindVars(Map<String, Object> bindVars) {
        this.bindVars = bindVars;
        return this;
    }

    public String getQuery() {
        return this.query;
    }

    AqlQueryExplainOptions query(String query) {
        this.query = query;
        return this;
    }

    public Integer getMaxNumberOfPlans() {
        return this.getOptions().maxNumberOfPlans;
    }

    public AqlQueryExplainOptions maxNumberOfPlans(Integer maxNumberOfPlans) {
        this.getOptions().maxNumberOfPlans = maxNumberOfPlans;
        return this;
    }

    public Boolean getAllPlans() {
        return this.getOptions().allPlans;
    }

    public AqlQueryExplainOptions allPlans(Boolean allPlans) {
        this.getOptions().allPlans = allPlans;
        return this;
    }

    public Collection<String> getRules() {
        return this.getOptions().getOptimizer().rules;
    }

    public AqlQueryExplainOptions rules(Collection<String> rules) {
        this.getOptions().getOptimizer().rules = rules;
        return this;
    }

    private Options getOptions() {
        if (this.options == null) {
            this.options = new Options();
        }
        return this.options;
    }

    public static final class Options {
        private Optimizer optimizer;
        private Integer maxNumberOfPlans;
        private Boolean allPlans;

        public Optimizer getOptimizer() {
            if (this.optimizer == null) {
                this.optimizer = new Optimizer();
            }
            return this.optimizer;
        }
    }

    public static final class Optimizer {
        private Collection<String> rules;
    }
}

