/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.model;

import com.arangodb.entity.CollectionType;
import com.arangodb.entity.KeyOptions;
import com.arangodb.entity.KeyType;
import com.arangodb.entity.ReplicationFactor;
import com.arangodb.model.CollectionSchema;
import com.arangodb.model.ComputedValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class CollectionCreateOptions {
    private String name;
    private ReplicationFactor replicationFactor;
    private Integer writeConcern;
    private KeyOptions keyOptions;
    private Boolean waitForSync;
    private final List<ComputedValue> computedValues = new ArrayList<ComputedValue>();
    private Collection<String> shardKeys;
    private Integer numberOfShards;
    private Boolean isSystem;
    private CollectionType type;
    private String distributeShardsLike;
    private String shardingStrategy;
    private String smartJoinAttribute;
    private CollectionSchema schema;

    public String getName() {
        return this.name;
    }

    CollectionCreateOptions name(String name) {
        this.name = name;
        return this;
    }

    public ReplicationFactor getReplicationFactor() {
        return this.replicationFactor;
    }

    public CollectionCreateOptions replicationFactor(ReplicationFactor replicationFactor) {
        this.replicationFactor = replicationFactor;
        return this;
    }

    public CollectionCreateOptions replicationFactor(int replicationFactor) {
        this.replicationFactor = ReplicationFactor.of(replicationFactor);
        return this;
    }

    public Integer getWriteConcern() {
        return this.writeConcern;
    }

    public CollectionCreateOptions writeConcern(Integer writeConcern) {
        this.writeConcern = writeConcern;
        return this;
    }

    public KeyOptions getKeyOptions() {
        return this.keyOptions;
    }

    public CollectionCreateOptions keyOptions(Boolean allowUserKeys, KeyType type, Integer increment, Integer offset) {
        this.keyOptions = new KeyOptions(allowUserKeys, type, increment, offset);
        return this;
    }

    public Boolean getWaitForSync() {
        return this.waitForSync;
    }

    public CollectionCreateOptions waitForSync(Boolean waitForSync) {
        this.waitForSync = waitForSync;
        return this;
    }

    public Collection<String> getShardKeys() {
        return this.shardKeys;
    }

    public CollectionCreateOptions shardKeys(String ... shardKeys) {
        this.shardKeys = Arrays.asList(shardKeys);
        return this;
    }

    public CollectionCreateOptions smartJoinAttribute(String smartJoinAttribute) {
        this.smartJoinAttribute = smartJoinAttribute;
        return this;
    }

    public String getSmartJoinAttribute() {
        return this.smartJoinAttribute;
    }

    public CollectionCreateOptions shardingStrategy(String shardingStrategy) {
        this.shardingStrategy = shardingStrategy;
        return this;
    }

    public String getShardingStrategy() {
        return this.shardingStrategy;
    }

    public CollectionCreateOptions numberOfShards(Integer numberOfShards) {
        this.numberOfShards = numberOfShards;
        return this;
    }

    public Integer getNumberOfShards() {
        return this.numberOfShards;
    }

    public Boolean getIsSystem() {
        return this.isSystem;
    }

    public CollectionCreateOptions isSystem(Boolean isSystem) {
        this.isSystem = isSystem;
        return this;
    }

    public CollectionType getType() {
        return this.type;
    }

    public CollectionCreateOptions type(CollectionType type) {
        this.type = type;
        return this;
    }

    public String getDistributeShardsLike() {
        return this.distributeShardsLike;
    }

    public CollectionCreateOptions distributeShardsLike(String distributeShardsLike) {
        this.distributeShardsLike = distributeShardsLike;
        return this;
    }

    public CollectionSchema getSchema() {
        return this.schema;
    }

    public CollectionCreateOptions schema(CollectionSchema schema) {
        this.schema = schema;
        return this;
    }

    public CollectionCreateOptions computedValues(ComputedValue ... computedValues) {
        Collections.addAll(this.computedValues, computedValues);
        return this;
    }

    public List<ComputedValue> getComputedValues() {
        return this.computedValues;
    }
}

