/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.util;

import com.arangodb.ArangoDBException;
import com.arangodb.entity.ErrorEntity;
import com.arangodb.internal.ArangoErrors;
import com.arangodb.internal.InternalResponse;
import com.arangodb.internal.net.ArangoDBRedirectException;
import com.arangodb.internal.net.ArangoDBUnavailableException;
import com.arangodb.internal.serde.InternalSerde;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeoutException;

public final class ResponseUtils {
    private static final int ERROR_STATUS = 300;
    private static final int ERROR_INTERNAL = 503;
    private static final String HEADER_ENDPOINT = "x-arango-endpoint";
    private static final String CONTENT_TYPE = "content-type";
    private static final String TEXT_PLAIN = "text/plain";

    private ResponseUtils() {
    }

    public static ArangoDBException translateError(InternalSerde serde, InternalResponse response) {
        ErrorEntity errorEntity;
        int responseCode = response.getResponseCode();
        if (responseCode < 300) {
            return null;
        }
        if (responseCode == 503 && response.containsMeta(HEADER_ENDPOINT)) {
            return new ArangoDBRedirectException(String.format("Response Code: %s", responseCode), response.getMeta(HEADER_ENDPOINT));
        }
        byte[] body = response.getBody();
        if (body == null) {
            return new ArangoDBException(String.format("Response Code: %s", responseCode), (Integer)responseCode);
        }
        if (ResponseUtils.isTextPlain(response)) {
            String payload = new String(body, ResponseUtils.getContentTypeCharset(response));
            return new ArangoDBException("Response Code: " + responseCode + "[" + payload + "]", (Integer)responseCode);
        }
        try {
            errorEntity = serde.deserialize(body, ErrorEntity.class);
        }
        catch (Exception e) {
            ArangoDBException adbEx = new ArangoDBException("Response Code: " + responseCode + " [Unparsable data] Response: " + response, (Integer)responseCode);
            adbEx.addSuppressed(e);
            return adbEx;
        }
        if (errorEntity.getCode() == 503 && errorEntity.getErrorNum() == 503) {
            return ArangoDBUnavailableException.from(errorEntity);
        }
        ArangoDBException e = new ArangoDBException(errorEntity);
        if (ArangoErrors.QUEUE_TIME_VIOLATED.equals(e.getErrorNum())) {
            return ArangoDBException.of(new TimeoutException().initCause(e));
        }
        return e;
    }

    private static boolean isTextPlain(InternalResponse response) {
        String contentType = response.getMeta(CONTENT_TYPE);
        return contentType != null && contentType.startsWith(TEXT_PLAIN);
    }

    private static Charset getContentTypeCharset(InternalResponse response) {
        String contentType = response.getMeta(CONTENT_TYPE);
        int paramIdx = contentType.indexOf("charset=");
        if (paramIdx == -1) {
            return StandardCharsets.UTF_8;
        }
        return Charset.forName(contentType.substring(paramIdx + 8));
    }
}

