/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.model;

import com.arangodb.internal.serde.UserDataInside;
import com.arangodb.model.TransactionalOptions;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class AqlQueryOptions
extends TransactionalOptions<AqlQueryOptions>
implements Cloneable {
    private Boolean allowDirtyRead;
    private Integer batchSize;
    private Map<String, Object> bindVars;
    private Boolean cache;
    private Boolean count;
    private Long memoryLimit;
    private Options options;
    private String query;
    private Integer ttl;

    @Override
    AqlQueryOptions getThis() {
        return this;
    }

    public Boolean getAllowDirtyRead() {
        return this.allowDirtyRead;
    }

    public AqlQueryOptions allowDirtyRead(Boolean allowDirtyRead) {
        this.allowDirtyRead = allowDirtyRead;
        return this;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public AqlQueryOptions batchSize(Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @UserDataInside
    public Map<String, Object> getBindVars() {
        return this.bindVars;
    }

    AqlQueryOptions bindVars(Map<String, Object> bindVars) {
        this.bindVars = bindVars;
        return this;
    }

    public Boolean getCache() {
        return this.cache;
    }

    public AqlQueryOptions cache(Boolean cache) {
        this.cache = cache;
        return this;
    }

    public Boolean getCount() {
        return this.count;
    }

    public AqlQueryOptions count(Boolean count) {
        this.count = count;
        return this;
    }

    public Long getMemoryLimit() {
        return this.memoryLimit;
    }

    public AqlQueryOptions memoryLimit(Long memoryLimit) {
        this.memoryLimit = memoryLimit;
        return this;
    }

    public Options getOptions() {
        if (this.options == null) {
            this.options = new Options();
        }
        return this.options;
    }

    public AqlQueryOptions options(Options options) {
        this.options = options;
        return this;
    }

    public String getQuery() {
        return this.query;
    }

    public AqlQueryOptions query(String query) {
        this.query = query;
        return this;
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public AqlQueryOptions ttl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    public AqlQueryOptions clone() {
        try {
            AqlQueryOptions clone = (AqlQueryOptions)super.clone();
            clone.bindVars = this.bindVars != null ? new HashMap<String, Object>(this.bindVars) : null;
            clone.options = this.options != null ? this.options.clone() : null;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    @JsonIgnore
    public Map<String, Object> getCustomOptions() {
        return this.getOptions().getCustomOptions();
    }

    public AqlQueryOptions customOption(String key, Object value) {
        this.getOptions().setCustomOption(key, value);
        return this;
    }

    @JsonIgnore
    public Boolean getAllowDirtyReads() {
        return this.getOptions().getAllowDirtyReads();
    }

    public AqlQueryOptions allowDirtyReads(Boolean allowDirtyReads) {
        this.getOptions().setAllowDirtyReads(allowDirtyReads);
        return this;
    }

    @JsonIgnore
    public Boolean getAllowRetry() {
        return this.getOptions().getAllowRetry();
    }

    public AqlQueryOptions allowRetry(Boolean allowRetry) {
        this.getOptions().setAllowRetry(allowRetry);
        return this;
    }

    @JsonIgnore
    public Boolean getFailOnWarning() {
        return this.getOptions().getFailOnWarning();
    }

    public AqlQueryOptions failOnWarning(Boolean failOnWarning) {
        this.getOptions().setFailOnWarning(failOnWarning);
        return this;
    }

    @JsonIgnore
    public Boolean getFillBlockCache() {
        return this.getOptions().getFillBlockCache();
    }

    public AqlQueryOptions fillBlockCache(Boolean fillBlockCache) {
        this.getOptions().setFillBlockCache(fillBlockCache);
        return this;
    }

    @JsonIgnore
    public String getForceOneShardAttributeValue() {
        return this.getOptions().getForceOneShardAttributeValue();
    }

    public AqlQueryOptions forceOneShardAttributeValue(String forceOneShardAttributeValue) {
        this.getOptions().setForceOneShardAttributeValue(forceOneShardAttributeValue);
        return this;
    }

    @JsonIgnore
    public Boolean getFullCount() {
        return this.getOptions().getFullCount();
    }

    public AqlQueryOptions fullCount(Boolean fullCount) {
        this.getOptions().setFullCount(fullCount);
        return this;
    }

    @JsonIgnore
    public Long getIntermediateCommitCount() {
        return this.getOptions().getIntermediateCommitCount();
    }

    public AqlQueryOptions intermediateCommitCount(Long intermediateCommitCount) {
        this.getOptions().setIntermediateCommitCount(intermediateCommitCount);
        return this;
    }

    @JsonIgnore
    public Long getIntermediateCommitSize() {
        return this.getOptions().getIntermediateCommitSize();
    }

    public AqlQueryOptions intermediateCommitSize(Long intermediateCommitSize) {
        this.getOptions().setIntermediateCommitSize(intermediateCommitSize);
        return this;
    }

    @JsonIgnore
    public Integer getMaxDNFConditionMembers() {
        return this.getOptions().getMaxDNFConditionMembers();
    }

    public AqlQueryOptions maxDNFConditionMembers(Integer maxDNFConditionMembers) {
        this.getOptions().setMaxDNFConditionMembers(maxDNFConditionMembers);
        return this;
    }

    @JsonIgnore
    public Integer getMaxNodesPerCallstack() {
        return this.getOptions().getMaxNodesPerCallstack();
    }

    public AqlQueryOptions maxNodesPerCallstack(Integer maxNodesPerCallstack) {
        this.getOptions().setMaxNodesPerCallstack(maxNodesPerCallstack);
        return this;
    }

    @JsonIgnore
    public Integer getMaxNumberOfPlans() {
        return this.getOptions().getMaxNumberOfPlans();
    }

    public AqlQueryOptions maxNumberOfPlans(Integer maxNumberOfPlans) {
        this.getOptions().setMaxNumberOfPlans(maxNumberOfPlans);
        return this;
    }

    @Deprecated
    @JsonIgnore
    public Integer getMaxPlans() {
        return this.getMaxNumberOfPlans();
    }

    @Deprecated
    public AqlQueryOptions maxPlans(Integer maxPlans) {
        return this.maxNumberOfPlans(maxPlans);
    }

    @JsonIgnore
    public Double getMaxRuntime() {
        return this.getOptions().getMaxRuntime();
    }

    public AqlQueryOptions maxRuntime(Double maxRuntime) {
        this.getOptions().setMaxRuntime(maxRuntime);
        return this;
    }

    @JsonIgnore
    public Long getMaxTransactionSize() {
        return this.getOptions().getMaxTransactionSize();
    }

    public AqlQueryOptions maxTransactionSize(Long maxTransactionSize) {
        this.getOptions().setMaxTransactionSize(maxTransactionSize);
        return this;
    }

    @JsonIgnore
    public Long getMaxWarningCount() {
        return this.getOptions().getMaxWarningCount();
    }

    public AqlQueryOptions maxWarningCount(Long maxWarningCount) {
        this.getOptions().setMaxWarningCount(maxWarningCount);
        return this;
    }

    @JsonIgnore
    public Optimizer getOptimizer() {
        return this.getOptions().getOptimizer();
    }

    public AqlQueryOptions optimizer(Optimizer optimizer) {
        this.getOptions().setOptimizer(optimizer);
        return this;
    }

    @JsonIgnore
    public Boolean getProfile() {
        return this.getOptions().getProfile();
    }

    public AqlQueryOptions profile(Boolean profile) {
        this.getOptions().setProfile(profile);
        return this;
    }

    @JsonIgnore
    public Double getSatelliteSyncWait() {
        return this.getOptions().getSatelliteSyncWait();
    }

    public AqlQueryOptions satelliteSyncWait(Double satelliteSyncWait) {
        this.getOptions().setSatelliteSyncWait(satelliteSyncWait);
        return this;
    }

    @JsonIgnore
    public Collection<String> getShardIds() {
        return this.getOptions().getShardIds();
    }

    public AqlQueryOptions shardIds(String ... shardIds) {
        this.getOptions().setShardIds(Arrays.asList(shardIds));
        return this;
    }

    @JsonIgnore
    public Boolean getSkipInaccessibleCollections() {
        return this.getOptions().getSkipInaccessibleCollections();
    }

    public AqlQueryOptions skipInaccessibleCollections(Boolean skipInaccessibleCollections) {
        this.getOptions().setSkipInaccessibleCollections(skipInaccessibleCollections);
        return this;
    }

    @JsonIgnore
    public Long getSpillOverThresholdMemoryUsage() {
        return this.getOptions().getSpillOverThresholdMemoryUsage();
    }

    public AqlQueryOptions spillOverThresholdMemoryUsage(Long spillOverThresholdMemoryUsage) {
        this.getOptions().setSpillOverThresholdMemoryUsage(spillOverThresholdMemoryUsage);
        return this;
    }

    @JsonIgnore
    public Long getSpillOverThresholdNumRows() {
        return this.getOptions().getSpillOverThresholdNumRows();
    }

    public AqlQueryOptions spillOverThresholdNumRows(Long spillOverThresholdNumRows) {
        this.getOptions().setSpillOverThresholdNumRows(spillOverThresholdNumRows);
        return this;
    }

    @JsonIgnore
    public Boolean getStream() {
        return this.getOptions().getStream();
    }

    public AqlQueryOptions stream(Boolean stream) {
        this.getOptions().setStream(stream);
        return this;
    }

    @JsonIgnore
    public Collection<String> getRules() {
        return this.getOptions().getOptimizer().getRules();
    }

    public AqlQueryOptions rules(Collection<String> rules) {
        this.getOptions().getOptimizer().setRules(rules);
        return this;
    }

    public static final class Options
    implements Cloneable {
        private Map<String, Object> customOptions;
        private Boolean allPlans;
        private Boolean allowDirtyReads;
        private Boolean allowRetry;
        private Boolean failOnWarning;
        private Boolean fillBlockCache;
        private String forceOneShardAttributeValue;
        private Boolean fullCount;
        private Long intermediateCommitCount;
        private Long intermediateCommitSize;
        private Integer maxDNFConditionMembers;
        private Integer maxNodesPerCallstack;
        private Integer maxNumberOfPlans;
        private Double maxRuntime;
        private Long maxTransactionSize;
        private Long maxWarningCount;
        private Optimizer optimizer;
        private Boolean profile;
        private Double satelliteSyncWait;
        private Collection<String> shardIds;
        private Boolean skipInaccessibleCollections;
        private Long spillOverThresholdMemoryUsage;
        private Long spillOverThresholdNumRows;
        private Boolean stream;

        @JsonInclude
        @JsonAnyGetter
        public Map<String, Object> getCustomOptions() {
            if (this.customOptions == null) {
                this.customOptions = new HashMap<String, Object>();
            }
            return this.customOptions;
        }

        public void setCustomOption(String key, Object value) {
            this.getCustomOptions().put(key, value);
        }

        public Boolean getAllPlans() {
            return this.allPlans;
        }

        public Boolean getAllowDirtyReads() {
            return this.allowDirtyReads;
        }

        public Boolean getAllowRetry() {
            return this.allowRetry;
        }

        public Boolean getFailOnWarning() {
            return this.failOnWarning;
        }

        public Boolean getFillBlockCache() {
            return this.fillBlockCache;
        }

        public String getForceOneShardAttributeValue() {
            return this.forceOneShardAttributeValue;
        }

        public Boolean getFullCount() {
            return this.fullCount;
        }

        public Long getIntermediateCommitCount() {
            return this.intermediateCommitCount;
        }

        public Long getIntermediateCommitSize() {
            return this.intermediateCommitSize;
        }

        public Integer getMaxDNFConditionMembers() {
            return this.maxDNFConditionMembers;
        }

        public Integer getMaxNodesPerCallstack() {
            return this.maxNodesPerCallstack;
        }

        public Integer getMaxNumberOfPlans() {
            return this.maxNumberOfPlans;
        }

        @Deprecated
        @JsonIgnore
        public Integer getMaxPlans() {
            return this.getMaxNumberOfPlans();
        }

        public Double getMaxRuntime() {
            return this.maxRuntime;
        }

        public Long getMaxTransactionSize() {
            return this.maxTransactionSize;
        }

        public Long getMaxWarningCount() {
            return this.maxWarningCount;
        }

        public Optimizer getOptimizer() {
            if (this.optimizer == null) {
                this.optimizer = new Optimizer();
            }
            return this.optimizer;
        }

        public Boolean getProfile() {
            return this.profile;
        }

        public Double getSatelliteSyncWait() {
            return this.satelliteSyncWait;
        }

        public Collection<String> getShardIds() {
            return this.shardIds;
        }

        public Boolean getSkipInaccessibleCollections() {
            return this.skipInaccessibleCollections;
        }

        public Long getSpillOverThresholdMemoryUsage() {
            return this.spillOverThresholdMemoryUsage;
        }

        public Long getSpillOverThresholdNumRows() {
            return this.spillOverThresholdNumRows;
        }

        public Boolean getStream() {
            return this.stream;
        }

        public void setAllPlans(Boolean allPlans) {
            this.allPlans = allPlans;
        }

        public void setAllowDirtyReads(Boolean allowDirtyReads) {
            this.allowDirtyReads = allowDirtyReads;
        }

        public void setAllowRetry(Boolean allowRetry) {
            this.allowRetry = allowRetry;
        }

        public void setFailOnWarning(Boolean failOnWarning) {
            this.failOnWarning = failOnWarning;
        }

        public void setFillBlockCache(Boolean fillBlockCache) {
            this.fillBlockCache = fillBlockCache;
        }

        public void setForceOneShardAttributeValue(String forceOneShardAttributeValue) {
            this.forceOneShardAttributeValue = forceOneShardAttributeValue;
        }

        public void setFullCount(Boolean fullCount) {
            this.fullCount = fullCount;
        }

        public void setIntermediateCommitCount(Long intermediateCommitCount) {
            this.intermediateCommitCount = intermediateCommitCount;
        }

        public void setIntermediateCommitSize(Long intermediateCommitSize) {
            this.intermediateCommitSize = intermediateCommitSize;
        }

        public void setMaxDNFConditionMembers(Integer maxDNFConditionMembers) {
            this.maxDNFConditionMembers = maxDNFConditionMembers;
        }

        public void setMaxNodesPerCallstack(Integer maxNodesPerCallstack) {
            this.maxNodesPerCallstack = maxNodesPerCallstack;
        }

        public void setMaxNumberOfPlans(Integer maxNumberOfPlans) {
            this.maxNumberOfPlans = maxNumberOfPlans;
        }

        public void setMaxRuntime(Double maxRuntime) {
            this.maxRuntime = maxRuntime;
        }

        public void setMaxTransactionSize(Long maxTransactionSize) {
            this.maxTransactionSize = maxTransactionSize;
        }

        public void setMaxWarningCount(Long maxWarningCount) {
            this.maxWarningCount = maxWarningCount;
        }

        public void setOptimizer(Optimizer optimizer) {
            this.optimizer = optimizer;
        }

        public void setProfile(Boolean profile) {
            this.profile = profile;
        }

        public void setSatelliteSyncWait(Double satelliteSyncWait) {
            this.satelliteSyncWait = satelliteSyncWait;
        }

        public void setShardIds(Collection<String> shardIds) {
            this.shardIds = shardIds;
        }

        public void setSkipInaccessibleCollections(Boolean skipInaccessibleCollections) {
            this.skipInaccessibleCollections = skipInaccessibleCollections;
        }

        public void setSpillOverThresholdMemoryUsage(Long spillOverThresholdMemoryUsage) {
            this.spillOverThresholdMemoryUsage = spillOverThresholdMemoryUsage;
        }

        public void setSpillOverThresholdNumRows(Long spillOverThresholdNumRows) {
            this.spillOverThresholdNumRows = spillOverThresholdNumRows;
        }

        public void setStream(Boolean stream) {
            this.stream = stream;
        }

        public Options clone() {
            try {
                Options clone = (Options)super.clone();
                clone.customOptions = this.customOptions != null ? new HashMap<String, Object>(this.customOptions) : null;
                clone.optimizer = this.optimizer != null ? this.optimizer.clone() : null;
                clone.shardIds = this.shardIds != null ? new ArrayList<String>(this.shardIds) : null;
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }
    }

    public static final class Optimizer
    implements Cloneable {
        private Collection<String> rules;

        public Collection<String> getRules() {
            return this.rules;
        }

        public void setRules(Collection<String> rules) {
            this.rules = rules;
        }

        public Optimizer clone() {
            try {
                Optimizer clone = (Optimizer)super.clone();
                clone.rules = this.rules != null ? new ArrayList<String>(this.rules) : null;
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }
    }
}

