/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoCollectionAsync;
import com.arangodb.ArangoCursorAsync;
import com.arangodb.ArangoDBAsync;
import com.arangodb.ArangoDBException;
import com.arangodb.ArangoDatabaseAsync;
import com.arangodb.ArangoGraphAsync;
import com.arangodb.ArangoSearchAsync;
import com.arangodb.ArangoViewAsync;
import com.arangodb.SearchAliasAsync;
import com.arangodb.entity.AqlExecutionExplainEntity;
import com.arangodb.entity.AqlFunctionEntity;
import com.arangodb.entity.AqlParseEntity;
import com.arangodb.entity.AqlQueryExplainEntity;
import com.arangodb.entity.ArangoDBEngine;
import com.arangodb.entity.ArangoDBVersion;
import com.arangodb.entity.CollectionEntity;
import com.arangodb.entity.DatabaseEntity;
import com.arangodb.entity.EdgeDefinition;
import com.arangodb.entity.GraphEntity;
import com.arangodb.entity.IndexEntity;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.QueryCachePropertiesEntity;
import com.arangodb.entity.QueryEntity;
import com.arangodb.entity.QueryTrackingPropertiesEntity;
import com.arangodb.entity.StreamTransactionEntity;
import com.arangodb.entity.TransactionEntity;
import com.arangodb.entity.ViewEntity;
import com.arangodb.entity.ViewType;
import com.arangodb.entity.arangosearch.analyzer.SearchAnalyzer;
import com.arangodb.internal.ArangoCollectionAsyncImpl;
import com.arangodb.internal.ArangoDBAsyncImpl;
import com.arangodb.internal.ArangoErrors;
import com.arangodb.internal.ArangoGraphAsyncImpl;
import com.arangodb.internal.ArangoSearchAsyncImpl;
import com.arangodb.internal.ArangoViewAsyncImpl;
import com.arangodb.internal.InternalArangoDatabase;
import com.arangodb.internal.InternalRequest;
import com.arangodb.internal.SearchAliasAsyncImpl;
import com.arangodb.internal.cursor.ArangoCursorAsyncImpl;
import com.arangodb.internal.net.HostHandle;
import com.arangodb.internal.serde.SerdeUtils;
import com.arangodb.model.AqlFunctionCreateOptions;
import com.arangodb.model.AqlFunctionDeleteOptions;
import com.arangodb.model.AqlFunctionGetOptions;
import com.arangodb.model.AqlQueryExplainOptions;
import com.arangodb.model.AqlQueryOptions;
import com.arangodb.model.CollectionCreateOptions;
import com.arangodb.model.CollectionsReadOptions;
import com.arangodb.model.ExplainAqlQueryOptions;
import com.arangodb.model.GraphCreateOptions;
import com.arangodb.model.StreamTransactionOptions;
import com.arangodb.model.TransactionOptions;
import com.arangodb.model.arangosearch.AnalyzerDeleteOptions;
import com.arangodb.model.arangosearch.ArangoSearchCreateOptions;
import com.arangodb.model.arangosearch.SearchAliasCreateOptions;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public class ArangoDatabaseAsyncImpl
extends InternalArangoDatabase
implements ArangoDatabaseAsync {
    private final ArangoDBAsync arangoDB;

    protected ArangoDatabaseAsyncImpl(ArangoDBAsyncImpl arangoDB, String name) {
        super(arangoDB, name);
        this.arangoDB = arangoDB;
    }

    @Override
    public ArangoDBAsync arango() {
        return this.arangoDB;
    }

    @Override
    public CompletableFuture<ArangoDBVersion> getVersion() {
        return this.executorAsync().execute(this::getVersionRequest, (Type)((Object)ArangoDBVersion.class));
    }

    @Override
    public CompletableFuture<ArangoDBEngine> getEngine() {
        return this.executorAsync().execute(this::getEngineRequest, (Type)((Object)ArangoDBEngine.class));
    }

    @Override
    public CompletableFuture<Boolean> exists() {
        return ((CompletableFuture)this.getInfo().thenApply(Objects::nonNull)).exceptionally(err -> {
            ArangoDBException aEx;
            Throwable e;
            Throwable throwable = e = err instanceof CompletionException ? err.getCause() : err;
            if (e instanceof ArangoDBException && ArangoErrors.matches(aEx = (ArangoDBException)e, 404, ArangoErrors.ERROR_ARANGO_DATABASE_NOT_FOUND)) {
                return false;
            }
            throw ArangoDBException.of(e);
        });
    }

    @Override
    public CompletableFuture<Collection<String>> getAccessibleDatabases() {
        return this.executorAsync().execute(this::getAccessibleDatabasesRequest, this.getDatabaseResponseDeserializer());
    }

    @Override
    public ArangoCollectionAsync collection(String name) {
        return new ArangoCollectionAsyncImpl(this, name);
    }

    @Override
    public CompletableFuture<CollectionEntity> createCollection(String name) {
        return this.executorAsync().execute(() -> this.createCollectionRequest(name, new CollectionCreateOptions()), (Type)((Object)CollectionEntity.class));
    }

    @Override
    public CompletableFuture<CollectionEntity> createCollection(String name, CollectionCreateOptions options) {
        return this.executorAsync().execute(() -> this.createCollectionRequest(name, options), (Type)((Object)CollectionEntity.class));
    }

    @Override
    public CompletableFuture<Collection<CollectionEntity>> getCollections() {
        return this.executorAsync().execute(() -> this.getCollectionsRequest(new CollectionsReadOptions()), this.getCollectionsResponseDeserializer());
    }

    @Override
    public CompletableFuture<Collection<CollectionEntity>> getCollections(CollectionsReadOptions options) {
        return this.executorAsync().execute(() -> this.getCollectionsRequest(options), this.getCollectionsResponseDeserializer());
    }

    @Override
    public CompletableFuture<IndexEntity> getIndex(String id) {
        String[] split = id.split("/");
        return this.collection(split[0]).getIndex(split[1]);
    }

    @Override
    public CompletableFuture<String> deleteIndex(String id) {
        String[] split = id.split("/");
        return this.collection(split[0]).deleteIndex(split[1]);
    }

    @Override
    public CompletableFuture<Boolean> create() {
        return this.arango().createDatabase(this.name());
    }

    @Override
    public CompletableFuture<Boolean> drop() {
        return this.executorAsync().execute(this::dropRequest, this.createDropResponseDeserializer());
    }

    @Override
    public CompletableFuture<Void> grantAccess(String user, Permissions permissions) {
        return this.executorAsync().execute(() -> this.grantAccessRequest(user, permissions), (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Void> grantAccess(String user) {
        return this.executorAsync().execute(() -> this.grantAccessRequest(user, Permissions.RW), (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Void> revokeAccess(String user) {
        return this.executorAsync().execute(() -> this.grantAccessRequest(user, Permissions.NONE), (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Void> resetAccess(String user) {
        return this.executorAsync().execute(() -> this.resetAccessRequest(user), (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Void> grantDefaultCollectionAccess(String user, Permissions permissions) {
        return this.executorAsync().execute(() -> this.updateUserDefaultCollectionAccessRequest(user, permissions), (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Permissions> getPermissions(String user) {
        return this.executorAsync().execute(() -> this.getPermissionsRequest(user), this.getPermissionsResponseDeserialzer());
    }

    @Override
    public <T> CompletableFuture<ArangoCursorAsync<T>> query(String query, Class<T> type, Map<String, ?> bindVars, AqlQueryOptions options) {
        InternalRequest request = this.queryRequest(query, bindVars, options);
        HostHandle hostHandle = new HostHandle();
        return this.executorAsync().execute(() -> request, this.cursorEntityDeserializer(type), hostHandle).thenApply(res -> new ArangoCursorAsyncImpl(this, res, type, hostHandle, options.getAllowRetry()));
    }

    @Override
    public <T> CompletableFuture<ArangoCursorAsync<T>> query(String query, Class<T> type, AqlQueryOptions options) {
        return this.query(query, type, null, options);
    }

    @Override
    public <T> CompletableFuture<ArangoCursorAsync<T>> query(String query, Class<T> type, Map<String, ?> bindVars) {
        return this.query(query, type, bindVars, new AqlQueryOptions());
    }

    @Override
    public <T> CompletableFuture<ArangoCursorAsync<T>> query(String query, Class<T> type) {
        return this.query(query, type, null, new AqlQueryOptions());
    }

    @Override
    public <T> CompletableFuture<ArangoCursorAsync<T>> cursor(String cursorId, Class<T> type) {
        return this.cursor(cursorId, type, null, new AqlQueryOptions());
    }

    @Override
    public <T> CompletableFuture<ArangoCursorAsync<T>> cursor(String cursorId, Class<T> type, AqlQueryOptions options) {
        return this.cursor(cursorId, type, null, options);
    }

    @Override
    public <T> CompletableFuture<ArangoCursorAsync<T>> cursor(String cursorId, Class<T> type, String nextBatchId) {
        return this.cursor(cursorId, type, nextBatchId, new AqlQueryOptions());
    }

    @Override
    public <T> CompletableFuture<ArangoCursorAsync<T>> cursor(String cursorId, Class<T> type, String nextBatchId, AqlQueryOptions options) {
        options.allowRetry(nextBatchId != null);
        HostHandle hostHandle = new HostHandle();
        return this.executorAsync().execute(() -> this.queryNextRequest(cursorId, options, nextBatchId), this.cursorEntityDeserializer(type), hostHandle).thenApply(res -> new ArangoCursorAsyncImpl(this, res, type, hostHandle, (Boolean)(nextBatchId != null ? 1 : 0)));
    }

    @Override
    public CompletableFuture<AqlExecutionExplainEntity> explainQuery(String query, Map<String, ?> bindVars, AqlQueryExplainOptions options) {
        return this.executorAsync().execute(() -> this.explainQueryRequest(query, bindVars, options), (Type)((Object)AqlExecutionExplainEntity.class));
    }

    @Override
    public CompletableFuture<AqlQueryExplainEntity> explainAqlQuery(String query, Map<String, ?> bindVars, AqlQueryExplainOptions options) {
        return this.executorAsync().execute(() -> this.explainQueryRequest(query, bindVars, options), (Type)((Object)AqlQueryExplainEntity.class));
    }

    @Override
    public CompletableFuture<AqlQueryExplainEntity> explainAqlQuery(String query, Map<String, ?> bindVars, ExplainAqlQueryOptions options) {
        return this.executorAsync().execute(() -> this.explainQueryRequest(query, bindVars, options), (Type)((Object)AqlQueryExplainEntity.class));
    }

    @Override
    public CompletableFuture<AqlParseEntity> parseQuery(String query) {
        return this.executorAsync().execute(() -> this.parseQueryRequest(query), (Type)((Object)AqlParseEntity.class));
    }

    @Override
    public CompletableFuture<Void> clearQueryCache() {
        return this.executorAsync().execute(this::clearQueryCacheRequest, (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<QueryCachePropertiesEntity> getQueryCacheProperties() {
        return this.executorAsync().execute(this::getQueryCachePropertiesRequest, (Type)((Object)QueryCachePropertiesEntity.class));
    }

    @Override
    public CompletableFuture<QueryCachePropertiesEntity> setQueryCacheProperties(QueryCachePropertiesEntity properties) {
        return this.executorAsync().execute(() -> this.setQueryCachePropertiesRequest(properties), (Type)((Object)QueryCachePropertiesEntity.class));
    }

    @Override
    public CompletableFuture<QueryTrackingPropertiesEntity> getQueryTrackingProperties() {
        return this.executorAsync().execute(this::getQueryTrackingPropertiesRequest, (Type)((Object)QueryTrackingPropertiesEntity.class));
    }

    @Override
    public CompletableFuture<QueryTrackingPropertiesEntity> setQueryTrackingProperties(QueryTrackingPropertiesEntity properties) {
        return this.executorAsync().execute(() -> this.setQueryTrackingPropertiesRequest(properties), (Type)((Object)QueryTrackingPropertiesEntity.class));
    }

    @Override
    public CompletableFuture<Collection<QueryEntity>> getCurrentlyRunningQueries() {
        return this.executorAsync().execute(this::getCurrentlyRunningQueriesRequest, SerdeUtils.constructListType(QueryEntity.class));
    }

    @Override
    public CompletableFuture<Collection<QueryEntity>> getSlowQueries() {
        return this.executorAsync().execute(this::getSlowQueriesRequest, SerdeUtils.constructListType(QueryEntity.class));
    }

    @Override
    public CompletableFuture<Void> clearSlowQueries() {
        return this.executorAsync().execute(this::clearSlowQueriesRequest, (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Void> killQuery(String id) {
        return this.executorAsync().execute(() -> this.killQueryRequest(id), (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Void> createAqlFunction(String name, String code, AqlFunctionCreateOptions options) {
        return this.executorAsync().execute(() -> this.createAqlFunctionRequest(name, code, options), (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Integer> deleteAqlFunction(String name, AqlFunctionDeleteOptions options) {
        return this.executorAsync().execute(() -> this.deleteAqlFunctionRequest(name, options), this.deleteAqlFunctionResponseDeserializer());
    }

    @Override
    public CompletableFuture<Collection<AqlFunctionEntity>> getAqlFunctions(AqlFunctionGetOptions options) {
        return this.executorAsync().execute(() -> this.getAqlFunctionsRequest(options), this.getAqlFunctionsResponseDeserializer());
    }

    @Override
    public ArangoGraphAsync graph(String name) {
        return new ArangoGraphAsyncImpl(this, name);
    }

    @Override
    public CompletableFuture<GraphEntity> createGraph(String name, Iterable<EdgeDefinition> edgeDefinitions) {
        return this.createGraph(name, edgeDefinitions, new GraphCreateOptions());
    }

    @Override
    public CompletableFuture<GraphEntity> createGraph(String name, Iterable<EdgeDefinition> edgeDefinitions, GraphCreateOptions options) {
        return this.executorAsync().execute(() -> this.createGraphRequest(name, edgeDefinitions, options), this.createGraphResponseDeserializer());
    }

    @Override
    public CompletableFuture<Collection<GraphEntity>> getGraphs() {
        return this.executorAsync().execute(this::getGraphsRequest, this.getGraphsResponseDeserializer());
    }

    @Override
    public <T> CompletableFuture<T> transaction(String action, Class<T> type, TransactionOptions options) {
        return this.executorAsync().execute(() -> this.transactionRequest(action, options), this.transactionResponseDeserializer(type));
    }

    @Override
    public CompletableFuture<StreamTransactionEntity> beginStreamTransaction(StreamTransactionOptions options) {
        return this.executorAsync().execute(() -> this.beginStreamTransactionRequest(options), this.streamTransactionResponseDeserializer());
    }

    @Override
    public CompletableFuture<StreamTransactionEntity> abortStreamTransaction(String id) {
        return this.executorAsync().execute(() -> this.abortStreamTransactionRequest(id), this.streamTransactionResponseDeserializer());
    }

    @Override
    public CompletableFuture<StreamTransactionEntity> getStreamTransaction(String id) {
        return this.executorAsync().execute(() -> this.getStreamTransactionRequest(id), this.streamTransactionResponseDeserializer());
    }

    @Override
    public CompletableFuture<Collection<TransactionEntity>> getStreamTransactions() {
        return this.executorAsync().execute(this::getStreamTransactionsRequest, this.transactionsResponseDeserializer());
    }

    @Override
    public CompletableFuture<StreamTransactionEntity> commitStreamTransaction(String id) {
        return this.executorAsync().execute(() -> this.commitStreamTransactionRequest(id), this.streamTransactionResponseDeserializer());
    }

    @Override
    public CompletableFuture<DatabaseEntity> getInfo() {
        return this.executorAsync().execute(this::getInfoRequest, this.getInfoResponseDeserializer());
    }

    @Override
    public CompletableFuture<Void> reloadRouting() {
        return this.executorAsync().execute(this::reloadRoutingRequest, (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Collection<ViewEntity>> getViews() {
        return this.executorAsync().execute(this::getViewsRequest, this.getViewsResponseDeserializer());
    }

    @Override
    public ArangoViewAsync view(String name) {
        return new ArangoViewAsyncImpl(this, name);
    }

    @Override
    public ArangoSearchAsync arangoSearch(String name) {
        return new ArangoSearchAsyncImpl(this, name);
    }

    @Override
    public SearchAliasAsync searchAlias(String name) {
        return new SearchAliasAsyncImpl(this, name);
    }

    @Override
    public CompletableFuture<ViewEntity> createView(String name, ViewType type) {
        return this.executorAsync().execute(() -> this.createViewRequest(name, type), (Type)((Object)ViewEntity.class));
    }

    @Override
    public CompletableFuture<ViewEntity> createArangoSearch(String name, ArangoSearchCreateOptions options) {
        return this.executorAsync().execute(() -> this.createArangoSearchRequest(name, options), (Type)((Object)ViewEntity.class));
    }

    @Override
    public CompletableFuture<ViewEntity> createSearchAlias(String name, SearchAliasCreateOptions options) {
        return this.executorAsync().execute(() -> this.createSearchAliasRequest(name, options), (Type)((Object)ViewEntity.class));
    }

    @Override
    public CompletableFuture<SearchAnalyzer> createSearchAnalyzer(SearchAnalyzer analyzer) {
        return this.executorAsync().execute(() -> this.createAnalyzerRequest(analyzer), (Type)((Object)SearchAnalyzer.class));
    }

    @Override
    public CompletableFuture<SearchAnalyzer> getSearchAnalyzer(String name) {
        return this.executorAsync().execute(() -> this.getAnalyzerRequest(name), (Type)((Object)SearchAnalyzer.class));
    }

    @Override
    public CompletableFuture<Collection<SearchAnalyzer>> getSearchAnalyzers() {
        return this.executorAsync().execute(this::getAnalyzersRequest, this.getSearchAnalyzersResponseDeserializer());
    }

    @Override
    public CompletableFuture<Void> deleteSearchAnalyzer(String name) {
        return this.deleteSearchAnalyzer(name, null);
    }

    @Override
    public CompletableFuture<Void> deleteSearchAnalyzer(String name, AnalyzerDeleteOptions options) {
        return this.executorAsync().execute(() -> this.deleteAnalyzerRequest(name, options), (Type)((Object)Void.class));
    }
}

