/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.ArangoGraph;
import com.arangodb.ArangoVertexCollection;
import com.arangodb.entity.VertexEntity;
import com.arangodb.entity.VertexUpdateEntity;
import com.arangodb.internal.ArangoErrors;
import com.arangodb.internal.ArangoGraphImpl;
import com.arangodb.internal.InternalArangoVertexCollection;
import com.arangodb.model.GraphDocumentReadOptions;
import com.arangodb.model.VertexCollectionDropOptions;
import com.arangodb.model.VertexCollectionRemoveOptions;
import com.arangodb.model.VertexCreateOptions;
import com.arangodb.model.VertexDeleteOptions;
import com.arangodb.model.VertexReplaceOptions;
import com.arangodb.model.VertexUpdateOptions;
import java.lang.reflect.Type;

public class ArangoVertexCollectionImpl
extends InternalArangoVertexCollection
implements ArangoVertexCollection {
    private final ArangoGraph graph;

    protected ArangoVertexCollectionImpl(ArangoGraphImpl graph, String name) {
        super(graph, graph.db().name(), graph.name(), name);
        this.graph = graph;
    }

    @Override
    public ArangoGraph graph() {
        return this.graph;
    }

    @Override
    @Deprecated
    public void drop() {
        this.drop(new VertexCollectionDropOptions());
    }

    @Override
    @Deprecated
    public void drop(VertexCollectionDropOptions options) {
        this.executorSync().execute(this.dropRequest(options), (Type)((Object)Void.class));
    }

    @Override
    public void remove() {
        this.remove(new VertexCollectionRemoveOptions());
    }

    @Override
    public void remove(VertexCollectionRemoveOptions options) {
        this.executorSync().execute(this.removeVertexCollectionRequest(options), (Type)((Object)Void.class));
    }

    @Override
    public VertexEntity insertVertex(Object value) {
        return this.executorSync().execute(this.insertVertexRequest(value, new VertexCreateOptions()), this.insertVertexResponseDeserializer());
    }

    @Override
    public VertexEntity insertVertex(Object value, VertexCreateOptions options) {
        return this.executorSync().execute(this.insertVertexRequest(value, options), this.insertVertexResponseDeserializer());
    }

    @Override
    public <T> T getVertex(String key, Class<T> type) {
        return this.getVertex(key, type, null);
    }

    @Override
    public <T> T getVertex(String key, Class<T> type, GraphDocumentReadOptions options) {
        try {
            return this.executorSync().execute(this.getVertexRequest(key, options), this.getVertexResponseDeserializer(type));
        }
        catch (ArangoDBException e) {
            if (ArangoErrors.matches(e, 304) || ArangoErrors.matches(e, 404, ArangoErrors.ERROR_ARANGO_DOCUMENT_NOT_FOUND) || ArangoErrors.matches(e, 412, ArangoErrors.ERROR_ARANGO_CONFLICT)) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public VertexUpdateEntity replaceVertex(String key, Object value) {
        return this.executorSync().execute(this.replaceVertexRequest(key, value, new VertexReplaceOptions()), this.replaceVertexResponseDeserializer());
    }

    @Override
    public VertexUpdateEntity replaceVertex(String key, Object value, VertexReplaceOptions options) {
        return this.executorSync().execute(this.replaceVertexRequest(key, value, options), this.replaceVertexResponseDeserializer());
    }

    @Override
    public VertexUpdateEntity updateVertex(String key, Object value) {
        return this.executorSync().execute(this.updateVertexRequest(key, value, new VertexUpdateOptions()), this.updateVertexResponseDeserializer());
    }

    @Override
    public VertexUpdateEntity updateVertex(String key, Object value, VertexUpdateOptions options) {
        return this.executorSync().execute(this.updateVertexRequest(key, value, options), this.updateVertexResponseDeserializer());
    }

    @Override
    public void deleteVertex(String key) {
        this.executorSync().execute(this.deleteVertexRequest(key, new VertexDeleteOptions()), (Type)((Object)Void.class));
    }

    @Override
    public void deleteVertex(String key, VertexDeleteOptions options) {
        this.executorSync().execute(this.deleteVertexRequest(key, options), (Type)((Object)Void.class));
    }
}

