/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.BaseArangoCursor;
import com.arangodb.entity.CursorEntity;
import com.arangodb.internal.ArangoExecuteable;
import com.arangodb.internal.InternalRequest;
import com.arangodb.internal.RequestType;
import java.util.List;

public abstract class InternalArangoCursor<T>
extends ArangoExecuteable
implements BaseArangoCursor<T> {
    private static final String PATH_API_CURSOR = "/_api/cursor";
    private final String dbName;
    private final CursorEntity<T> entity;
    private final Class<T> type;
    private final boolean allowRetry;

    protected InternalArangoCursor(ArangoExecuteable executeable, String dbName, CursorEntity<T> entity, Class<T> type, Boolean allowRetry) {
        super(executeable);
        this.dbName = dbName;
        this.entity = entity;
        this.type = type;
        this.allowRetry = Boolean.TRUE.equals(allowRetry);
    }

    @Override
    public String getId() {
        return this.entity.getId();
    }

    @Override
    public Integer getCount() {
        return this.entity.getCount();
    }

    @Override
    public Boolean isCached() {
        return this.entity.getCached();
    }

    @Override
    public Boolean hasMore() {
        return this.entity.getHasMore();
    }

    @Override
    public List<T> getResult() {
        return this.entity.getResult();
    }

    @Override
    public Boolean isPotentialDirtyRead() {
        return this.entity.isPotentialDirtyRead();
    }

    @Override
    public String getNextBatchId() {
        return this.entity.getNextBatchId();
    }

    @Override
    public CursorEntity.Extras getExtra() {
        return this.entity.getExtra();
    }

    protected boolean allowRetry() {
        return this.allowRetry;
    }

    protected Class<T> getType() {
        return this.type;
    }

    protected InternalRequest queryNextRequest() {
        return this.request(this.dbName, RequestType.POST, PATH_API_CURSOR, this.entity.getId(), this.entity.getNextBatchId());
    }

    protected InternalRequest queryCloseRequest() {
        return this.request(this.dbName, RequestType.DELETE, PATH_API_CURSOR, this.entity.getId());
    }
}

