/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.util;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncQueue<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncQueue.class);
    private final Queue<CompletableFuture<T>> requests = new ConcurrentLinkedQueue<CompletableFuture<T>>();
    private final Queue<T> offers = new ArrayDeque<T>();

    public synchronized CompletableFuture<T> poll() {
        LOGGER.trace("poll()");
        T o = this.offers.poll();
        if (o != null) {
            LOGGER.trace("poll(): short-circuit: {}", o);
            return CompletableFuture.completedFuture(o);
        }
        CompletableFuture r = new CompletableFuture();
        LOGGER.trace("poll(): enqueue request: {}", r);
        this.requests.add(r);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offer(T o) {
        LOGGER.trace("offer({})", o);
        CompletableFuture<T> r = this.requests.poll();
        if (r == null) {
            AsyncQueue asyncQueue = this;
            synchronized (asyncQueue) {
                r = this.requests.poll();
                if (r == null) {
                    LOGGER.trace("offer({}): enqueue", o);
                    this.offers.add(o);
                }
            }
        }
        if (r != null) {
            LOGGER.trace("offer({}): short-circuit: {}", o, r);
            r.complete(o);
        }
    }
}

