/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.entity.arangosearch;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public final class PrimarySort {
    private final String fieldName;
    private Boolean ascending;

    public PrimarySort(@JsonProperty(value="field") String field, @JsonProperty(value="asc") Boolean asc) {
        this.fieldName = field;
        this.ascending = asc;
    }

    private PrimarySort(String fieldName) {
        this.fieldName = fieldName;
    }

    public static PrimarySort on(String fieldName) {
        return new PrimarySort(fieldName);
    }

    public PrimarySort ascending(Boolean ascending) {
        this.ascending = ascending;
        return this;
    }

    @JsonIgnore
    public Boolean getAscending() {
        return this.ascending;
    }

    public Direction getDirection() {
        if (this.ascending == null) {
            return null;
        }
        return this.ascending != false ? Direction.asc : Direction.desc;
    }

    @Deprecated
    @JsonIgnore
    public String getFieldName() {
        return this.getField();
    }

    public String getField() {
        return this.fieldName;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PrimarySort)) {
            return false;
        }
        PrimarySort that = (PrimarySort)o;
        return Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.ascending, that.ascending);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.ascending);
    }

    public static enum Direction {
        asc,
        desc;

    }
}

