/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.cursor;

import com.arangodb.ArangoCursor;
import com.arangodb.ArangoIterator;
import com.arangodb.entity.CursorEntity;
import com.arangodb.entity.CursorStats;
import com.arangodb.entity.CursorWarning;
import com.arangodb.internal.ArangoCursorExecute;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArangoCursorImpl<T>
implements ArangoCursor<T> {
    protected final ArangoCursorIterator<T> iterator;
    private final Class<T> type;
    private final String id;
    private final ArangoCursorExecute<T> execute;
    private final boolean pontentialDirtyRead;
    private final boolean allowRetry;

    public ArangoCursorImpl(ArangoCursorExecute<T> execute, Class<T> type, CursorEntity<T> result, Boolean allowRetry) {
        this.execute = execute;
        this.type = type;
        this.id = result.getId();
        this.pontentialDirtyRead = result.isPotentialDirtyRead();
        this.iterator = new ArangoCursorIterator<T>(this.id, execute, result);
        this.allowRetry = Boolean.TRUE.equals(allowRetry);
    }

    @Override
    public void close() {
        if (this.getId() != null && (this.allowRetry || ((ArangoCursorIterator)this.iterator).result.getHasMore().booleanValue())) {
            this.getExecute().close(this.getId());
        }
    }

    @Override
    public T next() {
        return this.iterator.next();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public Integer getCount() {
        return ((ArangoCursorIterator)this.iterator).result.getCount();
    }

    @Override
    public CursorStats getStats() {
        CursorEntity.Extras extra = ((ArangoCursorIterator)this.iterator).result.getExtra();
        return extra != null ? extra.getStats() : null;
    }

    @Override
    public Collection<CursorWarning> getWarnings() {
        CursorEntity.Extras extra = ((ArangoCursorIterator)this.iterator).result.getExtra();
        return extra != null ? extra.getWarnings() : null;
    }

    @Override
    public boolean isCached() {
        Boolean cached = ((ArangoCursorIterator)this.iterator).result.getCached();
        return Boolean.TRUE.equals(cached);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public boolean isPotentialDirtyRead() {
        return this.pontentialDirtyRead;
    }

    @Override
    public ArangoIterator<T> iterator() {
        return this.iterator;
    }

    @Override
    public String getNextBatchId() {
        return ((ArangoCursorIterator)this.iterator).result.getNextBatchId();
    }

    protected ArangoCursorExecute<T> getExecute() {
        return this.execute;
    }

    protected static class ArangoCursorIterator<T>
    implements ArangoIterator<T> {
        private final String cursorId;
        private final ArangoCursorExecute<T> execute;
        private CursorEntity<T> result;
        private Iterator<T> arrayIterator;

        protected ArangoCursorIterator(String cursorId, ArangoCursorExecute<T> execute, CursorEntity<T> result) {
            this.cursorId = cursorId;
            this.execute = execute;
            this.result = result;
            this.arrayIterator = result.getResult().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.arrayIterator.hasNext() || this.result.getHasMore() != false;
        }

        @Override
        public T next() {
            if (!this.arrayIterator.hasNext() && Boolean.TRUE.equals(this.result.getHasMore())) {
                this.result = this.execute.next(this.cursorId, this.result.getNextBatchId());
                this.arrayIterator = this.result.getResult().iterator();
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.arrayIterator.next();
        }
    }
}

