/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb;

import com.arangodb.ArangoIterable;
import com.arangodb.ArangoIterator;
import com.arangodb.entity.CursorStats;
import com.arangodb.entity.CursorWarning;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.LoggerFactory;

public interface ArangoCursor<T>
extends ArangoIterable<T>,
ArangoIterator<T>,
Closeable {
    public String getId();

    public Class<T> getType();

    public Integer getCount();

    public CursorStats getStats();

    public Collection<CursorWarning> getWarnings();

    public boolean isCached();

    default public List<T> asListRemaining() {
        ArrayList<T> remaining = new ArrayList<T>();
        while (this.hasNext()) {
            remaining.add(this.next());
        }
        try {
            this.close();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(ArangoCursor.class).warn("Could not close cursor: ", (Throwable)e);
        }
        return remaining;
    }

    public boolean isPotentialDirtyRead();

    public String getNextBatchId();

    @Override
    public T next();
}

