/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.ArangoDatabase;
import com.arangodb.ArangoView;
import com.arangodb.entity.ViewEntity;
import com.arangodb.internal.ArangoDatabaseImpl;
import com.arangodb.internal.ArangoErrors;
import com.arangodb.internal.InternalArangoView;
import java.lang.reflect.Type;

public class ArangoViewImpl
extends InternalArangoView
implements ArangoView {
    private final ArangoDatabase db;

    protected ArangoViewImpl(ArangoDatabaseImpl db, String name) {
        super(db, db.name(), name);
        this.db = db;
    }

    @Override
    public ArangoDatabase db() {
        return this.db;
    }

    @Override
    public boolean exists() {
        try {
            this.getInfo();
            return true;
        }
        catch (ArangoDBException e) {
            if (ArangoErrors.matches(e, 404, ArangoErrors.ERROR_ARANGO_DATA_SOURCE_NOT_FOUND)) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public void drop() {
        this.executorSync().execute(this.dropRequest(), (Type)((Object)Void.class));
    }

    @Override
    public ViewEntity rename(String newName) {
        return (ViewEntity)this.executorSync().execute(this.renameRequest(newName), (Type)((Object)ViewEntity.class));
    }

    @Override
    public ViewEntity getInfo() {
        return (ViewEntity)this.executorSync().execute(this.getInfoRequest(), (Type)((Object)ViewEntity.class));
    }
}

