/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.ArangoDatabase;
import com.arangodb.SearchAlias;
import com.arangodb.entity.ViewEntity;
import com.arangodb.entity.arangosearch.SearchAliasPropertiesEntity;
import com.arangodb.internal.ArangoDatabaseImpl;
import com.arangodb.internal.ArangoErrors;
import com.arangodb.internal.InternalSearchAlias;
import com.arangodb.model.arangosearch.SearchAliasCreateOptions;
import com.arangodb.model.arangosearch.SearchAliasPropertiesOptions;
import java.lang.reflect.Type;

public class SearchAliasImpl
extends InternalSearchAlias
implements SearchAlias {
    private final ArangoDatabase db;

    protected SearchAliasImpl(ArangoDatabaseImpl db, String name) {
        super(db, db.name(), name);
        this.db = db;
    }

    @Override
    public ArangoDatabase db() {
        return this.db;
    }

    @Override
    public boolean exists() {
        try {
            this.getInfo();
            return true;
        }
        catch (ArangoDBException e) {
            if (ArangoErrors.matches(e, 404, ArangoErrors.ERROR_ARANGO_DATA_SOURCE_NOT_FOUND)) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public void drop() {
        this.executorSync().execute(this.dropRequest(), (Type)((Object)Void.class));
    }

    @Override
    public ViewEntity rename(String newName) {
        return (ViewEntity)this.executorSync().execute(this.renameRequest(newName), (Type)((Object)ViewEntity.class));
    }

    @Override
    public ViewEntity getInfo() {
        return (ViewEntity)this.executorSync().execute(this.getInfoRequest(), (Type)((Object)ViewEntity.class));
    }

    @Override
    public ViewEntity create() {
        return this.create(new SearchAliasCreateOptions());
    }

    @Override
    public ViewEntity create(SearchAliasCreateOptions options) {
        return this.db().createSearchAlias(this.name(), options);
    }

    @Override
    public SearchAliasPropertiesEntity getProperties() {
        return (SearchAliasPropertiesEntity)this.executorSync().execute(this.getPropertiesRequest(), (Type)((Object)SearchAliasPropertiesEntity.class));
    }

    @Override
    public SearchAliasPropertiesEntity updateProperties(SearchAliasPropertiesOptions options) {
        return (SearchAliasPropertiesEntity)this.executorSync().execute(this.updatePropertiesRequest(options), (Type)((Object)SearchAliasPropertiesEntity.class));
    }

    @Override
    public SearchAliasPropertiesEntity replaceProperties(SearchAliasPropertiesOptions options) {
        return (SearchAliasPropertiesEntity)this.executorSync().execute(this.replacePropertiesRequest(options), (Type)((Object)SearchAliasPropertiesEntity.class));
    }
}

