/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.net;

import com.arangodb.ArangoDBException;
import com.arangodb.ArangoDBMultipleException;
import com.arangodb.config.HostDescription;
import com.arangodb.internal.net.AccessType;
import com.arangodb.internal.net.Host;
import com.arangodb.internal.net.HostHandle;
import com.arangodb.internal.net.HostHandler;
import com.arangodb.internal.net.HostResolver;
import com.arangodb.internal.net.HostSet;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoundRobinHostHandler
implements HostHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoundRobinHostHandler.class);
    private final HostResolver resolver;
    private final List<Exception> lastFailExceptions;
    private long current;
    private int fails;
    private HostSet hosts;

    public RoundRobinHostHandler(HostResolver resolver) {
        this.resolver = resolver;
        this.lastFailExceptions = new ArrayList<Exception>();
        this.hosts = resolver.getHosts();
        this.current = 0L;
        this.reset();
    }

    @Override
    public Host get(HostHandle hostHandle, AccessType accessType) {
        this.checkNext(hostHandle, accessType);
        int size = this.hosts.getHostsList().size();
        int index = (int)(this.current++ % (long)size);
        Host host = this.hosts.getHostsList().get(index);
        if (hostHandle != null) {
            HostDescription hostDescription = hostHandle.getHost();
            if (hostDescription != null) {
                for (int i = index; i < index + size && !hostDescription.equals((host = this.hosts.getHostsList().get(i % size)).getDescription()); ++i) {
                }
            } else {
                hostHandle.setHost(host.getDescription());
            }
        }
        LOGGER.debug("Returning host: {}", (Object)host);
        return host;
    }

    @Override
    public void checkNext(HostHandle hostHandle, AccessType accessType) {
        this.hosts = this.resolver.getHosts();
        int size = this.hosts.getHostsList().size();
        if (this.fails > size) {
            ArangoDBException e = ArangoDBException.of("Cannot contact any host!", new ArangoDBMultipleException(new ArrayList<Throwable>(this.lastFailExceptions)));
            this.reset();
            throw e;
        }
    }

    @Override
    public void success() {
        this.reset();
    }

    @Override
    public void fail(Exception exception) {
        ++this.fails;
        this.lastFailExceptions.add(exception);
    }

    @Override
    public void failIfNotMatch(HostDescription host, Exception exception) {
        this.fail(exception);
    }

    @Override
    public void reset() {
        this.fails = 0;
        this.lastFailExceptions.clear();
    }

    @Override
    public void close() {
        this.hosts.close();
        this.resolver.close();
    }

    @Override
    public void setJwt(String jwt) {
        this.hosts.setJwt(jwt);
    }
}

