/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.model.arangosearch;

import com.arangodb.entity.ViewType;
import com.arangodb.entity.arangosearch.ArangoSearchCompression;
import com.arangodb.entity.arangosearch.CollectionLink;
import com.arangodb.entity.arangosearch.ConsolidationPolicy;
import com.arangodb.entity.arangosearch.PrimarySort;
import com.arangodb.entity.arangosearch.StoredValue;
import com.arangodb.internal.serde.InternalSerializers;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Arrays;
import java.util.Collection;

public final class ArangoSearchCreateOptions {
    private final ViewType type = ViewType.ARANGO_SEARCH;
    private String name;
    private Long consolidationIntervalMsec;
    private Long commitIntervalMsec;
    private Long cleanupIntervalStep;
    private ConsolidationPolicy consolidationPolicy;
    private Collection<CollectionLink> links;
    private Collection<PrimarySort> primarySorts;
    private ArangoSearchCompression primarySortCompression;
    private Collection<StoredValue> storedValues;
    private Collection<String> optimizeTopK;
    private Boolean primarySortCache;
    private Boolean primaryKeyCache;

    ArangoSearchCreateOptions name(String name) {
        this.name = name;
        return this;
    }

    public ArangoSearchCreateOptions consolidationIntervalMsec(Long consolidationIntervalMsec) {
        this.consolidationIntervalMsec = consolidationIntervalMsec;
        return this;
    }

    public ArangoSearchCreateOptions commitIntervalMsec(Long commitIntervalMsec) {
        this.commitIntervalMsec = commitIntervalMsec;
        return this;
    }

    public ArangoSearchCreateOptions cleanupIntervalStep(Long cleanupIntervalStep) {
        this.cleanupIntervalStep = cleanupIntervalStep;
        return this;
    }

    public ArangoSearchCreateOptions consolidationPolicy(ConsolidationPolicy consolidationPolicy) {
        this.consolidationPolicy = consolidationPolicy;
        return this;
    }

    public ArangoSearchCreateOptions link(CollectionLink ... links) {
        this.links = Arrays.asList(links);
        return this;
    }

    public ArangoSearchCreateOptions primarySort(PrimarySort ... primarySorts) {
        this.primarySorts = Arrays.asList(primarySorts);
        return this;
    }

    public ArangoSearchCreateOptions primarySortCompression(ArangoSearchCompression primarySortCompression) {
        this.primarySortCompression = primarySortCompression;
        return this;
    }

    public ArangoSearchCreateOptions storedValues(StoredValue ... storedValues) {
        this.storedValues = Arrays.asList(storedValues);
        return this;
    }

    public ArangoSearchCreateOptions optimizeTopK(String ... optimizeTopK) {
        this.optimizeTopK = Arrays.asList(optimizeTopK);
        return this;
    }

    public ArangoSearchCreateOptions primarySortCache(Boolean primarySortCache) {
        this.primarySortCache = primarySortCache;
        return this;
    }

    public ArangoSearchCreateOptions primaryKeyCache(Boolean primaryKeyCache) {
        this.primaryKeyCache = primaryKeyCache;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ViewType getType() {
        return this.type;
    }

    public Long getConsolidationIntervalMsec() {
        return this.consolidationIntervalMsec;
    }

    public Long getCommitIntervalMsec() {
        return this.commitIntervalMsec;
    }

    public Long getCleanupIntervalStep() {
        return this.cleanupIntervalStep;
    }

    public ConsolidationPolicy getConsolidationPolicy() {
        return this.consolidationPolicy;
    }

    @JsonSerialize(using=InternalSerializers.CollectionLinksSerializer.class)
    public Collection<CollectionLink> getLinks() {
        return this.links;
    }

    public Collection<PrimarySort> getPrimarySorts() {
        return this.primarySorts;
    }

    public ArangoSearchCompression getPrimarySortCompression() {
        return this.primarySortCompression;
    }

    public Collection<StoredValue> getStoredValues() {
        return this.storedValues;
    }

    public Collection<String> getOptimizeTopK() {
        return this.optimizeTopK;
    }

    public Boolean getPrimarySortCache() {
        return this.primarySortCache;
    }

    public Boolean getPrimaryKeyCache() {
        return this.primaryKeyCache;
    }
}

