/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.ArangoDatabase;
import com.arangodb.ArangoEdgeCollection;
import com.arangodb.ArangoGraph;
import com.arangodb.ArangoVertexCollection;
import com.arangodb.entity.EdgeDefinition;
import com.arangodb.entity.GraphEntity;
import com.arangodb.internal.ArangoDatabaseImpl;
import com.arangodb.internal.ArangoEdgeCollectionImpl;
import com.arangodb.internal.ArangoErrors;
import com.arangodb.internal.ArangoVertexCollectionImpl;
import com.arangodb.internal.InternalArangoGraph;
import com.arangodb.model.GraphCreateOptions;
import com.arangodb.model.ReplaceEdgeDefinitionOptions;
import com.arangodb.model.VertexCollectionCreateOptions;
import java.lang.reflect.Type;
import java.util.Collection;

public class ArangoGraphImpl
extends InternalArangoGraph
implements ArangoGraph {
    private final ArangoDatabase db;

    protected ArangoGraphImpl(ArangoDatabaseImpl db, String name) {
        super(db, db.name(), name);
        this.db = db;
    }

    @Override
    public ArangoDatabase db() {
        return this.db;
    }

    @Override
    public boolean exists() {
        try {
            this.getInfo();
            return true;
        }
        catch (ArangoDBException e) {
            if (ArangoErrors.matches(e, 404, ArangoErrors.ERROR_GRAPH_NOT_FOUND)) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public GraphEntity create(Iterable<EdgeDefinition> edgeDefinitions) {
        return this.db().createGraph(this.name(), edgeDefinitions);
    }

    @Override
    public GraphEntity create(Iterable<EdgeDefinition> edgeDefinitions, GraphCreateOptions options) {
        return this.db().createGraph(this.name(), edgeDefinitions, options);
    }

    @Override
    public void drop() {
        this.executorSync().execute(this.dropRequest(), (Type)((Object)Void.class));
    }

    @Override
    public void drop(boolean dropCollections) {
        this.executorSync().execute(this.dropRequest(dropCollections), (Type)((Object)Void.class));
    }

    @Override
    public GraphEntity getInfo() {
        return this.executorSync().execute(this.getInfoRequest(), this.getInfoResponseDeserializer());
    }

    @Override
    public Collection<String> getVertexCollections() {
        return this.executorSync().execute(this.getVertexCollectionsRequest(), this.getVertexCollectionsResponseDeserializer());
    }

    @Override
    public GraphEntity addVertexCollection(String name) {
        return this.addVertexCollection(name, new VertexCollectionCreateOptions());
    }

    @Override
    public GraphEntity addVertexCollection(String name, VertexCollectionCreateOptions options) {
        return this.executorSync().execute(this.addVertexCollectionRequest(name, options), this.addVertexCollectionResponseDeserializer());
    }

    @Override
    public ArangoVertexCollection vertexCollection(String name) {
        return new ArangoVertexCollectionImpl(this, name);
    }

    @Override
    public ArangoEdgeCollection edgeCollection(String name) {
        return new ArangoEdgeCollectionImpl(this, name);
    }

    @Override
    public Collection<String> getEdgeDefinitions() {
        return this.executorSync().execute(this.getEdgeDefinitionsRequest(), this.getEdgeDefinitionsDeserializer());
    }

    @Override
    public GraphEntity addEdgeDefinition(EdgeDefinition definition) {
        return this.executorSync().execute(this.addEdgeDefinitionRequest(definition), this.addEdgeDefinitionResponseDeserializer());
    }

    @Override
    public GraphEntity replaceEdgeDefinition(EdgeDefinition definition) {
        return this.replaceEdgeDefinition(definition, new ReplaceEdgeDefinitionOptions());
    }

    @Override
    public GraphEntity replaceEdgeDefinition(EdgeDefinition definition, ReplaceEdgeDefinitionOptions options) {
        return this.executorSync().execute(this.replaceEdgeDefinitionRequest(definition, options), this.replaceEdgeDefinitionResponseDeserializer());
    }
}

