/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.http;

import com.arangodb.ArangoDBException;
import com.arangodb.ContentType;
import com.arangodb.Protocol;
import com.arangodb.config.HostDescription;
import com.arangodb.internal.InternalRequest;
import com.arangodb.internal.InternalResponse;
import com.arangodb.internal.RequestType;
import com.arangodb.internal.config.ArangoConfig;
import com.arangodb.internal.net.Connection;
import com.arangodb.internal.serde.ContentTypeFactory;
import com.arangodb.internal.util.EncodeUtils;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.spi.tls.SslContextFactory;
import io.vertx.ext.auth.authentication.TokenCredentials;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnection
implements Connection {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpConnection.class);
    private static final String CONTENT_TYPE_APPLICATION_JSON_UTF8 = "application/json; charset=utf-8";
    private static final String CONTENT_TYPE_VPACK = "application/x-velocypack";
    private static final String USER_AGENT = HttpConnection.getUserAgent();
    private static final AtomicInteger THREAD_COUNT = new AtomicInteger();
    private final ContentType contentType;
    private String auth;
    private final WebClient client;
    private final Integer timeout;
    private final Vertx vertx;

    private static String getUserAgent() {
        return "JavaDriver/7.1.0 (JVM/" + System.getProperty("java.specification.version") + ")";
    }

    HttpConnection(ArangoConfig config, HostDescription host) {
        Protocol protocol = config.getProtocol();
        this.contentType = ContentTypeFactory.of((Protocol)protocol);
        this.timeout = config.getTimeout();
        this.vertx = Vertx.vertx((VertxOptions)new VertxOptions().setPreferNativeTransport(true).setEventLoopPoolSize(1));
        this.vertx.runOnContext(e -> {
            Thread.currentThread().setName("adb-eventloop-" + THREAD_COUNT.getAndIncrement());
            this.auth = new UsernamePasswordCredentials(config.getUser(), Optional.ofNullable(config.getPassword()).orElse("")).toHttpAuthorization();
            LOGGER.debug("Created Vert.x context");
        });
        int intTtl = Optional.ofNullable(config.getConnectionTtl()).map(ttl -> Math.toIntExact(ttl / 1000L)).orElse(0);
        HttpVersion httpVersion = protocol == Protocol.HTTP_JSON || protocol == Protocol.HTTP_VPACK ? HttpVersion.HTTP_1_1 : HttpVersion.HTTP_2;
        WebClientOptions webClientOptions = new WebClientOptions().setMaxPoolSize(1).setHttp2MaxPoolSize(1).setConnectTimeout(this.timeout.intValue()).setIdleTimeoutUnit(TimeUnit.MILLISECONDS).setIdleTimeout(this.timeout.intValue()).setKeepAliveTimeout(intTtl).setHttp2KeepAliveTimeout(intTtl).setUserAgentEnabled(false).setFollowRedirects(false).setLogActivity(true).setKeepAlive(true).setTcpKeepAlive(true).setPipelining(true).setReuseAddress(true).setReusePort(true).setHttp2ClearTextUpgrade(false).setProtocolVersion(httpVersion).setDefaultHost(host.getHost()).setDefaultPort(host.getPort());
        if (Boolean.TRUE.equals(config.getUseSsl())) {
            SSLContext ctx;
            if (config.getSslContext() != null) {
                ctx = config.getSslContext();
            } else {
                try {
                    ctx = SSLContext.getDefault();
                }
                catch (NoSuchAlgorithmException e2) {
                    throw new ArangoDBException((Throwable)e2);
                }
            }
            webClientOptions.setSsl(true).setUseAlpn(true).setVerifyHost(config.getVerifyHost().booleanValue()).setJdkSslEngineOptions(new JdkSSLEngineOptions(){

                public JdkSSLEngineOptions copy() {
                    return this;
                }

                public SslContextFactory sslContextFactory() {
                    return () -> new JdkSslContext(ctx, true, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, ApplicationProtocolConfig.DISABLED, ClientAuth.NONE, null, false);
                }
            });
        }
        this.client = WebClient.create((Vertx)this.vertx, (WebClientOptions)webClientOptions);
    }

    private static String buildUrl(InternalRequest request) {
        StringBuilder sb = new StringBuilder();
        String dbName = request.getDbName();
        if (dbName != null && !dbName.isEmpty()) {
            sb.append("/_db/").append(EncodeUtils.encodeURIComponent((String)dbName));
        }
        sb.append(request.getPath());
        if (!request.getQueryParam().isEmpty()) {
            sb.append("?");
            Iterator iterator = request.getQueryParam().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry param = iterator.next();
                if (param.getValue() == null) continue;
                sb.append(EncodeUtils.encodeURIComponent((String)((String)param.getKey())));
                sb.append("=");
                sb.append(EncodeUtils.encodeURIComponent((String)((String)param.getValue())));
                if (!iterator.hasNext()) continue;
                sb.append("&");
            }
        }
        return sb.toString();
    }

    private static void addHeader(InternalRequest request, HttpRequest<?> httpRequest) {
        for (Map.Entry header : request.getHeaderParam().entrySet()) {
            httpRequest.putHeader((String)header.getKey(), (String)header.getValue());
        }
    }

    public void close() {
        this.client.close();
        this.vertx.close();
    }

    private HttpMethod requestTypeToHttpMethod(RequestType requestType) {
        switch (requestType) {
            case POST: {
                return HttpMethod.POST;
            }
            case PUT: {
                return HttpMethod.PUT;
            }
            case PATCH: {
                return HttpMethod.PATCH;
            }
            case DELETE: {
                return HttpMethod.DELETE;
            }
            case HEAD: {
                return HttpMethod.HEAD;
            }
        }
        return HttpMethod.GET;
    }

    public InternalResponse execute(InternalRequest request) throws IOException {
        InternalResponse resp;
        CompletableFuture rfuture = new CompletableFuture();
        this.vertx.runOnContext(e -> this.doExecute(request, rfuture));
        try {
            resp = (InternalResponse)rfuture.get();
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
            throw ArangoDBException.wrap((Throwable)e2);
        }
        catch (ExecutionException e3) {
            Throwable cause = e3.getCause();
            if (cause instanceof TimeoutException) {
                throw ArangoDBException.wrap((Throwable)cause);
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException(cause);
        }
        return resp;
    }

    public void doExecute(InternalRequest request, CompletableFuture<InternalResponse> rfuture) {
        Buffer buffer;
        String path = HttpConnection.buildUrl(request);
        HttpRequest httpRequest = this.client.request(this.requestTypeToHttpMethod(request.getRequestType()), path).timeout((long)this.timeout.intValue());
        if (this.contentType == ContentType.VPACK) {
            httpRequest.putHeader("Accept", CONTENT_TYPE_VPACK);
        }
        HttpConnection.addHeader(request, httpRequest);
        httpRequest.putHeader(HttpHeaders.AUTHORIZATION.toString(), this.auth);
        httpRequest.putHeader("x-arango-driver", USER_AGENT);
        byte[] reqBody = request.getBody();
        if (reqBody != null) {
            buffer = Buffer.buffer((byte[])reqBody);
            if (this.contentType == ContentType.VPACK) {
                httpRequest.putHeader(HttpHeaders.CONTENT_TYPE.toString(), CONTENT_TYPE_VPACK);
            } else {
                httpRequest.putHeader(HttpHeaders.CONTENT_TYPE.toString(), CONTENT_TYPE_APPLICATION_JSON_UTF8);
            }
        } else {
            buffer = Buffer.buffer();
        }
        httpRequest.sendBuffer(buffer).map(this::buildResponse).onSuccess(rfuture::complete).onFailure(rfuture::completeExceptionally);
    }

    private InternalResponse buildResponse(HttpResponse<Buffer> httpResponse) {
        byte[] bytes;
        InternalResponse response = new InternalResponse();
        response.setResponseCode(httpResponse.statusCode());
        Buffer body = (Buffer)httpResponse.body();
        if (body != null && (bytes = body.getBytes()).length > 0) {
            response.setBody(bytes);
        }
        for (Map.Entry header : httpResponse.headers()) {
            response.putMeta((String)header.getKey(), (String)header.getValue());
        }
        return response;
    }

    public void setJwt(String jwt) {
        if (jwt != null) {
            this.vertx.runOnContext(e -> {
                this.auth = new TokenCredentials(jwt).toHttpAuthorization();
            });
        }
    }
}

