/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.jackson.dataformat.velocypack;

import com.arangodb.jackson.dataformat.velocypack.VPackFactory;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.MapperBuilder;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VPackMapper
extends ObjectMapper {
    private static final long serialVersionUID = 1L;

    public static Builder builder() {
        return new Builder(new VPackMapper());
    }

    public static Builder builder(VPackFactory jf) {
        return new Builder(new VPackMapper(jf));
    }

    public VPackMapper() {
        this(new VPackFactory());
    }

    public VPackMapper(VPackFactory jf) {
        super((JsonFactory)jf);
        this.checkSupportedVersion();
    }

    protected VPackMapper(VPackMapper src) {
        super((ObjectMapper)src);
        this.checkSupportedVersion();
    }

    private void checkSupportedVersion() {
        Version version = this.version();
        int major = version.getMajorVersion();
        int minor = version.getMinorVersion();
        if (major != 2 || minor < 10 || minor > 13) {
            Logger.getLogger(VPackMapper.class.getName()).log(Level.WARNING, "Unsupported version of jackson-databind: {0}", version);
        }
    }

    public VPackMapper copy() {
        this._checkInvalidCopy(VPackMapper.class);
        return new VPackMapper(this);
    }

    public VPackFactory getFactory() {
        return (VPackFactory)this._jsonFactory;
    }

    public static class Builder
    extends MapperBuilder<VPackMapper, Builder> {
        public Builder(VPackMapper m) {
            super((ObjectMapper)m);
        }
    }
}

