/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.jackson.dataformat.velocypack.internal;

import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.ValueType;
import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserMinimalBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class VPackParser
extends ParserMinimalBase {
    protected ObjectCodec objectCodec;
    protected final IOContext ioContext;
    protected boolean closed;
    protected VPackSlice currentValue;
    protected boolean beforeFirstToken;
    protected String currentName;
    protected final LinkedList<Iterator<Map.Entry<String, VPackSlice>>> objectIterators;
    protected final LinkedList<Iterator<VPackSlice>> arrayIterators;
    protected final LinkedList<JsonToken> currentCompoundValue;
    protected byte[] inputBuffer;
    protected boolean bufferRecyclable;

    public VPackParser(IOContext ctxt, int parserFeatures, ObjectCodec codec, byte[] inputBuffer, int start, boolean bufferRecyclable) {
        super(parserFeatures);
        this.ioContext = ctxt;
        this.objectCodec = codec;
        this.inputBuffer = inputBuffer;
        this.bufferRecyclable = bufferRecyclable;
        this.currentValue = new VPackSlice(inputBuffer, start);
        this.beforeFirstToken = true;
        this._currToken = null;
        this.objectIterators = new LinkedList();
        this.arrayIterators = new LinkedList();
        this.currentCompoundValue = new LinkedList();
    }

    public ObjectCodec getCodec() {
        return this.objectCodec;
    }

    public void setCodec(ObjectCodec c) {
        this.objectCodec = c;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public int releaseBuffered(OutputStream out) {
        return 0;
    }

    public Object getInputSource() {
        return null;
    }

    public JsonLocation getTokenLocation() {
        return null;
    }

    public JsonLocation getCurrentLocation() {
        return null;
    }

    public String getCurrentName() {
        return this.currentName;
    }

    public void overrideCurrentName(String name) {
        this.currentName = name;
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.releaseBuffers();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public JsonStreamContext getParsingContext() {
        return null;
    }

    protected void releaseBuffers() {
        byte[] buf;
        if (this.bufferRecyclable && (buf = this.inputBuffer) != null) {
            this.inputBuffer = null;
            this.ioContext.releaseReadIOBuffer(buf);
        }
    }

    public JsonToken nextToken() {
        if (this._currToken == null && this._lastClearedToken != null && !this.currentCompoundValue.isEmpty()) {
            this._currToken = this._lastClearedToken;
        }
        if (this.beforeFirstToken && this._currToken == null) {
            this.beforeFirstToken = false;
            this._currToken = this.getToken(this.currentValue.getType(), this.currentValue);
            return this._currToken;
        }
        if (this._currToken == JsonToken.START_OBJECT) {
            this.objectIterators.add(this.currentValue.objectIterator());
            this.currentCompoundValue.add(JsonToken.START_OBJECT);
        } else if (this._currToken == JsonToken.START_ARRAY) {
            this.arrayIterators.add(this.currentValue.arrayIterator());
            this.currentCompoundValue.add(JsonToken.START_ARRAY);
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._currToken = this.getToken(this.currentValue.getType(), this.currentValue);
            return this._currToken;
        }
        if (this.currentCompoundValue.isEmpty()) {
            this.close();
            return null;
        }
        if (this.currentCompoundValue.getLast() == JsonToken.START_OBJECT && !this.objectIterators.isEmpty()) {
            Iterator<Map.Entry<String, VPackSlice>> lastObject = this.objectIterators.getLast();
            if (lastObject.hasNext()) {
                Map.Entry<String, VPackSlice> next = lastObject.next();
                this.currentName = next.getKey();
                this.currentValue = next.getValue();
                this._currToken = JsonToken.FIELD_NAME;
            } else {
                this._currToken = JsonToken.END_OBJECT;
                this.objectIterators.removeLast();
                this.currentCompoundValue.removeLast();
            }
        } else if (this.currentCompoundValue.getLast() == JsonToken.START_ARRAY && !this.arrayIterators.isEmpty()) {
            Iterator<VPackSlice> lastArray = this.arrayIterators.getLast();
            if (lastArray.hasNext()) {
                this.currentName = null;
                this.currentValue = lastArray.next();
                this._currToken = this.getToken(this.currentValue.getType(), this.currentValue);
            } else {
                this._currToken = JsonToken.END_ARRAY;
                this.arrayIterators.removeLast();
                this.currentCompoundValue.removeLast();
            }
        }
        return this._currToken;
    }

    private JsonToken getToken(ValueType type, VPackSlice value) {
        JsonToken token;
        switch (type) {
            case OBJECT: {
                token = JsonToken.START_OBJECT;
                break;
            }
            case ARRAY: {
                token = JsonToken.START_ARRAY;
                break;
            }
            case STRING: {
                token = JsonToken.VALUE_STRING;
                break;
            }
            case BOOL: {
                token = value.isTrue() ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
                break;
            }
            case DOUBLE: {
                token = JsonToken.VALUE_NUMBER_FLOAT;
                break;
            }
            case INT: 
            case SMALLINT: 
            case UINT: {
                token = JsonToken.VALUE_NUMBER_INT;
                break;
            }
            case NULL: {
                token = JsonToken.VALUE_NULL;
                break;
            }
            default: {
                token = null;
            }
        }
        return token;
    }

    public String getText() {
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this.currentName;
        }
        if (this.currentValue.isNumber()) {
            return String.valueOf(this.getNumberValue());
        }
        if (this.currentValue.isBoolean()) {
            return String.valueOf(this.currentValue.getAsBoolean());
        }
        if (this.currentValue.isNull()) {
            return "null";
        }
        if (this.currentValue.isString()) {
            return String.valueOf(this.currentValue.getAsString());
        }
        throw new UnsupportedOperationException("Calling getText() on " + this.currentValue.getType());
    }

    public char[] getTextCharacters() {
        return this.getText().toCharArray();
    }

    public boolean hasTextCharacters() {
        return false;
    }

    public int getTextLength() {
        return this.getTextCharacters().length;
    }

    public int getTextOffset() {
        return 0;
    }

    public byte[] getBinaryValue(Base64Variant b64variant) {
        if (this.currentValue.isBinary()) {
            return this.currentValue.getAsBinary();
        }
        if (this.currentValue.isString()) {
            return b64variant.decode(this.currentValue.getAsString());
        }
        return Arrays.copyOfRange(this.currentValue.getBuffer(), this.currentValue.getStart(), this.currentValue.getStart() + this.currentValue.getByteSize());
    }

    public VPackSlice getVPack() {
        return this.currentValue;
    }

    public int readBinaryValue(Base64Variant b64variant, OutputStream out) {
        return -1;
    }

    public Number getNumberValue() {
        switch (this.currentValue.getType()) {
            case SMALLINT: {
                return this.currentValue.getAsInt();
            }
            case INT: {
                long longValue = this.currentValue.getAsLong();
                if (longValue < Integer.MIN_VALUE || longValue > Integer.MAX_VALUE) {
                    return longValue;
                }
                return this.currentValue.getAsInt();
            }
            case UINT: {
                return this.currentValue.getAsBigInteger();
            }
            case DOUBLE: {
                return this.currentValue.getAsDouble();
            }
        }
        throw new UnsupportedOperationException("Cannot get number from " + this.currentValue.getType());
    }

    public JsonParser.NumberType getNumberType() {
        JsonParser.NumberType type;
        switch (this.currentValue.getType()) {
            case SMALLINT: {
                type = JsonParser.NumberType.INT;
                break;
            }
            case INT: {
                long longValue = this.currentValue.getAsLong();
                if (longValue < Integer.MIN_VALUE || longValue > Integer.MAX_VALUE) {
                    type = JsonParser.NumberType.LONG;
                    break;
                }
                type = JsonParser.NumberType.INT;
                break;
            }
            case UINT: {
                type = JsonParser.NumberType.BIG_INTEGER;
                break;
            }
            case DOUBLE: {
                type = JsonParser.NumberType.DOUBLE;
                break;
            }
            default: {
                type = null;
            }
        }
        return type;
    }

    public int getIntValue() {
        return this.currentValue.getAsInt();
    }

    public long getLongValue() {
        return this.currentValue.getAsLong();
    }

    public BigInteger getBigIntegerValue() {
        return this.currentValue.getAsBigInteger();
    }

    public float getFloatValue() {
        return this.currentValue.getAsFloat();
    }

    public double getDoubleValue() {
        return this.currentValue.getAsDouble();
    }

    public BigDecimal getDecimalValue() {
        return this.currentValue.getAsBigDecimal();
    }

    protected void _handleEOF() {
        throw new UnsupportedOperationException("Stream decoding is not supported!");
    }
}

