/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.jackson.dataformat.velocypack;

import com.arangodb.jackson.dataformat.velocypack.VPackFactoryBuilder;
import com.arangodb.jackson.dataformat.velocypack.internal.VPackGenerator;
import com.arangodb.jackson.dataformat.velocypack.internal.VPackParser;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TSFBuilder;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.format.InputAccessor;
import com.fasterxml.jackson.core.format.MatchStrength;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.PackageVersion;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import org.slf4j.LoggerFactory;

public class VPackFactory
extends JsonFactory {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT_NAME_VELOCYPACK = "Velocypack";

    public VPackFactory() {
    }

    public VPackFactory(ObjectCodec codec) {
        super(codec);
    }

    protected VPackFactory(VPackFactory src, ObjectCodec oc) {
        super((JsonFactory)src, oc);
    }

    protected VPackFactory(VPackFactoryBuilder b) {
        super((TSFBuilder)b, false);
    }

    public VPackFactoryBuilder rebuild() {
        return new VPackFactoryBuilder(this);
    }

    public static VPackFactoryBuilder builder() {
        return new VPackFactoryBuilder();
    }

    public VPackFactory copy() {
        this._checkInvalidCopy(VPackFactory.class);
        return new VPackFactory(this, null);
    }

    protected Object readResolve() {
        return new VPackFactory(this, this._objectCodec);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public String getFormatName() {
        return FORMAT_NAME_VELOCYPACK;
    }

    public MatchStrength hasFormat(InputAccessor acc) {
        return MatchStrength.INCONCLUSIVE;
    }

    public boolean requiresPropertyOrdering() {
        return false;
    }

    public boolean canHandleBinaryNatively() {
        return true;
    }

    public boolean canUseCharArrays() {
        return false;
    }

    public VPackParser createParser(File f) throws IOException {
        IOContext ctxt = this._createContext(f, true);
        return this._createParser(this._decorate(new FileInputStream(f), ctxt), ctxt);
    }

    public VPackParser createParser(URL url) throws IOException {
        IOContext ctxt = this._createContext(url, true);
        return this._createParser(this._decorate(this._optimizedStreamFromURL(url), ctxt), ctxt);
    }

    public VPackParser createParser(InputStream in) throws IOException {
        IOContext ctxt = this._createContext(in, false);
        return this._createParser(this._decorate(in, ctxt), ctxt);
    }

    public VPackParser createParser(byte[] data) {
        return this._createParser(data, 0, data.length, this._createContext(data, true));
    }

    public VPackParser createParser(byte[] data, int offset, int len) throws IOException {
        InputStream in;
        IOContext ctxt = this._createContext(data, true);
        if (this._inputDecorator != null && (in = this._inputDecorator.decorate(ctxt, data, 0, data.length)) != null) {
            return this._createParser(in, ctxt);
        }
        return this._createParser(data, offset, len, ctxt);
    }

    public VPackGenerator createGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        IOContext ctxt = this._createContext(out, false);
        ctxt.setEncoding(enc);
        return this.createVelocypackGenerator(ctxt, this._generatorFeatures, this._objectCodec, this._decorate(out, ctxt));
    }

    public VPackGenerator createGenerator(OutputStream out) throws IOException {
        IOContext ctxt = this._createContext(out, false);
        return this.createVelocypackGenerator(ctxt, this._generatorFeatures, this._objectCodec, this._decorate(out, ctxt));
    }

    protected VPackParser _createParser(InputStream in, IOContext ctxt) {
        throw new UnsupportedOperationException("Stream decoding is not supported!");
    }

    protected JsonParser _createParser(Reader r, IOContext ctxt) {
        return (JsonParser)this.nonByteSource();
    }

    protected JsonParser _createParser(char[] data, int offset, int len, IOContext ctxt, boolean recyclable) {
        return (JsonParser)this.nonByteSource();
    }

    protected VPackParser _createParser(byte[] data, int offset, int len, IOContext ctxt) {
        return new VPackParser(ctxt, this._parserFeatures, this._objectCodec, data, offset, false);
    }

    protected VPackGenerator _createGenerator(Writer out, IOContext ctxt) {
        return (VPackGenerator)((Object)this.nonByteTarget());
    }

    protected VPackGenerator _createUTF8Generator(OutputStream out, IOContext ctxt) {
        return this.createVelocypackGenerator(ctxt, this._generatorFeatures, this._objectCodec, out);
    }

    protected Writer _createWriter(OutputStream out, JsonEncoding enc, IOContext ctxt) {
        return (Writer)this.nonByteTarget();
    }

    private final VPackGenerator createVelocypackGenerator(IOContext ctxt, int stdFeat, ObjectCodec codec, OutputStream out) {
        return new VPackGenerator(ctxt, stdFeat, codec, out);
    }

    protected <T> T nonByteSource() {
        throw new UnsupportedOperationException("Can not create parser for non-byte-based source");
    }

    protected <T> T nonByteTarget() {
        throw new UnsupportedOperationException("Can not create generator for non-byte-based target");
    }

    static {
        Version version = com.fasterxml.jackson.databind.cfg.PackageVersion.VERSION;
        int major = version.getMajorVersion();
        int minor = version.getMinorVersion();
        if (major != 2 || minor < 10 || minor > 18) {
            LoggerFactory.getLogger(VPackFactory.class).warn("Unsupported version of jackson-databind: {}", (Object)version);
        }
    }
}

