/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.serde.jackson.internal;

import com.arangodb.serde.jackson.From;
import com.arangodb.serde.jackson.Id;
import com.arangodb.serde.jackson.Key;
import com.arangodb.serde.jackson.Rev;
import com.arangodb.serde.jackson.To;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

class ArangoSerdeAnnotationIntrospector
extends JacksonAnnotationIntrospector {
    private static final JsonInclude JSON_INCLUDE_NON_NULL = JsonIncludeNonNull.class.getAnnotation(JsonInclude.class);
    private static final Map<Class<? extends Annotation>, String> MAPPINGS = new HashMap<Class<? extends Annotation>, String>();
    private static final Class<? extends Annotation>[] ANNOTATIONS;

    ArangoSerdeAnnotationIntrospector() {
    }

    public PropertyName findNameForSerialization(Annotated a) {
        return Optional.ofNullable(this.findMapping(a)).orElseGet(() -> super.findNameForSerialization(a));
    }

    public PropertyName findNameForDeserialization(Annotated a) {
        return Optional.ofNullable(this.findMapping(a)).orElseGet(() -> super.findNameForDeserialization(a));
    }

    private PropertyName findMapping(Annotated a) {
        for (Map.Entry<Class<? extends Annotation>, String> e : MAPPINGS.entrySet()) {
            if (!this._hasAnnotation(a, e.getKey())) continue;
            return PropertyName.construct((String)e.getValue());
        }
        return null;
    }

    public JsonInclude.Value findPropertyInclusion(Annotated a) {
        if (this._hasOneOf(a, ANNOTATIONS)) {
            return new JsonInclude.Value(JSON_INCLUDE_NON_NULL);
        }
        return super.findPropertyInclusion(a);
    }

    static {
        MAPPINGS.put(Id.class, "_id");
        MAPPINGS.put(Key.class, "_key");
        MAPPINGS.put(Rev.class, "_rev");
        MAPPINGS.put(From.class, "_from");
        MAPPINGS.put(To.class, "_to");
        ANNOTATIONS = MAPPINGS.keySet().toArray(new Class[0]);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private static class JsonIncludeNonNull {
        private JsonIncludeNonNull() {
        }
    }
}

