/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.serde.jackson.internal;

import com.arangodb.serde.jackson.JacksonSerde;
import com.arangodb.serde.jackson.internal.ArangoSerdeAnnotationIntrospector;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.function.Consumer;

public final class JacksonSerdeImpl
implements JacksonSerde {
    private final ObjectMapper mapper;

    public JacksonSerdeImpl(ObjectMapper mapper) {
        this.mapper = mapper;
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new ArangoSerdeAnnotationIntrospector());
    }

    public byte[] serialize(Object value) {
        try {
            return this.mapper.writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T deserialize(byte[] content, Class<T> type) {
        try {
            return (T)this.mapper.readerFor(this.mapper.constructType(type)).readValue(content);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public JacksonSerde configure(Consumer<ObjectMapper> configureFunction) {
        configureFunction.accept(this.mapper);
        return this;
    }
}

