/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.velocypack;

import com.arangodb.velocypack.VPackBuilder;
import com.arangodb.velocypack.VPackJsonDeserializer;
import com.arangodb.velocypack.VPackJsonSerializer;
import com.arangodb.velocypack.VPackParserModule;
import com.arangodb.velocypack.VPackParserSetupContext;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.ValueType;
import com.arangodb.velocypack.exception.VPackBuilderException;
import com.arangodb.velocypack.exception.VPackException;
import com.arangodb.velocypack.internal.util.DateUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.simple.JSONValue;
import org.json.simple.parser.ContentHandler;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class VPackParser {
    private static final char OBJECT_OPEN = '{';
    private static final char OBJECT_CLOSE = '}';
    private static final char ARRAY_OPEN = '[';
    private static final char ARRAY_CLOSE = ']';
    private static final char FIELD = ':';
    private static final char SEPARATOR = ',';
    private static final String NULL = "null";
    private static final String NON_REPRESENTABLE_TYPE = "(non-representable type)";
    private final Map<ValueType, VPackJsonDeserializer> deserializers;
    private final Map<String, Map<ValueType, VPackJsonDeserializer>> deserializersByName;
    private final Map<Class<?>, VPackJsonSerializer<?>> serializers;
    private final Map<String, Map<Class<?>, VPackJsonSerializer<?>>> serializersByName;

    @Deprecated
    public VPackParser() {
        this(new HashMap(), new HashMap(), new HashMap<ValueType, VPackJsonDeserializer>(), new HashMap<String, Map<ValueType, VPackJsonDeserializer>>());
    }

    private VPackParser(Map<Class<?>, VPackJsonSerializer<?>> serializers, Map<String, Map<Class<?>, VPackJsonSerializer<?>>> serializersByName, Map<ValueType, VPackJsonDeserializer> deserializers, Map<String, Map<ValueType, VPackJsonDeserializer>> deserializersByName) {
        this.serializers = serializers;
        this.serializersByName = serializersByName;
        this.deserializers = deserializers;
        this.deserializersByName = deserializersByName;
    }

    @Deprecated
    public VPackParser registerDeserializer(String attribute, ValueType type, VPackJsonDeserializer deserializer) {
        Map<ValueType, VPackJsonDeserializer> byName = this.deserializersByName.get(attribute);
        if (byName == null) {
            byName = new HashMap<ValueType, VPackJsonDeserializer>();
            this.deserializersByName.put(attribute, byName);
        }
        byName.put(type, deserializer);
        return this;
    }

    @Deprecated
    public VPackParser registerDeserializer(ValueType type, VPackJsonDeserializer deserializer) {
        this.deserializers.put(type, deserializer);
        return this;
    }

    @Deprecated
    public <T> VPackParser registerSerializer(String attribute, Class<T> type, VPackJsonSerializer<T> serializer) {
        Map<Class<?>, VPackJsonSerializer<?>> byName = this.serializersByName.get(attribute);
        if (byName == null) {
            byName = new HashMap();
            this.serializersByName.put(attribute, byName);
        }
        byName.put(type, serializer);
        return this;
    }

    @Deprecated
    public <T> VPackParser registerSerializer(Class<T> type, VPackJsonSerializer<T> serializer) {
        this.serializers.put(type, serializer);
        return this;
    }

    public String toJson(VPackSlice vpack) throws VPackException {
        return this.toJson(vpack, false);
    }

    public String toJson(VPackSlice vpack, boolean includeNullValues) throws VPackException {
        StringBuilder json = new StringBuilder();
        this.parse(null, null, vpack, json, includeNullValues);
        return json.toString();
    }

    private VPackJsonDeserializer getDeserializer(String attribute, ValueType type) {
        VPackJsonDeserializer deserializer = null;
        Map<ValueType, VPackJsonDeserializer> byName = this.deserializersByName.get(attribute);
        if (byName != null) {
            deserializer = byName.get((Object)type);
        }
        if (deserializer == null) {
            deserializer = this.deserializers.get((Object)type);
        }
        return deserializer;
    }

    private VPackJsonSerializer<?> getSerializer(String attribute, Class<?> type) {
        VPackJsonSerializer<?> serializer = null;
        Map<Class<?>, VPackJsonSerializer<?>> byName = this.serializersByName.get(attribute);
        if (byName != null) {
            serializer = byName.get(type);
        }
        if (serializer == null) {
            serializer = this.serializers.get(type);
        }
        return serializer;
    }

    private void parse(VPackSlice parent, String attribute, VPackSlice value, StringBuilder json, boolean includeNullValues) throws VPackException {
        VPackJsonDeserializer deserializer = null;
        if (attribute != null) {
            VPackParser.appendField(attribute, json);
            deserializer = this.getDeserializer(attribute, value.getType());
        }
        if (deserializer != null) {
            deserializer.deserialize(parent, attribute, value, json);
        } else if (value.isObject()) {
            this.parseObject(value, json, includeNullValues);
        } else if (value.isArray()) {
            this.parseArray(value, json, includeNullValues);
        } else if (value.isBoolean()) {
            json.append(value.getAsBoolean());
        } else if (value.isString()) {
            json.append(JSONValue.toJSONString((Object)value.getAsString()));
        } else if (value.isDouble()) {
            json.append(value.getAsDouble());
        } else if (value.isInt()) {
            json.append(value.getAsLong());
        } else if (value.isNumber()) {
            json.append(value.getAsNumber());
        } else if (value.isDate()) {
            json.append(JSONValue.toJSONString((Object)DateUtil.format(value.getAsDate())));
        } else if (value.isNull()) {
            json.append(NULL);
        } else {
            json.append(JSONValue.toJSONString((Object)NON_REPRESENTABLE_TYPE));
        }
    }

    private static void appendField(String attribute, StringBuilder json) {
        json.append(JSONValue.toJSONString((Object)attribute));
        json.append(':');
    }

    private void parseObject(VPackSlice value, StringBuilder json, boolean includeNullValues) throws VPackException {
        json.append('{');
        int added = 0;
        Iterator<Map.Entry<String, VPackSlice>> iterator = value.objectIterator();
        while (iterator.hasNext()) {
            Map.Entry<String, VPackSlice> next = iterator.next();
            VPackSlice nextValue = next.getValue();
            if (nextValue.isNull() && !includeNullValues) continue;
            if (added++ > 0) {
                json.append(',');
            }
            this.parse(value, next.getKey(), nextValue, json, includeNullValues);
        }
        json.append('}');
    }

    private void parseArray(VPackSlice value, StringBuilder json, boolean includeNullValues) throws VPackException {
        json.append('[');
        int added = 0;
        for (int i = 0; i < value.getLength(); ++i) {
            VPackSlice valueAt = value.get(i);
            if (valueAt.isNull() && !includeNullValues) continue;
            if (added++ > 0) {
                json.append(',');
            }
            this.parse(value, null, valueAt, json, includeNullValues);
        }
        json.append(']');
    }

    public VPackSlice fromJson(String json) throws VPackException {
        return this.fromJson(json, false);
    }

    public VPackSlice fromJson(String json, boolean includeNullValues) throws VPackException {
        VPackBuilder builder = new VPackBuilder();
        JSONParser parser = new JSONParser();
        VPackContentHandler contentHandler = new VPackContentHandler(builder, includeNullValues, this);
        try {
            parser.parse(json, (ContentHandler)contentHandler);
        }
        catch (ParseException e) {
            throw new VPackBuilderException(e);
        }
        return builder.slice();
    }

    public VPackSlice fromJson(Iterable<String> jsons) throws VPackException {
        return this.fromJson(jsons, false);
    }

    public VPackSlice fromJson(Iterable<String> jsons, boolean includeNullValues) throws VPackException {
        VPackBuilder builder = new VPackBuilder();
        JSONParser parser = new JSONParser();
        VPackContentHandler contentHandler = new VPackContentHandler(builder, includeNullValues, this);
        try {
            builder.add(ValueType.ARRAY);
            for (String json : jsons) {
                parser.parse(json, (ContentHandler)contentHandler);
            }
            builder.close();
        }
        catch (ParseException e) {
            throw new VPackBuilderException(e);
        }
        return builder.slice();
    }

    private static class VPackContentHandler
    implements ContentHandler {
        private final VPackBuilder builder;
        private String attribute;
        private final boolean includeNullValues;
        private final VPackParser parser;

        public VPackContentHandler(VPackBuilder builder, boolean includeNullValues, VPackParser parser) {
            this.builder = builder;
            this.includeNullValues = includeNullValues;
            this.parser = parser;
            this.attribute = null;
        }

        private void add(ValueType value) throws ParseException {
            try {
                this.builder.add(this.attribute, value);
                this.attribute = null;
            }
            catch (VPackBuilderException e) {
                throw new ParseException(2);
            }
        }

        private void add(String value) throws ParseException {
            try {
                this.builder.add(this.attribute, value);
                this.attribute = null;
            }
            catch (VPackBuilderException e) {
                throw new ParseException(2);
            }
        }

        private void add(Boolean value) throws ParseException {
            try {
                this.builder.add(this.attribute, value);
                this.attribute = null;
            }
            catch (VPackBuilderException e) {
                throw new ParseException(2);
            }
        }

        private void add(Double value) throws ParseException {
            try {
                this.builder.add(this.attribute, value);
                this.attribute = null;
            }
            catch (VPackBuilderException e) {
                throw new ParseException(2);
            }
        }

        private void add(Long value) throws ParseException {
            try {
                this.builder.add(this.attribute, value);
                this.attribute = null;
            }
            catch (VPackBuilderException e) {
                throw new ParseException(2);
            }
        }

        private void close() throws ParseException {
            try {
                this.builder.close();
            }
            catch (VPackBuilderException e) {
                throw new ParseException(2);
            }
        }

        public void startJSON() throws ParseException, IOException {
        }

        public void endJSON() throws ParseException, IOException {
        }

        public boolean startObject() throws ParseException, IOException {
            this.add(ValueType.OBJECT);
            return true;
        }

        public boolean endObject() throws ParseException, IOException {
            this.close();
            return true;
        }

        public boolean startObjectEntry(String key) throws ParseException, IOException {
            this.attribute = key;
            return true;
        }

        public boolean endObjectEntry() throws ParseException, IOException {
            return true;
        }

        public boolean startArray() throws ParseException, IOException {
            this.add(ValueType.ARRAY);
            return true;
        }

        public boolean endArray() throws ParseException, IOException {
            this.close();
            return true;
        }

        public boolean primitive(Object value) throws ParseException, IOException {
            if (value == null) {
                if (this.includeNullValues) {
                    this.add(ValueType.NULL);
                } else {
                    this.attribute = null;
                }
            } else {
                VPackJsonSerializer serializer = this.parser.getSerializer(this.attribute, value.getClass());
                if (serializer != null) {
                    try {
                        serializer.serialize(this.builder, this.attribute, value);
                        this.attribute = null;
                    }
                    catch (VPackBuilderException e) {
                        throw new ParseException(2);
                    }
                } else if (String.class.isAssignableFrom(value.getClass())) {
                    this.add((String)String.class.cast(value));
                } else if (Boolean.class.isAssignableFrom(value.getClass())) {
                    this.add((Boolean)Boolean.class.cast(value));
                } else if (Double.class.isAssignableFrom(value.getClass())) {
                    this.add((Double)Double.class.cast(value));
                } else if (Number.class.isAssignableFrom(value.getClass())) {
                    this.add((Long)Long.class.cast(value));
                }
            }
            return true;
        }
    }

    public static class Builder
    implements VPackParserSetupContext<Builder> {
        private final Map<ValueType, VPackJsonDeserializer> deserializers = new HashMap<ValueType, VPackJsonDeserializer>();
        private final Map<String, Map<ValueType, VPackJsonDeserializer>> deserializersByName = new HashMap<String, Map<ValueType, VPackJsonDeserializer>>();
        private final Map<Class<?>, VPackJsonSerializer<?>> serializers = new HashMap();
        private final Map<String, Map<Class<?>, VPackJsonSerializer<?>>> serializersByName = new HashMap();

        @Override
        public Builder registerDeserializer(String attribute, ValueType type, VPackJsonDeserializer deserializer) {
            Map<ValueType, VPackJsonDeserializer> byName = this.deserializersByName.get(attribute);
            if (byName == null) {
                byName = new HashMap<ValueType, VPackJsonDeserializer>();
                this.deserializersByName.put(attribute, byName);
            }
            byName.put(type, deserializer);
            return this;
        }

        @Override
        public Builder registerDeserializer(ValueType type, VPackJsonDeserializer deserializer) {
            this.deserializers.put(type, deserializer);
            return this;
        }

        @Override
        public <T> Builder registerSerializer(String attribute, Class<T> type, VPackJsonSerializer<T> serializer) {
            Map<Class<?>, VPackJsonSerializer<?>> byName = this.serializersByName.get(attribute);
            if (byName == null) {
                byName = new HashMap();
                this.serializersByName.put(attribute, byName);
            }
            byName.put(type, serializer);
            return this;
        }

        @Override
        public <T> Builder registerSerializer(Class<T> type, VPackJsonSerializer<T> serializer) {
            this.serializers.put(type, serializer);
            return this;
        }

        @Override
        public Builder registerModule(VPackParserModule module) {
            module.setup(this);
            return this;
        }

        @Override
        public Builder registerModules(VPackParserModule ... modules) {
            for (VPackParserModule module : modules) {
                this.registerModule(module);
            }
            return this;
        }

        public synchronized VPackParser build() {
            return new VPackParser(new HashMap(this.serializers), new HashMap(this.serializersByName), new HashMap<ValueType, VPackJsonDeserializer>(this.deserializers), new HashMap<String, Map<ValueType, VPackJsonDeserializer>>(this.deserializersByName));
        }
    }
}

