/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.velocypack;

import com.arangodb.velocypack.ArrayIterator;
import com.arangodb.velocypack.ObjectIterator;
import com.arangodb.velocypack.VPackAttributeTranslator;
import com.arangodb.velocypack.VPackParser;
import com.arangodb.velocypack.ValueType;
import com.arangodb.velocypack.exception.VPackException;
import com.arangodb.velocypack.exception.VPackKeyTypeException;
import com.arangodb.velocypack.exception.VPackNeedAttributeTranslatorException;
import com.arangodb.velocypack.exception.VPackValueTypeException;
import com.arangodb.velocypack.internal.VPackAttributeTranslatorImpl;
import com.arangodb.velocypack.internal.util.BinaryUtil;
import com.arangodb.velocypack.internal.util.DateUtil;
import com.arangodb.velocypack.internal.util.NumberUtil;
import com.arangodb.velocypack.internal.util.ObjectArrayUtil;
import com.arangodb.velocypack.internal.util.ValueLengthUtil;
import com.arangodb.velocypack.internal.util.ValueTypeUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

public class VPackSlice
implements Serializable {
    private static final long serialVersionUID = -3452953589283603980L;
    public static final VPackAttributeTranslator attributeTranslator = new VPackAttributeTranslatorImpl();
    private final byte[] vpack;
    private final int start;

    protected VPackSlice() {
        this(new byte[]{0}, 0);
    }

    public VPackSlice(byte[] vpack) {
        this(vpack, 0);
    }

    public VPackSlice(byte[] vpack, int start) {
        this.vpack = vpack;
        this.start = start;
    }

    public byte head() {
        return this.vpack[this.start];
    }

    public byte[] getBuffer() {
        return this.vpack;
    }

    public int getStart() {
        return this.start;
    }

    public ValueType getType() {
        return ValueTypeUtil.get(this.head());
    }

    private int length() {
        return ValueLengthUtil.get(this.head()) - 1;
    }

    public boolean isType(ValueType type) {
        return this.getType() == type;
    }

    public boolean isNone() {
        return this.isType(ValueType.NONE);
    }

    public boolean isNull() {
        return this.isType(ValueType.NULL);
    }

    public boolean isIllegal() {
        return this.isType(ValueType.ILLEGAL);
    }

    public boolean isBoolean() {
        return this.isType(ValueType.BOOL);
    }

    public boolean isTrue() {
        return this.head() == 26;
    }

    public boolean isFalse() {
        return this.head() == 25;
    }

    public boolean isArray() {
        return this.isType(ValueType.ARRAY);
    }

    public boolean isObject() {
        return this.isType(ValueType.OBJECT);
    }

    public boolean isDouble() {
        return this.isType(ValueType.DOUBLE);
    }

    public boolean isDate() {
        return this.isType(ValueType.UTC_DATE);
    }

    public boolean isExternal() {
        return this.isType(ValueType.EXTERNAL);
    }

    public boolean isMinKey() {
        return this.isType(ValueType.MIN_KEY);
    }

    public boolean isMaxKey() {
        return this.isType(ValueType.MAX_KEY);
    }

    public boolean isInt() {
        return this.isType(ValueType.INT);
    }

    public boolean isUInt() {
        return this.isType(ValueType.UINT);
    }

    public boolean isSmallInt() {
        return this.isType(ValueType.SMALLINT);
    }

    public boolean isInteger() {
        return this.isInt() || this.isUInt() || this.isSmallInt();
    }

    public boolean isNumber() {
        return this.isInteger() || this.isDouble();
    }

    public boolean isString() {
        return this.isType(ValueType.STRING);
    }

    public boolean isBinary() {
        return this.isType(ValueType.BINARY);
    }

    public boolean isBCD() {
        return this.isType(ValueType.BCD);
    }

    public boolean isCustom() {
        return this.isType(ValueType.CUSTOM);
    }

    public boolean getAsBoolean() {
        if (!this.isBoolean()) {
            throw new VPackValueTypeException(ValueType.BOOL);
        }
        return this.isTrue();
    }

    public double getAsDouble() {
        return this.getAsNumber().doubleValue();
    }

    private double getAsDoubleUnchecked() {
        return NumberUtil.toDouble(this.vpack, this.start + 1, this.length());
    }

    public BigDecimal getAsBigDecimal() {
        if (this.isString()) {
            return new BigDecimal(this.getAsString());
        }
        if (this.isDouble()) {
            return BigDecimal.valueOf(this.getAsDouble());
        }
        throw new VPackValueTypeException(ValueType.STRING, ValueType.DOUBLE);
    }

    private long getSmallInt() {
        byte head = this.head();
        long smallInt = head >= 48 && head <= 57 ? (long)(head - 48) : (long)(head - 58 - 6);
        return smallInt;
    }

    private long getInt() {
        return NumberUtil.toLong(this.vpack, this.start + 1, this.length(), true);
    }

    private long getUInt() {
        return NumberUtil.toLong(this.vpack, this.start + 1, this.length());
    }

    public Number getAsNumber() {
        Number result;
        if (this.isSmallInt()) {
            result = this.getSmallInt();
        } else if (this.isInt()) {
            result = this.getInt();
        } else if (this.isUInt()) {
            result = this.getUInt();
        } else if (this.isDouble()) {
            result = this.getAsDoubleUnchecked();
        } else {
            throw new VPackValueTypeException(ValueType.INT, ValueType.UINT, ValueType.SMALLINT);
        }
        return result;
    }

    public long getAsLong() {
        return this.getAsNumber().longValue();
    }

    public int getAsInt() {
        return this.getAsNumber().intValue();
    }

    public float getAsFloat() {
        return this.getAsNumber().floatValue();
    }

    public short getAsShort() {
        return this.getAsNumber().shortValue();
    }

    public byte getAsByte() {
        return this.getAsNumber().byteValue();
    }

    public BigInteger getAsBigInteger() {
        if (this.isString()) {
            return new BigInteger(this.getAsString());
        }
        if (this.isSmallInt() || this.isInt()) {
            return BigInteger.valueOf(this.getAsLong());
        }
        if (this.isUInt()) {
            return NumberUtil.toBigInteger(this.vpack, this.start + 1, this.length());
        }
        throw new VPackValueTypeException(ValueType.STRING, ValueType.INT, ValueType.UINT, ValueType.SMALLINT);
    }

    public java.util.Date getAsDate() {
        if (!this.isDate()) {
            throw new VPackValueTypeException(ValueType.UTC_DATE);
        }
        return DateUtil.toDate(this.vpack, this.start + 1, this.length());
    }

    public Date getAsSQLDate() {
        if (!this.isDate()) {
            throw new VPackValueTypeException(ValueType.UTC_DATE);
        }
        return DateUtil.toSQLDate(this.vpack, this.start + 1, this.length());
    }

    public Timestamp getAsSQLTimestamp() {
        if (!this.isDate()) {
            throw new VPackValueTypeException(ValueType.UTC_DATE);
        }
        return DateUtil.toSQLTimestamp(this.vpack, this.start + 1, this.length());
    }

    public String getAsString() {
        if (!this.isString()) {
            throw new VPackValueTypeException(ValueType.STRING);
        }
        return this.isLongString() ? this.getLongString() : this.getShortString();
    }

    public char getAsChar() {
        return this.getAsString().charAt(0);
    }

    private boolean isLongString() {
        return this.head() == -65;
    }

    private String getShortString() {
        return new String(this.vpack, this.start + 1, this.length(), Charset.forName("UTF-8"));
    }

    private String getLongString() {
        return new String(this.vpack, this.start + 9, this.getLongStringLength(), Charset.forName("UTF-8"));
    }

    private int getLongStringLength() {
        return (int)NumberUtil.toLong(this.vpack, this.start + 1, 8);
    }

    private int getStringLength() {
        return this.isLongString() ? this.getLongStringLength() : this.head() - 64;
    }

    public byte[] getAsBinary() {
        if (!this.isBinary()) {
            throw new VPackValueTypeException(ValueType.BINARY);
        }
        byte[] binary = BinaryUtil.toBinary(this.vpack, this.start + 1 + this.head() - -65, this.getBinaryLength());
        return binary;
    }

    public int getBinaryLength() {
        if (!this.isBinary()) {
            throw new VPackValueTypeException(ValueType.BINARY);
        }
        return this.getBinaryLengthUnchecked();
    }

    private int getBinaryLengthUnchecked() {
        return (int)NumberUtil.toLong(this.vpack, this.start + 1, this.head() - -65);
    }

    public int getLength() {
        long length;
        if (this.isString()) {
            length = this.getStringLength();
        } else {
            if (!this.isArray() && !this.isObject()) {
                throw new VPackValueTypeException(ValueType.ARRAY, ValueType.OBJECT, ValueType.STRING);
            }
            byte head = this.head();
            if (head == 1 || head == 10) {
                length = 0L;
            } else if (head == 19 || head == 20) {
                long end = NumberUtil.readVariableValueLength(this.vpack, this.start + 1, false);
                length = NumberUtil.readVariableValueLength(this.vpack, (int)((long)this.start + end - 1L), true);
            } else {
                int offsetsize = ObjectArrayUtil.getOffsetSize(head);
                long end = NumberUtil.toLong(this.vpack, this.start + 1, offsetsize);
                if (head <= 5) {
                    int dataOffset = this.findDataOffset();
                    VPackSlice first = new VPackSlice(this.vpack, this.start + dataOffset);
                    length = (end - (long)dataOffset) / (long)first.getByteSize();
                } else {
                    length = offsetsize < 8 ? NumberUtil.toLong(this.vpack, this.start + 1 + offsetsize, offsetsize) : NumberUtil.toLong(this.vpack, (int)((long)this.start + end - (long)offsetsize), offsetsize);
                }
            }
        }
        return (int)length;
    }

    public int size() {
        return this.getLength();
    }

    protected int findDataOffset() {
        int fsm = ObjectArrayUtil.getFirstSubMap(this.head());
        int offset = fsm <= 2 && this.vpack[this.start + 2] != 0 ? 2 : (fsm <= 3 && this.vpack[this.start + 3] != 0 ? 3 : (fsm <= 5 && this.vpack[this.start + 6] != 0 ? 5 : 9));
        return offset;
    }

    public int getByteSize() {
        long size;
        byte head = this.head();
        int valueLength = ValueLengthUtil.get(head);
        if (valueLength != 0) {
            size = valueLength;
        } else {
            switch (this.getType()) {
                case ARRAY: 
                case OBJECT: {
                    if (head == 19 || head == 20) {
                        size = NumberUtil.readVariableValueLength(this.vpack, this.start + 1, false);
                        break;
                    }
                    size = NumberUtil.toLong(this.vpack, this.start + 1, ObjectArrayUtil.getOffsetSize(head));
                    break;
                }
                case STRING: {
                    size = this.getLongStringLength() + 1 + 8;
                    break;
                }
                case BINARY: {
                    size = 1 + head - -65 + this.getBinaryLengthUnchecked();
                    break;
                }
                case BCD: {
                    if (head <= 207) {
                        size = (long)(1 + head + -57) + NumberUtil.toLong(this.vpack, this.start + 1, head - -57);
                        break;
                    }
                    size = (long)(1 + head - -49) + NumberUtil.toLong(this.vpack, this.start + 1, head - -49);
                    break;
                }
                case CUSTOM: {
                    if (head == 244 || head == 245 || head == 246) {
                        size = 2L + NumberUtil.toLong(this.vpack, this.start + 1, 1);
                        break;
                    }
                    if (head == 247 || head == 248 || head == 249) {
                        size = 3L + NumberUtil.toLong(this.vpack, this.start + 1, 2);
                        break;
                    }
                    if (head == 250 || head == 251 || head == 252) {
                        size = 5L + NumberUtil.toLong(this.vpack, this.start + 1, 4);
                        break;
                    }
                    size = 9L + NumberUtil.toLong(this.vpack, this.start + 1, 8);
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        }
        return (int)size;
    }

    public VPackSlice get(int index) {
        if (!this.isArray()) {
            throw new VPackValueTypeException(ValueType.ARRAY);
        }
        return this.getNth(index);
    }

    public VPackSlice get(String attribute) throws VPackException {
        if (!this.isObject()) {
            throw new VPackValueTypeException(ValueType.OBJECT);
        }
        byte head = this.head();
        VPackSlice result = new VPackSlice();
        if (head == 10) {
            result = new VPackSlice();
        } else if (head == 20) {
            result = this.getFromCompactObject(attribute);
        } else {
            int offsetsize = ObjectArrayUtil.getOffsetSize(head);
            long end = NumberUtil.toLong(this.vpack, this.start + 1, offsetsize);
            long n = offsetsize < 8 ? NumberUtil.toLong(this.vpack, this.start + 1 + offsetsize, offsetsize) : NumberUtil.toLong(this.vpack, (int)((long)this.start + end - (long)offsetsize), offsetsize);
            if (n == 1L) {
                VPackSlice key = new VPackSlice(this.vpack, this.start + this.findDataOffset());
                if (key.isString()) {
                    result = key.isEqualString(attribute) ? new VPackSlice(this.vpack, key.start + key.getByteSize()) : new VPackSlice();
                } else if (key.isInteger()) {
                    if (attributeTranslator == null) {
                        throw new VPackNeedAttributeTranslatorException();
                    }
                    result = key.translateUnchecked().isEqualString(attribute) ? new VPackSlice(this.vpack, key.start + key.getByteSize()) : new VPackSlice();
                } else {
                    result = new VPackSlice();
                }
            } else {
                long ieBase = end - n * (long)offsetsize - (long)(offsetsize == 8 ? 8 : 0);
                long sortedSearchEntriesThreshold = 4L;
                boolean sorted = head >= 11 && head <= 14;
                result = sorted && n >= 4L ? this.searchObjectKeyBinary(attribute, ieBase, offsetsize, n) : this.searchObjectKeyLinear(attribute, ieBase, offsetsize, n);
            }
        }
        return result;
    }

    protected VPackSlice translateUnchecked() {
        VPackSlice result = attributeTranslator.translate(this.getAsInt());
        return result != null ? result : new VPackSlice();
    }

    protected VPackSlice makeKey() throws VPackKeyTypeException, VPackNeedAttributeTranslatorException {
        if (this.isString()) {
            return this;
        }
        if (this.isInteger()) {
            if (attributeTranslator == null) {
                throw new VPackNeedAttributeTranslatorException();
            }
            return this.translateUnchecked();
        }
        throw new VPackKeyTypeException("Cannot translate key of this type");
    }

    private VPackSlice getFromCompactObject(String attribute) throws VPackKeyTypeException, VPackNeedAttributeTranslatorException {
        Iterator<Map.Entry<String, VPackSlice>> iterator = this.objectIterator();
        while (iterator.hasNext()) {
            Map.Entry<String, VPackSlice> next = iterator.next();
            if (!next.getKey().equals(attribute)) continue;
            return next.getValue();
        }
        return new VPackSlice();
    }

    private VPackSlice searchObjectKeyBinary(String attribute, long ieBase, int offsetsize, long n) throws VPackValueTypeException, VPackNeedAttributeTranslatorException {
        VPackSlice result;
        block8: {
            boolean useTranslator = attributeTranslator != null;
            long l = 0L;
            long r = n - 1L;
            do {
                long index = l + (r - l) / 2L;
                long offset = ieBase + index * (long)offsetsize;
                long keyIndex = NumberUtil.toLong(this.vpack, (int)((long)this.start + offset), offsetsize);
                VPackSlice key = new VPackSlice(this.vpack, (int)((long)this.start + keyIndex));
                int res = 0;
                if (key.isString()) {
                    res = key.compareString(attribute);
                } else {
                    if (!key.isInteger()) {
                        result = new VPackSlice();
                        break block8;
                    }
                    if (!useTranslator) {
                        throw new VPackNeedAttributeTranslatorException();
                    }
                    res = key.translateUnchecked().compareString(attribute);
                }
                if (res == 0) {
                    result = new VPackSlice(this.vpack, key.start + key.getByteSize());
                    break block8;
                }
                if (res > 0) {
                    if (index == 0L) {
                        result = new VPackSlice();
                        break block8;
                    }
                    r = index - 1L;
                    continue;
                }
                l = index + 1L;
            } while (r >= l);
            result = new VPackSlice();
        }
        return result;
    }

    private VPackSlice searchObjectKeyLinear(String attribute, long ieBase, int offsetsize, long n) throws VPackValueTypeException, VPackNeedAttributeTranslatorException {
        boolean useTranslator = attributeTranslator != null;
        VPackSlice result = new VPackSlice();
        for (long index = 0L; index < n; ++index) {
            long offset = ieBase + index * (long)offsetsize;
            long keyIndex = NumberUtil.toLong(this.vpack, (int)((long)this.start + offset), offsetsize);
            VPackSlice key = new VPackSlice(this.vpack, (int)((long)this.start + keyIndex));
            if (key.isString()) {
                if (!key.isEqualString(attribute)) {
                    continue;
                }
            } else if (key.isInteger()) {
                if (!useTranslator) {
                    throw new VPackNeedAttributeTranslatorException();
                }
                if (!key.translateUnchecked().isEqualString(attribute)) {
                    continue;
                }
            } else {
                result = new VPackSlice();
                break;
            }
            result = new VPackSlice(this.vpack, key.start + key.getByteSize());
            break;
        }
        return result;
    }

    public VPackSlice keyAt(int index) {
        if (!this.isObject()) {
            throw new VPackValueTypeException(ValueType.OBJECT);
        }
        return this.getNthKey(index);
    }

    public VPackSlice valueAt(int index) {
        if (!this.isObject()) {
            throw new VPackValueTypeException(ValueType.OBJECT);
        }
        VPackSlice key = this.getNthKey(index);
        return new VPackSlice(this.vpack, key.start + key.getByteSize());
    }

    private VPackSlice getNthKey(int index) {
        return new VPackSlice(this.vpack, this.start + this.getNthOffset(index));
    }

    private VPackSlice getNth(int index) {
        return new VPackSlice(this.vpack, this.start + this.getNthOffset(index));
    }

    private int getNthOffset(int index) {
        int offset;
        byte head = this.head();
        if (head == 19 || head == 20) {
            offset = this.getNthOffsetFromCompact(index);
        } else {
            long n;
            if (head == 1 || head == 10) {
                throw new IndexOutOfBoundsException();
            }
            int offsetsize = ObjectArrayUtil.getOffsetSize(head);
            long end = NumberUtil.toLong(this.vpack, this.start + 1, offsetsize);
            int dataOffset = this.findDataOffset();
            if (head <= 5) {
                VPackSlice first = new VPackSlice(this.vpack, this.start + dataOffset);
                n = (end - (long)dataOffset) / (long)first.getByteSize();
            } else {
                n = offsetsize < 8 ? NumberUtil.toLong(this.vpack, this.start + 1 + offsetsize, offsetsize) : NumberUtil.toLong(this.vpack, (int)((long)this.start + end - (long)offsetsize), offsetsize);
            }
            if ((long)index >= n) {
                throw new IndexOutOfBoundsException();
            }
            if (head <= 5 || n == 1L) {
                if (dataOffset == 0) {
                    dataOffset = this.findDataOffset();
                }
                offset = dataOffset + index * new VPackSlice(this.vpack, this.start + dataOffset).getByteSize();
            } else {
                long ieBase = end - n * (long)offsetsize + (long)(index * offsetsize) - (long)(offsetsize == 8 ? 8 : 0);
                offset = (int)NumberUtil.toLong(this.vpack, (int)((long)this.start + ieBase), offsetsize);
            }
        }
        return offset;
    }

    private int getNthOffsetFromCompact(int index) {
        long end = NumberUtil.readVariableValueLength(this.vpack, this.start + 1, false);
        long n = NumberUtil.readVariableValueLength(this.vpack, (int)((long)this.start + end - 1L), true);
        if ((long)index >= n) {
            throw new IndexOutOfBoundsException();
        }
        byte head = this.head();
        long offset = 1L + NumberUtil.getVariableValueLength(end);
        for (long current = 0L; current != (long)index; ++current) {
            long byteSize = new VPackSlice(this.vpack, (int)((long)this.start + offset)).getByteSize();
            offset += byteSize;
            if (head != 20) continue;
            offset += byteSize;
        }
        return (int)offset;
    }

    private boolean isEqualString(String s) {
        String string = this.getAsString();
        return string.equals(s);
    }

    private int compareString(String s) {
        String string = this.getAsString();
        return string.compareTo(s);
    }

    public Iterator<VPackSlice> arrayIterator() {
        if (this.isArray()) {
            return new ArrayIterator(this);
        }
        throw new VPackValueTypeException(ValueType.ARRAY);
    }

    public Iterator<Map.Entry<String, VPackSlice>> objectIterator() {
        if (this.isObject()) {
            return new ObjectIterator(this);
        }
        throw new VPackValueTypeException(ValueType.OBJECT);
    }

    protected byte[] getRawVPack() {
        return Arrays.copyOfRange(this.vpack, this.start, this.start + this.getByteSize());
    }

    public String toString() {
        try {
            return new VPackParser.Builder().build().toJson(this, true);
        }
        catch (VPackException e) {
            return super.toString();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.start;
        result = 31 * result + Arrays.hashCode(this.getRawVPack());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VPackSlice other = (VPackSlice)obj;
        if (this.start != other.start) {
            return false;
        }
        return Arrays.equals(this.getRawVPack(), other.getRawVPack());
    }
}

