/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.velocypack;

import com.arangodb.velocypack.VPackAnnotationFieldFilter;
import com.arangodb.velocypack.VPackAnnotationFieldNaming;
import com.arangodb.velocypack.VPackBuilder;
import com.arangodb.velocypack.VPackDeserializationContext;
import com.arangodb.velocypack.VPackDeserializer;
import com.arangodb.velocypack.VPackDeserializerParameterizedType;
import com.arangodb.velocypack.VPackFieldNamingStrategy;
import com.arangodb.velocypack.VPackInstanceCreator;
import com.arangodb.velocypack.VPackKeyMapAdapter;
import com.arangodb.velocypack.VPackModule;
import com.arangodb.velocypack.VPackSerializationContext;
import com.arangodb.velocypack.VPackSerializer;
import com.arangodb.velocypack.VPackSetupContext;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.ValueType;
import com.arangodb.velocypack.annotations.Expose;
import com.arangodb.velocypack.annotations.SerializedName;
import com.arangodb.velocypack.exception.VPackException;
import com.arangodb.velocypack.exception.VPackParserException;
import com.arangodb.velocypack.internal.DefaultVPackBuilderOptions;
import com.arangodb.velocypack.internal.VPackCache;
import com.arangodb.velocypack.internal.VPackDeserializers;
import com.arangodb.velocypack.internal.VPackInstanceCreators;
import com.arangodb.velocypack.internal.VPackKeyMapAdapters;
import com.arangodb.velocypack.internal.VPackSerializers;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class VPack {
    private static final String ATTR_KEY = "key";
    private static final String ATTR_VALUE = "value";
    private static final String DEFAULT_TYPE_KEY = "_class";
    private final Map<Type, VPackSerializer<?>> serializers;
    private final Map<Type, VPackSerializer<?>> enclosingSerializers;
    private final Map<Type, VPackDeserializer<?>> deserializers;
    private final Map<Type, VPackDeserializer<?>> deserializersWithSelfNullHandle;
    private final Map<String, Map<Type, VPackDeserializer<?>>> deserializersByName;
    private final Map<String, Map<Type, VPackDeserializer<?>>> deserializersByNameWithSelfNullHandle;
    private final Map<Type, VPackInstanceCreator<?>> instanceCreators;
    private final Map<Type, VPackKeyMapAdapter<?>> keyMapAdapters;
    private final VPackBuilder.BuilderOptions builderOptions;
    private final VPackCache cache;
    private final VPackSerializationContext serializationContext;
    private final VPackDeserializationContext deserializationContext;
    private final boolean serializeNullValues;
    private final String typeKey;

    private VPack(Map<Type, VPackSerializer<?>> serializers, Map<Type, VPackSerializer<?>> enclosingSerializers, Map<Type, VPackDeserializer<?>> deserializers, Map<Type, VPackDeserializer<?>> deserializersWithSelfNullHandle, Map<Type, VPackInstanceCreator<?>> instanceCreators, VPackBuilder.BuilderOptions builderOptions, boolean serializeNullValues, VPackFieldNamingStrategy fieldNamingStrategy, Map<String, Map<Type, VPackDeserializer<?>>> deserializersByName, Map<String, Map<Type, VPackDeserializer<?>>> deserializersByNameWithSelfNullHandle, Map<Class<? extends Annotation>, VPackAnnotationFieldFilter<? extends Annotation>> annotationFieldFilter, Map<Class<? extends Annotation>, VPackAnnotationFieldNaming<? extends Annotation>> annotationFieldNaming, Map<Type, VPackKeyMapAdapter<?>> keyMapAdapters, String typeKey) {
        this.serializers = serializers;
        this.enclosingSerializers = enclosingSerializers;
        this.deserializers = deserializers;
        this.deserializersWithSelfNullHandle = deserializersWithSelfNullHandle;
        this.instanceCreators = instanceCreators;
        this.builderOptions = builderOptions;
        this.serializeNullValues = serializeNullValues;
        this.deserializersByName = deserializersByName;
        this.deserializersByNameWithSelfNullHandle = deserializersByNameWithSelfNullHandle;
        this.keyMapAdapters = keyMapAdapters;
        this.typeKey = typeKey;
        this.cache = new VPackCache(fieldNamingStrategy, annotationFieldFilter, annotationFieldNaming);
        this.serializationContext = new VPackSerializationContext(){

            @Override
            public void serialize(VPackBuilder builder, String attribute, Object entity) throws VPackParserException {
                VPack.this.serialize(attribute, entity, entity != null ? entity.getClass() : null, builder, Collections.emptyMap());
            }
        };
        this.deserializationContext = new VPackDeserializationContext(){

            @Override
            public <T> T deserialize(VPackSlice vpack, Type type) throws VPackParserException {
                return VPack.this.deserialize(vpack, type);
            }
        };
        keyMapAdapters.put((Type)((Object)String.class), VPackKeyMapAdapters.STRING);
        keyMapAdapters.put((Type)((Object)Boolean.class), VPackKeyMapAdapters.BOOLEAN);
        keyMapAdapters.put((Type)((Object)Integer.class), VPackKeyMapAdapters.INTEGER);
        keyMapAdapters.put((Type)((Object)Long.class), VPackKeyMapAdapters.LONG);
        keyMapAdapters.put((Type)((Object)Short.class), VPackKeyMapAdapters.SHORT);
        keyMapAdapters.put((Type)((Object)Double.class), VPackKeyMapAdapters.DOUBLE);
        keyMapAdapters.put((Type)((Object)Float.class), VPackKeyMapAdapters.FLOAT);
        keyMapAdapters.put((Type)((Object)BigInteger.class), VPackKeyMapAdapters.BIG_INTEGER);
        keyMapAdapters.put((Type)((Object)BigDecimal.class), VPackKeyMapAdapters.BIG_DECIMAL);
        keyMapAdapters.put((Type)((Object)Number.class), VPackKeyMapAdapters.NUMBER);
        keyMapAdapters.put((Type)((Object)Character.class), VPackKeyMapAdapters.CHARACTER);
    }

    public <T> T deserialize(VPackSlice vpack, Type type) throws VPackParserException {
        Object entity;
        if (type == VPackSlice.class) {
            return (T)vpack;
        }
        try {
            entity = this.getValue(null, vpack, type, null);
        }
        catch (Exception e) {
            throw new VPackParserException(e);
        }
        return (T)entity;
    }

    private VPackDeserializer<?> getDeserializer(String fieldName, Type type) {
        return this.getDeserializer(fieldName, type, this.deserializers, this.deserializersByName);
    }

    private VPackDeserializer<?> getDeserializerWithSelfNullHandle(String fieldName, Type type) {
        return this.getDeserializer(fieldName, type, this.deserializersWithSelfNullHandle, this.deserializersByNameWithSelfNullHandle);
    }

    private VPackDeserializer<?> getDeserializer(String fieldName, Type type, Map<Type, VPackDeserializer<?>> deserializers, Map<String, Map<Type, VPackDeserializer<?>>> deserializersByName) {
        VPackDeserializer<?> deserializer = null;
        Map<Type, VPackDeserializer<?>> byName = deserializersByName.get(fieldName);
        if (byName != null) {
            deserializer = byName.get(type);
        }
        if (deserializer == null) {
            deserializer = deserializers.get(type);
        }
        if (deserializer == null && ParameterizedType.class.isAssignableFrom(type.getClass())) {
            deserializer = this.getDeserializer(fieldName, ((ParameterizedType)ParameterizedType.class.cast(type)).getRawType(), deserializers, deserializersByName);
        }
        return deserializer;
    }

    private <T> T deserializeObject(VPackSlice parent, VPackSlice vpack, Type type, String fieldName) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, VPackException {
        Object entity;
        VPackDeserializer<?> deserializer = this.getDeserializer(fieldName, type);
        if (deserializer != null) {
            entity = VPackDeserializerParameterizedType.class.isAssignableFrom(deserializer.getClass()) && ParameterizedType.class.isAssignableFrom(type.getClass()) ? ((VPackDeserializerParameterizedType)deserializer).deserialize(parent, vpack, this.deserializationContext, (ParameterizedType)ParameterizedType.class.cast(type)) : deserializer.deserialize(parent, vpack, this.deserializationContext);
        } else if (type == Object.class) {
            entity = this.getValue(parent, vpack, this.getType(vpack), fieldName);
        } else {
            entity = this.createInstance(type);
            this.deserializeFields(entity, vpack);
        }
        return entity;
    }

    private Type determineType(VPackSlice vpack, Type type) {
        if (!vpack.isObject()) {
            return type;
        }
        VPackSlice clazz = vpack.get(this.typeKey);
        try {
            return clazz.isString() ? Class.forName(clazz.getAsString()) : type;
        }
        catch (ClassNotFoundException e) {
            throw new VPackParserException(e);
        }
    }

    private Type getType(VPackSlice vpack) {
        Class type = vpack.isObject() ? Map.class : (vpack.isString() ? String.class : (vpack.isBoolean() ? Boolean.class : (vpack.isArray() ? Collection.class : (vpack.isDate() ? java.util.Date.class : (vpack.isDouble() ? Double.class : (vpack.isNumber() ? Number.class : (vpack.isCustom() ? String.class : null)))))));
        return type;
    }

    private <T> T createInstance(Type type) throws InstantiationException, IllegalAccessException {
        VPackInstanceCreator<?> creator = this.instanceCreators.get(type);
        Object entity = creator != null ? creator.createInstance() : (type instanceof ParameterizedType ? this.createInstance(((ParameterizedType)type).getRawType()) : ((Class)type).newInstance());
        return (T)entity;
    }

    private void deserializeFields(Object entity, VPackSlice vpack) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, VPackException {
        Map<String, VPackCache.FieldInfo> fields = this.cache.getFields(entity.getClass());
        Iterator<Map.Entry<String, VPackSlice>> iterator = vpack.objectIterator();
        while (iterator.hasNext()) {
            Map.Entry<String, VPackSlice> next = iterator.next();
            VPackCache.FieldInfo fieldInfo = fields.get(next.getKey());
            if (fieldInfo == null || !fieldInfo.isDeserialize()) continue;
            this.deserializeField(vpack, next.getValue(), entity, fieldInfo);
        }
    }

    private void deserializeField(VPackSlice parent, VPackSlice vpack, Object entity, VPackCache.FieldInfo fieldInfo) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, VPackException {
        if (!vpack.isNone()) {
            Object value = this.getValue(parent, vpack, fieldInfo.getType(), fieldInfo.getFieldName());
            fieldInfo.set(entity, value);
        }
    }

    private <T> Object getValue(VPackSlice parent, VPackSlice vpack, Type type, String fieldName) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, VPackException {
        Object value;
        Type realType = this.determineType(vpack, type);
        if (vpack.isNull()) {
            VPackDeserializer<?> deserializer = this.getDeserializerWithSelfNullHandle(fieldName, realType);
            value = deserializer != null ? (VPackDeserializerParameterizedType.class.isAssignableFrom(deserializer.getClass()) && ParameterizedType.class.isAssignableFrom(realType.getClass()) ? ((VPackDeserializerParameterizedType)deserializer).deserialize(parent, vpack, this.deserializationContext, (ParameterizedType)ParameterizedType.class.cast(realType)) : (Object)deserializer.deserialize(parent, vpack, this.deserializationContext)) : null;
        } else {
            VPackDeserializer<?> deserializer = this.getDeserializer(fieldName, realType);
            if (deserializer != null) {
                value = VPackDeserializerParameterizedType.class.isAssignableFrom(deserializer.getClass()) && ParameterizedType.class.isAssignableFrom(realType.getClass()) ? ((VPackDeserializerParameterizedType)deserializer).deserialize(parent, vpack, this.deserializationContext, (ParameterizedType)ParameterizedType.class.cast(realType)) : (Object)deserializer.deserialize(parent, vpack, this.deserializationContext);
            } else if (realType instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)ParameterizedType.class.cast(realType);
                Type rawType = pType.getRawType();
                if (Collection.class.isAssignableFrom((Class)rawType)) {
                    value = this.deserializeCollection(parent, vpack, realType, pType.getActualTypeArguments()[0]);
                } else if (Map.class.isAssignableFrom((Class)rawType)) {
                    Type[] parameterizedTypes = pType.getActualTypeArguments();
                    value = this.deserializeMap(parent, vpack, realType, parameterizedTypes[0], parameterizedTypes[1]);
                } else {
                    value = this.deserializeObject(parent, vpack, realType, fieldName);
                }
            } else if (realType instanceof WildcardType) {
                WildcardType wType = (WildcardType)WildcardType.class.cast(realType);
                Type rawType = wType.getUpperBounds()[0];
                value = this.deserializeObject(parent, vpack, rawType, fieldName);
            } else {
                if (realType instanceof GenericArrayType) {
                    throw new VPackParserException(new IllegalArgumentException("Generic arrays are not supported!"));
                }
                value = Collection.class.isAssignableFrom((Class)realType) ? this.deserializeCollection(parent, vpack, realType, (Type)((Object)Object.class)) : (Map.class.isAssignableFrom((Class)realType) ? this.deserializeMap(parent, vpack, realType, (Type)((Object)String.class), (Type)((Object)Object.class)) : (((Class)realType).isArray() ? this.deserializeArray(parent, vpack, realType) : (((Class)realType).isEnum() ? Enum.valueOf((Class)realType, vpack.getAsString()) : this.deserializeObject(parent, vpack, realType, fieldName))));
            }
        }
        return value;
    }

    private <T> Object deserializeArray(VPackSlice parent, VPackSlice vpack, Type type) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, VPackException {
        int length = vpack.getLength();
        Class<?> componentType = ((Class)type).getComponentType();
        Object value = Array.newInstance(componentType, length);
        for (int i = 0; i < length; ++i) {
            Array.set(value, i, this.getValue(parent, vpack.get(i), componentType, null));
        }
        return value;
    }

    private <T, C> Object deserializeCollection(VPackSlice parent, VPackSlice vpack, Type type, Type contentType) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, VPackException {
        Collection value = (Collection)this.createInstance(type);
        long length = vpack.getLength();
        if (length > 0L) {
            int i = 0;
            while ((long)i < length) {
                value.add(this.getValue(parent, vpack.get(i), contentType, null));
                ++i;
            }
        }
        return value;
    }

    private <T, K, C> Object deserializeMap(VPackSlice parent, VPackSlice vpack, Type type, Type keyType, Type valueType) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, VPackException {
        Map value;
        block4: {
            int length = vpack.getLength();
            value = (Map)this.createInstance(type);
            if (length <= 0) break block4;
            VPackKeyMapAdapter<Object> keyMapAdapter = this.getKeyMapAdapter(keyType);
            if (keyMapAdapter != null) {
                Iterator<Map.Entry<String, VPackSlice>> iterator = vpack.objectIterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, VPackSlice> next = iterator.next();
                    Object name = keyMapAdapter.deserialize(next.getKey());
                    value.put(name, this.getValue(vpack, next.getValue(), valueType, name.toString()));
                }
            } else {
                for (int i = 0; i < vpack.getLength(); ++i) {
                    VPackSlice entry = vpack.get(i);
                    Object mapKey = this.getValue(parent, entry.get(ATTR_KEY), keyType, null);
                    Object mapValue = this.getValue(parent, entry.get(ATTR_VALUE), valueType, null);
                    value.put(mapKey, mapValue);
                }
            }
        }
        return value;
    }

    public VPackSlice serialize(Object entity) throws VPackParserException {
        return this.serialize(entity, new SerializeOptions().type(entity.getClass()));
    }

    @Deprecated
    public VPackSlice serialize(Object entity, Map<String, Object> additionalFields) throws VPackParserException {
        return this.serialize(entity, new SerializeOptions().type(entity.getClass()).additionalFields(additionalFields));
    }

    @Deprecated
    public VPackSlice serialize(Object entity, Type type) throws VPackParserException {
        return this.serialize(entity, new SerializeOptions().type(type));
    }

    @Deprecated
    public VPackSlice serialize(Object entity, Type type, Map<String, Object> additionalFields) throws VPackParserException {
        return this.serialize(entity, new SerializeOptions().type(type).additionalFields(additionalFields));
    }

    public VPackSlice serialize(Object entity, SerializeOptions options) throws VPackParserException {
        Class<?> type = options.getType();
        if (type == null) {
            type = entity.getClass();
        }
        if (type == VPackSlice.class) {
            return (VPackSlice)entity;
        }
        VPackBuilder builder = new VPackBuilder(this.builderOptions);
        this.serialize(null, entity, type, builder, new HashMap<String, Object>(options.getAdditionalFields()));
        return builder.slice();
    }

    private void serialize(String name, Object entity, Type type, VPackBuilder builder, Map<String, Object> additionalFields) throws VPackParserException {
        try {
            this.addValue(name, type, entity, builder, null, additionalFields);
        }
        catch (Exception e) {
            throw new VPackParserException(e);
        }
    }

    private void serializeObject(String name, Object entity, VPackBuilder builder, Map<String, Object> additionalFields) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, VPackException {
        Class<?> type = entity.getClass();
        VPackSerializer<?> serializer = this.getSerializer(type);
        if (serializer != null) {
            serializer.serialize(builder, name, entity, this.serializationContext);
        } else {
            builder.add(name, ValueType.OBJECT);
            this.serializeFields(entity, builder, additionalFields);
            builder.close(true);
        }
    }

    private void serializeFields(Object entity, VPackBuilder builder, Map<String, Object> additionalFields) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, VPackException {
        Map<String, VPackCache.FieldInfo> fields = this.cache.getFields(entity.getClass());
        for (VPackCache.FieldInfo fieldInfo : fields.values()) {
            if (!fieldInfo.isSerialize()) continue;
            this.serializeField(entity, builder, fieldInfo, Collections.<String, Object>emptyMap());
        }
        for (Map.Entry entry : additionalFields.entrySet()) {
            String key = (String)entry.getKey();
            if (fields.containsKey(key)) continue;
            Object value = entry.getValue();
            this.addValue(key, value != null ? value.getClass() : null, value, builder, null, Collections.<String, Object>emptyMap());
        }
    }

    private void serializeField(Object entity, VPackBuilder builder, VPackCache.FieldInfo fieldInfo, Map<String, Object> additionalFields) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, VPackException {
        String fieldName = fieldInfo.getFieldName();
        Type type = fieldInfo.getType();
        Object value = fieldInfo.get(entity);
        this.addValue(fieldName, type, value, builder, fieldInfo, additionalFields);
    }

    private void addValue(String name, Type type, Object value, VPackBuilder builder, VPackCache.FieldInfo fieldInfo, Map<String, Object> additionalFields) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, VPackException {
        if (value == null) {
            if (this.serializeNullValues) {
                builder.add(name, ValueType.NULL);
            }
        } else {
            VPackSerializer<?> serializer = this.getSerializer(type);
            if (serializer != null) {
                serializer.serialize(builder, name, value, this.serializationContext);
            } else if (type instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)ParameterizedType.class.cast(type);
                Type rawType = pType.getRawType();
                if (Iterable.class.isAssignableFrom((Class)rawType)) {
                    this.serializeIterable(name, value, builder, pType.getActualTypeArguments()[0]);
                } else if (Map.class.isAssignableFrom((Class)rawType)) {
                    this.serializeMap(name, value, builder, pType.getActualTypeArguments()[0], additionalFields);
                } else {
                    this.serializeObject(name, value, builder, additionalFields);
                }
            } else if (type instanceof Class && Iterable.class.isAssignableFrom((Class)type)) {
                this.serializeIterable(name, value, builder, null);
            } else if (type instanceof Class && Map.class.isAssignableFrom((Class)type)) {
                this.serializeMap(name, value, builder, (Type)((Object)String.class), additionalFields);
            } else if (type instanceof Class && ((Class)type).isArray()) {
                this.serializeArray(name, value, builder);
            } else if (type instanceof Class && ((Class)type).isEnum()) {
                builder.add(name, ((Enum)Enum.class.cast(value)).name());
            } else if (type != value.getClass()) {
                this.addValue(name, value.getClass(), value, builder, fieldInfo, Collections.singletonMap(this.typeKey, value.getClass().getName()));
            } else {
                this.serializeObject(name, value, builder, additionalFields);
            }
        }
    }

    private void serializeArray(String name, Object value, VPackBuilder builder) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, VPackException {
        builder.add(name, ValueType.ARRAY);
        for (int i = 0; i < Array.getLength(value); ++i) {
            Object element = Array.get(value, i);
            if (element != null) {
                this.addValue(null, element.getClass(), element, builder, null, Collections.<String, Object>emptyMap());
                continue;
            }
            builder.add(ValueType.NULL);
        }
        builder.close();
    }

    private void serializeIterable(String name, Object value, VPackBuilder builder, Type type) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, VPackException {
        builder.add(name, ValueType.ARRAY);
        for (Object element : (Iterable)Iterable.class.cast(value)) {
            Class<?> t = type != null ? type : (element != null ? element.getClass() : null);
            this.addValue(null, t, element, builder, null, Collections.<String, Object>emptyMap());
        }
        builder.close();
    }

    private void serializeMap(String name, Object value, VPackBuilder builder, Type keyType, Map<String, Object> additionalFields) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, VPackException {
        Map map = (Map)Map.class.cast(value);
        if (map.size() > 0) {
            VPackKeyMapAdapter<Object> keyMapAdapter = this.getKeyMapAdapter(keyType);
            if (keyMapAdapter != null) {
                builder.add(name, ValueType.OBJECT);
                Set entrySet = map.entrySet();
                for (Map.Entry entry : entrySet) {
                    Object entryValue = entry.getValue();
                    this.addValue(keyMapAdapter.serialize(entry.getKey()), entryValue != null ? entryValue.getClass() : Object.class, entry.getValue(), builder, null, Collections.<String, Object>emptyMap());
                }
                for (Map.Entry<Object, Object> entry : additionalFields.entrySet()) {
                    String key = (String)entry.getKey();
                    if (map.containsKey(key)) continue;
                    Object additionalValue = entry.getValue();
                    this.addValue(key, additionalValue != null ? additionalValue.getClass() : null, additionalValue, builder, null, Collections.<String, Object>emptyMap());
                }
                builder.close();
            } else {
                builder.add(name, ValueType.ARRAY);
                Set entrySet = map.entrySet();
                for (Map.Entry entry : entrySet) {
                    String s = null;
                    builder.add(s, ValueType.OBJECT);
                    this.addValue(ATTR_KEY, entry.getKey().getClass(), entry.getKey(), builder, null, Collections.<String, Object>emptyMap());
                    this.addValue(ATTR_VALUE, entry.getValue().getClass(), entry.getValue(), builder, null, Collections.<String, Object>emptyMap());
                    builder.close();
                }
                builder.close();
            }
        } else {
            builder.add(name, ValueType.OBJECT);
            builder.close();
        }
    }

    private VPackKeyMapAdapter<Object> getKeyMapAdapter(Type type) {
        VPackKeyMapAdapter<Object> adapter = this.keyMapAdapters.get(type);
        if (adapter == null && Enum.class.isAssignableFrom((Class)type)) {
            adapter = VPackKeyMapAdapters.createEnumAdapter(type);
        }
        return adapter;
    }

    private VPackSerializer<?> getSerializer(Type type) {
        VPackSerializer<?> serializer = this.serializers.get(type);
        if (serializer == null && type instanceof Class && ((Class)type).isMemberClass()) {
            serializer = this.enclosingSerializers.get(((Class)type).getEnclosingClass());
        }
        if (serializer == null && ParameterizedType.class.isAssignableFrom(type.getClass())) {
            serializer = this.getSerializer(((ParameterizedType)ParameterizedType.class.cast(type)).getRawType());
        }
        return serializer;
    }

    public static class SerializeOptions {
        private Type type = null;
        private Map<String, Object> additionalFields = Collections.emptyMap();

        public Type getType() {
            return this.type;
        }

        public SerializeOptions type(Type type) {
            this.type = type;
            return this;
        }

        public Map<String, Object> getAdditionalFields() {
            return this.additionalFields;
        }

        public SerializeOptions additionalFields(Map<String, Object> additionalFields) {
            this.additionalFields = additionalFields;
            return this;
        }
    }

    public static class Builder
    implements VPackSetupContext<Builder> {
        private final Map<Type, VPackSerializer<?>> serializers = new HashMap();
        private final Map<Type, VPackSerializer<?>> enclosingSerializers = new HashMap();
        private final Map<Type, VPackDeserializer<?>> deserializers = new HashMap();
        private final Map<Type, VPackDeserializer<?>> deserializersWithSelfNullHandle = new HashMap();
        private final Map<String, Map<Type, VPackDeserializer<?>>> deserializersByName = new HashMap();
        private final Map<String, Map<Type, VPackDeserializer<?>>> deserializersByNameWithSelfNullHandle = new HashMap();
        private final Map<Type, VPackInstanceCreator<?>> instanceCreators = new HashMap();
        private final VPackBuilder.BuilderOptions builderOptions = new DefaultVPackBuilderOptions();
        private boolean serializeNullValues = false;
        private VPackFieldNamingStrategy fieldNamingStrategy;
        private final Map<Class<? extends Annotation>, VPackAnnotationFieldFilter<? extends Annotation>> annotationFieldFilter = new HashMap<Class<? extends Annotation>, VPackAnnotationFieldFilter<? extends Annotation>>();
        private final Map<Class<? extends Annotation>, VPackAnnotationFieldNaming<? extends Annotation>> annotationFieldNaming = new HashMap<Class<? extends Annotation>, VPackAnnotationFieldNaming<? extends Annotation>>();
        private final Map<Type, VPackKeyMapAdapter<?>> keyMapAdapters = new HashMap();
        private String typeKey = null;

        public Builder() {
            this.instanceCreators.put((Type)((Object)Collection.class), VPackInstanceCreators.COLLECTION);
            this.instanceCreators.put((Type)((Object)List.class), VPackInstanceCreators.LIST);
            this.instanceCreators.put((Type)((Object)Set.class), VPackInstanceCreators.SET);
            this.instanceCreators.put((Type)((Object)Map.class), VPackInstanceCreators.MAP);
            this.serializers.put((Type)((Object)String.class), VPackSerializers.STRING);
            this.serializers.put((Type)((Object)Boolean.class), VPackSerializers.BOOLEAN);
            this.serializers.put(Boolean.TYPE, VPackSerializers.BOOLEAN);
            this.serializers.put((Type)((Object)Integer.class), VPackSerializers.INTEGER);
            this.serializers.put(Integer.TYPE, VPackSerializers.INTEGER);
            this.serializers.put((Type)((Object)Long.class), VPackSerializers.LONG);
            this.serializers.put(Long.TYPE, VPackSerializers.LONG);
            this.serializers.put((Type)((Object)Short.class), VPackSerializers.SHORT);
            this.serializers.put(Short.TYPE, VPackSerializers.SHORT);
            this.serializers.put((Type)((Object)Double.class), VPackSerializers.DOUBLE);
            this.serializers.put(Double.TYPE, VPackSerializers.DOUBLE);
            this.serializers.put((Type)((Object)Float.class), VPackSerializers.FLOAT);
            this.serializers.put(Float.TYPE, VPackSerializers.FLOAT);
            this.serializers.put((Type)((Object)BigInteger.class), VPackSerializers.BIG_INTEGER);
            this.serializers.put((Type)((Object)BigDecimal.class), VPackSerializers.BIG_DECIMAL);
            this.serializers.put((Type)((Object)Number.class), VPackSerializers.NUMBER);
            this.serializers.put((Type)((Object)Character.class), VPackSerializers.CHARACTER);
            this.serializers.put(Character.TYPE, VPackSerializers.CHARACTER);
            this.serializers.put((Type)((Object)java.util.Date.class), VPackSerializers.DATE);
            this.serializers.put((Type)((Object)Date.class), VPackSerializers.SQL_DATE);
            this.serializers.put((Type)((Object)Timestamp.class), VPackSerializers.SQL_TIMESTAMP);
            this.serializers.put((Type)((Object)VPackSlice.class), VPackSerializers.VPACK);
            this.serializers.put((Type)((Object)UUID.class), VPackSerializers.UUID);
            this.serializers.put(new byte[0].getClass(), VPackSerializers.BYTE_ARRAY);
            this.serializers.put((Type)((Object)Byte.class), VPackSerializers.BYTE);
            this.serializers.put(Byte.TYPE, VPackSerializers.BYTE);
            this.deserializers.put((Type)((Object)String.class), VPackDeserializers.STRING);
            this.deserializers.put((Type)((Object)Boolean.class), VPackDeserializers.BOOLEAN);
            this.deserializers.put(Boolean.TYPE, VPackDeserializers.BOOLEAN);
            this.deserializers.put((Type)((Object)Integer.class), VPackDeserializers.INTEGER);
            this.deserializers.put(Integer.TYPE, VPackDeserializers.INTEGER);
            this.deserializers.put((Type)((Object)Long.class), VPackDeserializers.LONG);
            this.deserializers.put(Long.TYPE, VPackDeserializers.LONG);
            this.deserializers.put((Type)((Object)Short.class), VPackDeserializers.SHORT);
            this.deserializers.put(Short.TYPE, VPackDeserializers.SHORT);
            this.deserializers.put((Type)((Object)Double.class), VPackDeserializers.DOUBLE);
            this.deserializers.put(Double.TYPE, VPackDeserializers.DOUBLE);
            this.deserializers.put((Type)((Object)Float.class), VPackDeserializers.FLOAT);
            this.deserializers.put(Float.TYPE, VPackDeserializers.FLOAT);
            this.deserializers.put((Type)((Object)BigInteger.class), VPackDeserializers.BIG_INTEGER);
            this.deserializers.put((Type)((Object)BigDecimal.class), VPackDeserializers.BIG_DECIMAL);
            this.deserializers.put((Type)((Object)Number.class), VPackDeserializers.NUMBER);
            this.deserializers.put((Type)((Object)Character.class), VPackDeserializers.CHARACTER);
            this.deserializers.put(Character.TYPE, VPackDeserializers.CHARACTER);
            this.deserializers.put((Type)((Object)java.util.Date.class), VPackDeserializers.DATE);
            this.deserializers.put((Type)((Object)Date.class), VPackDeserializers.SQL_DATE);
            this.deserializers.put((Type)((Object)Timestamp.class), VPackDeserializers.SQL_TIMESTAMP);
            this.deserializers.put((Type)((Object)VPackSlice.class), VPackDeserializers.VPACK);
            this.deserializers.put((Type)((Object)UUID.class), VPackDeserializers.UUID);
            this.deserializers.put(new byte[0].getClass(), VPackDeserializers.BYTE_ARRAY);
            this.deserializers.put((Type)((Object)Byte.class), VPackDeserializers.BYTE);
            this.deserializers.put(Byte.TYPE, VPackDeserializers.BYTE);
            this.annotationFieldFilter.put(Expose.class, (VPackAnnotationFieldFilter<? extends Annotation>)new VPackAnnotationFieldFilter<Expose>(){

                @Override
                public boolean serialize(Expose annotation) {
                    return annotation.serialize();
                }

                @Override
                public boolean deserialize(Expose annotation) {
                    return annotation.deserialize();
                }
            });
            this.annotationFieldNaming.put(SerializedName.class, (VPackAnnotationFieldNaming<? extends Annotation>)new VPackAnnotationFieldNaming<SerializedName>(){

                @Override
                public String name(SerializedName annotation) {
                    return annotation.value();
                }
            });
        }

        @Override
        public <T> Builder registerSerializer(Type type, VPackSerializer<T> serializer) {
            this.serializers.put(type, serializer);
            return this;
        }

        @Override
        public <T> Builder registerEnclosingSerializer(Type type, VPackSerializer<T> serializer) {
            this.enclosingSerializers.put(type, serializer);
            return this;
        }

        @Override
        public <T> Builder registerDeserializer(Type type, VPackDeserializer<T> deserializer) {
            return this.registerDeserializer(type, (VPackDeserializer)deserializer, false);
        }

        @Override
        public <T> Builder registerDeserializer(Type type, VPackDeserializer<T> deserializer, boolean includeNullValues) {
            if (includeNullValues) {
                this.deserializersWithSelfNullHandle.put(type, deserializer);
            }
            this.deserializers.put(type, deserializer);
            return this;
        }

        @Override
        public <T> Builder registerDeserializer(String fieldName, Type type, VPackDeserializer<T> deserializer) {
            return this.registerDeserializer(fieldName, type, (VPackDeserializer)deserializer, false);
        }

        @Override
        public <T> Builder registerDeserializer(String fieldName, Type type, VPackDeserializer<T> deserializer, boolean includeNullValues) {
            Map<Type, VPackDeserializer<?>> byName;
            if (includeNullValues) {
                byName = this.deserializersByNameWithSelfNullHandle.get(fieldName);
                if (byName == null) {
                    byName = new HashMap();
                    this.deserializersByNameWithSelfNullHandle.put(fieldName, byName);
                }
                byName.put(type, deserializer);
            }
            if ((byName = this.deserializersByName.get(fieldName)) == null) {
                byName = new HashMap();
                this.deserializersByName.put(fieldName, byName);
            }
            byName.put(type, deserializer);
            return this;
        }

        @Override
        public <T> Builder registerInstanceCreator(Type type, VPackInstanceCreator<T> creator) {
            this.instanceCreators.put(type, creator);
            return this;
        }

        @Override
        public Builder buildUnindexedArrays(boolean buildUnindexedArrays) {
            this.builderOptions.setBuildUnindexedArrays(buildUnindexedArrays);
            return this;
        }

        @Override
        public Builder buildUnindexedObjects(boolean buildUnindexedObjects) {
            this.builderOptions.setBuildUnindexedObjects(buildUnindexedObjects);
            return this;
        }

        @Override
        public Builder serializeNullValues(boolean serializeNullValues) {
            this.serializeNullValues = serializeNullValues;
            return this;
        }

        @Override
        public Builder fieldNamingStrategy(VPackFieldNamingStrategy fieldNamingStrategy) {
            this.fieldNamingStrategy = fieldNamingStrategy;
            return this;
        }

        @Override
        public <A extends Annotation> Builder annotationFieldFilter(Class<A> type, VPackAnnotationFieldFilter<A> fieldFilter) {
            this.annotationFieldFilter.put(type, fieldFilter);
            return this;
        }

        @Override
        public <A extends Annotation> Builder annotationFieldNaming(Class<A> type, VPackAnnotationFieldNaming<A> fieldNaming) {
            this.annotationFieldNaming.put(type, fieldNaming);
            return this;
        }

        @Override
        public Builder registerModule(VPackModule module) {
            module.setup(this);
            return this;
        }

        @Override
        public Builder registerModules(VPackModule ... modules) {
            for (VPackModule module : modules) {
                this.registerModule(module);
            }
            return this;
        }

        @Override
        public Builder registerKeyMapAdapter(Type type, VPackKeyMapAdapter<?> adapter) {
            this.keyMapAdapters.put(type, adapter);
            return this;
        }

        public Builder typeKey(String typeKey) {
            this.typeKey = typeKey;
            return this;
        }

        public synchronized VPack build() {
            return new VPack(new HashMap(this.serializers), new HashMap(this.enclosingSerializers), new HashMap(this.deserializers), new HashMap(this.deserializersWithSelfNullHandle), new HashMap(this.instanceCreators), this.builderOptions, this.serializeNullValues, this.fieldNamingStrategy, new HashMap(this.deserializersByName), new HashMap(this.deserializersByNameWithSelfNullHandle), new HashMap<Class<? extends Annotation>, VPackAnnotationFieldFilter<? extends Annotation>>(this.annotationFieldFilter), new HashMap<Class<? extends Annotation>, VPackAnnotationFieldNaming<? extends Annotation>>(this.annotationFieldNaming), this.keyMapAdapters, this.typeKey != null ? this.typeKey : VPack.DEFAULT_TYPE_KEY);
        }
    }
}

