/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.velocypack.internal;

import com.arangodb.velocypack.VPackAttributeTranslator;
import com.arangodb.velocypack.VPackBuilder;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.ValueType;
import com.arangodb.velocypack.exception.VPackException;
import java.util.HashMap;
import java.util.Map;

public class VPackAttributeTranslatorImpl
implements VPackAttributeTranslator {
    private static final String KEY = "_key";
    private static final String REV = "_rev";
    private static final String ID = "_id";
    private static final String FROM = "_from";
    private static final String TO = "_to";
    private static final byte KEY_ATTRIBUTE = 49;
    private static final byte REV_ATTRIBUTE = 50;
    private static final byte ID_ATTRIBUTE = 51;
    private static final byte FROM_ATTRIBUTE = 52;
    private static final byte TO_ATTRIBUTE = 53;
    private static final byte ATTRIBUTE_BASE = 48;
    private VPackBuilder builder = null;
    private final Map<String, VPackSlice> attributeToKey = new HashMap<String, VPackSlice>();
    private final Map<Integer, VPackSlice> keyToAttribute = new HashMap<Integer, VPackSlice>();

    public VPackAttributeTranslatorImpl() {
        try {
            this.add(KEY, 1);
            this.add(REV, 2);
            this.add(ID, 3);
            this.add(FROM, 4);
            this.add(TO, 5);
            this.seal();
        }
        catch (VPackException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void add(String attribute, int key) throws VPackException {
        if (this.builder == null) {
            this.builder = new VPackBuilder();
            this.builder.add(ValueType.OBJECT);
        }
        this.builder.add(attribute, key);
    }

    @Override
    public void seal() throws VPackException {
        if (this.builder == null) {
            return;
        }
        this.builder.close();
        VPackSlice slice = this.builder.slice();
        for (int i = 0; i < slice.getLength(); ++i) {
            VPackSlice key = slice.keyAt(i);
            VPackSlice value = slice.valueAt(i);
            this.attributeToKey.put(key.getAsString(), value);
            this.keyToAttribute.put(value.getAsInt(), key);
        }
    }

    @Override
    public VPackSlice translate(String attribute) {
        return this.attributeToKey.get(attribute);
    }

    @Override
    public VPackSlice translate(int key) {
        return this.keyToAttribute.get(key);
    }
}

