/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.velocypack.internal;

import com.arangodb.velocypack.VPackAnnotationFieldFilter;
import com.arangodb.velocypack.VPackAnnotationFieldNaming;
import com.arangodb.velocypack.VPackFieldNamingStrategy;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VPackCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(VPackCache.class);
    private final Map<Type, Map<String, FieldInfo>> cache = new ConcurrentHashMap<Type, Map<String, FieldInfo>>();
    private final Comparator<Map.Entry<String, FieldInfo>> fieldComparator = new Comparator<Map.Entry<String, FieldInfo>>(){

        @Override
        public int compare(Map.Entry<String, FieldInfo> o1, Map.Entry<String, FieldInfo> o2) {
            return o1.getKey().compareTo(o2.getKey());
        }
    };
    private final VPackFieldNamingStrategy fieldNamingStrategy;
    private final Map<Class<? extends Annotation>, VPackAnnotationFieldFilter<? extends Annotation>> annotationFilter;
    private final Map<Class<? extends Annotation>, VPackAnnotationFieldNaming<? extends Annotation>> annotationFieldNaming;

    public VPackCache(VPackFieldNamingStrategy fieldNamingStrategy, Map<Class<? extends Annotation>, VPackAnnotationFieldFilter<? extends Annotation>> annotationFieldFilter, Map<Class<? extends Annotation>, VPackAnnotationFieldNaming<? extends Annotation>> annotationFieldNaming) {
        this.fieldNamingStrategy = fieldNamingStrategy;
        this.annotationFilter = annotationFieldFilter;
        this.annotationFieldNaming = annotationFieldNaming;
    }

    public Map<String, FieldInfo> getFields(Type entityClass) {
        Map<String, FieldInfo> fields = this.cache.get(entityClass);
        if (fields == null) {
            fields = new HashMap<String, FieldInfo>();
            for (Class tmp = (Class)entityClass; tmp != null && tmp != Object.class; tmp = tmp.getSuperclass()) {
                Field[] declaredFields;
                for (Field field : declaredFields = tmp.getDeclaredFields()) {
                    if (field.isSynthetic() || Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
                    field.setAccessible(true);
                    FieldInfo fieldInfo = this.createFieldInfo(field);
                    if (!fieldInfo.serialize && !fieldInfo.deserialize) continue;
                    fields.put(fieldInfo.getFieldName(), fieldInfo);
                }
            }
            fields = this.sort(fields.entrySet());
            this.cache.put(entityClass, fields);
        }
        return fields;
    }

    private Map<String, FieldInfo> sort(Set<Map.Entry<String, FieldInfo>> entrySet) {
        LinkedHashMap<String, FieldInfo> sorted = new LinkedHashMap<String, FieldInfo>();
        ArrayList<Map.Entry<String, FieldInfo>> tmp = new ArrayList<Map.Entry<String, FieldInfo>>(entrySet);
        Collections.sort(tmp, this.fieldComparator);
        for (Map.Entry entry : tmp) {
            sorted.put((String)entry.getKey(), (FieldInfo)entry.getValue());
        }
        return sorted;
    }

    private FieldInfo createFieldInfo(final Field field) {
        String fieldName = field.getName();
        if (this.fieldNamingStrategy != null) {
            fieldName = this.fieldNamingStrategy.translateName(field);
        }
        boolean found = false;
        for (Map.Entry<Class<? extends Annotation>, VPackAnnotationFieldNaming<? extends Annotation>> entry : this.annotationFieldNaming.entrySet()) {
            Annotation annotation = field.getAnnotation(entry.getKey());
            if (annotation == null) continue;
            fieldName = entry.getValue().name(annotation);
            if (found) {
                LOGGER.warn(String.format("Found additional annotation %s for field %s. Override previous annotation informations.", entry.getKey().getSimpleName(), field.getName()));
            }
            found = true;
        }
        boolean serialize = true;
        boolean deserialize = true;
        found = false;
        for (Map.Entry entry : this.annotationFilter.entrySet()) {
            Object annotation = field.getAnnotation((Class)entry.getKey());
            if (annotation == null) continue;
            VPackAnnotationFieldFilter filter = (VPackAnnotationFieldFilter)entry.getValue();
            serialize = filter.serialize(annotation);
            deserialize = filter.deserialize(annotation);
            if (found) {
                LOGGER.warn(String.format("Found additional annotation %s for field %s. Override previous annotation informations.", ((Class)entry.getKey()).getSimpleName(), field.getName()));
            }
            found = true;
        }
        Class<?> clazz = field.getType();
        Object object = clazz == Object.class ? Object.class : field.getGenericType();
        return new FieldInfo((Type)object, fieldName, serialize, deserialize){

            @Override
            public void set(Object obj, Object value) throws IllegalAccessException {
                field.set(obj, value);
            }

            @Override
            public Object get(Object obj) throws IllegalAccessException {
                return field.get(obj);
            }
        };
    }

    public static abstract class FieldInfo {
        private final Type type;
        private final String fieldName;
        private final boolean serialize;
        private final boolean deserialize;

        private FieldInfo(Type type, String fieldName, boolean serialize, boolean deserialize) {
            this.type = type;
            this.fieldName = fieldName;
            this.serialize = serialize;
            this.deserialize = deserialize;
        }

        public Type getType() {
            return this.type;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public boolean isSerialize() {
            return this.serialize;
        }

        public boolean isDeserialize() {
            return this.deserialize;
        }

        public abstract void set(Object var1, Object var2) throws IllegalAccessException;

        public abstract Object get(Object var1) throws IllegalAccessException;
    }
}

