/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.velocypack.internal;

import com.arangodb.velocypack.annotations.VPackCreator;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class VPackCreatorMethodUtils {
    private final Map<Type, VPackCreatorMethodInfo> cache = new ConcurrentHashMap<Type, VPackCreatorMethodInfo>();

    public VPackCreatorMethodInfo getCreatorMethodInfo(Type type) {
        if (!(type instanceof Class)) {
            return null;
        }
        VPackCreatorMethodInfo fromCache = this.cache.get(type);
        if (fromCache != null) {
            return fromCache;
        }
        Class clazz = (Class)type;
        for (Method method : clazz.getDeclaredMethods()) {
            for (Annotation annotation : method.getDeclaredAnnotations()) {
                if (!(annotation instanceof VPackCreator)) continue;
                FactoryMethodInfo info = new FactoryMethodInfo(method);
                this.cache.put(type, info);
                return info;
            }
        }
        for (Executable executable : clazz.getDeclaredConstructors()) {
            for (Annotation annotation : ((Constructor)executable).getDeclaredAnnotations()) {
                if (!(annotation instanceof VPackCreator)) continue;
                AllArgsConstructorInfo info = new AllArgsConstructorInfo((Constructor)executable);
                this.cache.put(type, info);
                return info;
            }
        }
        return null;
    }

    private class AllArgsConstructorInfo
    implements VPackCreatorMethodInfo {
        private final Constructor constructor;

        public AllArgsConstructorInfo(Constructor constructor) {
            this.constructor = constructor;
        }

        @Override
        public Executable getExecutable() {
            return this.constructor;
        }

        @Override
        public Object create(Object ... args) throws ReflectiveOperationException {
            return this.constructor.newInstance(args);
        }
    }

    private class FactoryMethodInfo
    implements VPackCreatorMethodInfo {
        private final Method factoryMethod;

        public FactoryMethodInfo(Method factoryMethod) {
            this.factoryMethod = factoryMethod;
        }

        @Override
        public Executable getExecutable() {
            return this.factoryMethod;
        }

        @Override
        public Object create(Object ... args) throws ReflectiveOperationException {
            return this.factoryMethod.invoke(null, args);
        }
    }

    public static interface VPackCreatorMethodInfo {
        public Executable getExecutable();

        public Object create(Object ... var1) throws ReflectiveOperationException;
    }

    public static class ParameterInfo {
        public final AnnotatedElement referencingElement;
        public final Type type;
        public final String name;

        public ParameterInfo(AnnotatedElement referencingElement, Type type, String name) {
            this.referencingElement = referencingElement;
            this.type = type;
            this.name = name;
        }
    }
}

