/*
 * DISCLAIMER
 *
 * Copyright 2016 ArangoDB GmbH, Cologne, Germany
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Copyright holder is ArangoDB GmbH, Cologne, Germany
 */

package com.arangodb.velocypack.internal.util;

/**
 * @author Mark Vollmary
 *
 */
public class ValueLengthUtil {

	private static final int DOUBLE_BYTES = 8;
	private static final int LONG_BYTES = 8;
	private static final int CHARACTER_BYTES = 2;

	private static final int[] MAP = {
		1, // 0x00
		1, // 0x01
		0, // 0x02
		0, // 0x03
		0, // 0x04
		0, // 0x05
		0, // 0x06
		0, // 0x07
		0, // 0x08
		0, // 0x09
		1, // 0x0a
		0, // 0x0b
		0, // 0x0c
		0, // 0x0d
		0, // 0x0e
		0, // 0x0f
		0, // 0x10
		0, // 0x11
		0, // 0x12
		0, // 0x13
		0, // 0x14
		0, // 0x15
		0, // 0x16
		1, // 0x17
		1, // 0x18
		1, // 0x19
		1, // 0x1a
		1 + DOUBLE_BYTES, // 0x1b
		1 + LONG_BYTES, // 0x1c
		1 + CHARACTER_BYTES, // 0x1d
		1, // 0x1e
		1, // 0x1f
		2, // 0x20
		3, // 0x21
		4, // 0x22
		5, // 0x23
		6, // 0x24
		7, // 0x25
		8, // 0x26
		9, // 0x27
		2, // 0x28
		3, // 0x29
		4, // 0x2a
		5, // 0x2b
		6, // 0x2c
		7, // 0x2d
		8, // 0x2e
		9, // 0x2f
		1, // 0x30
		1, // 0x31
		1, // 0x32
		1, // 0x33
		1, // 0x34
		1, // 0x35
		1, // 0x36
		1, // 0x37
		1, // 0x38
		1, // 0x39
		1, // 0x3a
		1, // 0x3b
		1, // 0x3c
		1, // 0x3d
		1, // 0x3e
		1, // 0x3f
		1, // 0x40
		2, // 0x41
		3, // 0x42
		4, // 0x43
		5, // 0x44
		6, // 0x45
		7, // 0x46
		8, // 0x47
		9, // 0x48
		10, // 0x49
		11, // 0x4a
		12, // 0x4b
		13, // 0x4c
		14, // 0x4d
		15, // 0x4e
		16, // 0x4f
		17, // 0x50
		18, // 0x51
		19, // 0x52
		20, // 0x53
		21, // 0x54
		22, // 0x55
		23, // 0x56
		24, // 0x57
		25, // 0x58
		26, // 0x59
		27, // 0x5a
		28, // 0x5b
		29, // 0x5c
		30, // 0x5d
		31, // 0x5e
		32, // 0x5f
		33, // 0x60
		34, // 0x61
		35, // 0x62
		36, // 0x63
		37, // 0x64
		38, // 0x65
		39, // 0x66
		40, // 0x67
		41, // 0x68
		42, // 0x69
		43, // 0x6a
		44, // 0x6b
		45, // 0x6c
		46, // 0x6d
		47, // 0x6e
		48, // 0x6f
		49, // 0x70
		50, // 0x71
		51, // 0x72
		52, // 0x73
		53, // 0x74
		54, // 0x75
		55, // 0x76
		56, // 0x77
		57, // 0x78
		58, // 0x79
		59, // 0x7a
		60, // 0x7b
		61, // 0x7c
		62, // 0x7d
		63, // 0x7e
		64, // 0x7f
		65, // 0x80
		66, // 0x81
		67, // 0x82
		68, // 0x83
		69, // 0x84
		70, // 0x85
		71, // 0x86
		72, // 0x87
		73, // 0x88
		74, // 0x89
		75, // 0x8a
		76, // 0x8b
		77, // 0x8c
		78, // 0x8d
		79, // 0x8e
		80, // 0x8f
		81, // 0x90
		82, // 0x91
		83, // 0x92
		84, // 0x93
		85, // 0x94
		86, // 0x95
		87, // 0x96
		88, // 0x97
		89, // 0x98
		90, // 0x99
		91, // 0x9a
		92, // 0x9b
		93, // 0x9c
		94, // 0x9d
		95, // 0x9e
		96, // 0x9f
		97, // 0xa0
		98, // 0xa1
		99, // 0xa2
		100, // 0xa3
		101, // 0xa4
		102, // 0xa5
		103, // 0xa6
		104, // 0xa7
		105, // 0xa8
		106, // 0xa9
		107, // 0xaa
		108, // 0xab
		109, // 0xac
		110, // 0xad
		111, // 0xae
		112, // 0xaf
		113, // 0xb0
		114, // 0xb1
		115, // 0xb2
		116, // 0xb3
		117, // 0xb4
		118, // 0xb5
		119, // 0xb6
		120, // 0xb7
		121, // 0xb8
		122, // 0xb9
		123, // 0xba
		124, // 0xbb
		125, // 0xbc
		126, // 0xbd
		127, // 0xbe
		0, // 0xbf
		0, // 0xc0
		0, // 0xc1
		0, // 0xc2
		0, // 0xc3
		0, // 0xc4
		0, // 0xc5
		0, // 0xc6
		0, // 0xc7
		0, // 0xc8
		0, // 0xc9
		0, // 0xca
		0, // 0xcb
		0, // 0xcc
		0, // 0xcd
		0, // 0xce
		0, // 0xcf
		0, // 0xd0
		0, // 0xd1
		0, // 0xd2
		0, // 0xd3
		0, // 0xd4
		0, // 0xd5
		0, // 0xd6
		0, // 0xd7
		0, // 0xd8
		0, // 0xd9
		0, // 0xda
		0, // 0xdb
		0, // 0xdc
		0, // 0xdd
		0, // 0xde
		0, // 0xdf
		0, // 0xe0
		0, // 0xe1
		0, // 0xe2
		0, // 0xe3
		0, // 0xe4
		0, // 0xe5
		0, // 0xe6
		0, // 0xe7
		0, // 0xe8
		0, // 0xe9
		0, // 0xea
		0, // 0xeb
		0, // 0xec
		0, // 0xed
		0, // 0xee
		0, // 0xef
		2, // 0xf0
		3, // 0xf1
		5, // 0xf2
		9, // 0xf3
		0, // 0xf4
		0, // 0xf5
		0, // 0xf6
		0, // 0xf7
		0, // 0xf8
		0, // 0xf9
		0, // 0xfa
		0, // 0xfb
		0, // 0xfc
		0, // 0xfd
		0, // 0xfe
		0, // 0xff
	};

	private ValueLengthUtil() {
		super();
	}

	public static int get(final byte key) {
		return MAP[key & 0xff];
	}

}
