/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.velocypack;

import com.arangodb.velocypack.SliceIterator;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.ValueType;
import com.arangodb.velocypack.exception.VPackValueTypeException;
import java.util.NoSuchElementException;

public class ArrayIterator
extends SliceIterator<VPackSlice> {
    public ArrayIterator(VPackSlice slice) throws VPackValueTypeException {
        super(slice);
        if (!slice.isArray()) {
            throw new VPackValueTypeException(ValueType.ARRAY);
        }
        if (this.size > 0L) {
            this.current = slice.getNth(0).getStart();
        }
    }

    @Override
    public VPackSlice next() {
        if (this.hasNext()) {
            VPackSlice next = this.getCurrent();
            ++this.position;
            this.current += (long)next.getByteSize();
            return next;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

