/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider;

import com.arcadeanalytics.provider.DataSourceGraphDataProvider;
import com.arcadeanalytics.provider.DataSourceGraphProvider;
import com.arcadeanalytics.provider.DataSourceInfo;
import com.arcadeanalytics.provider.DataSourceMetadataProvider;
import com.arcadeanalytics.provider.DataSourceProvider;
import com.arcadeanalytics.provider.DataSourceTableDataProvider;
import com.arcadeanalytics.provider.SshDataProviderDecorator;
import com.arcadeanalytics.provider.SshGraphProviderDecorator;
import com.arcadeanalytics.provider.SshMetadataProviderDecorator;
import com.arcadeanalytics.provider.SshTableDataProviderDecorator;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0014J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/arcadeanalytics/provider/DataSourceProviderFactory;", "T", "Lcom/arcadeanalytics/provider/DataSourceProvider;", "", "clazz", "Ljava/lang/Class;", "pluginPath", "", "(Ljava/lang/Class;Ljava/lang/String;)V", "dataProviders", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "create", "dataSourceInfo", "Lcom/arcadeanalytics/provider/DataSourceInfo;", "(Lcom/arcadeanalytics/provider/DataSourceInfo;)Lcom/arcadeanalytics/provider/DataSourceProvider;", "decorate", "provider", "(Lcom/arcadeanalytics/provider/DataSourceProvider;)Lcom/arcadeanalytics/provider/DataSourceProvider;", "provides", "", "arcade-connectors-base"})
public final class DataSourceProviderFactory<T extends DataSourceProvider> {
    private final Logger log;
    private final Map<String, T> dataProviders;
    private final Class<T> clazz;

    @NotNull
    public final T create(@NotNull DataSourceInfo dataSourceInfo) {
        Intrinsics.checkParameterIsNotNull((Object)dataSourceInfo, (String)"dataSourceInfo");
        if (!this.dataProviders.containsKey(dataSourceInfo.getType())) {
            throw (Throwable)new RuntimeException("data source type not supported " + dataSourceInfo.getType());
        }
        T t = this.dataProviders.get(dataSourceInfo.getType());
        if (t == null) {
            Intrinsics.throwNpe();
        }
        DataSourceProvider provider = (DataSourceProvider)t;
        return (T)(dataSourceInfo.getRemote() ? this.decorate(provider) : provider);
    }

    @NotNull
    public final Set<String> provides() {
        return this.dataProviders.keySet();
    }

    private final T decorate(T provider) {
        DataSourceProvider dataSourceProvider;
        Class<?> clazz = provider.getClass();
        if (clazz instanceof DataSourceMetadataProvider) {
            T t = provider;
            if (t == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.arcadeanalytics.provider.DataSourceMetadataProvider");
            }
            dataSourceProvider = new SshMetadataProviderDecorator((DataSourceMetadataProvider)t);
        } else if (clazz instanceof DataSourceGraphDataProvider) {
            T t = provider;
            if (t == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.arcadeanalytics.provider.DataSourceGraphDataProvider");
            }
            dataSourceProvider = new SshDataProviderDecorator((DataSourceGraphDataProvider)t);
        } else if (clazz instanceof DataSourceGraphProvider) {
            T t = provider;
            if (t == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.arcadeanalytics.provider.DataSourceGraphProvider");
            }
            dataSourceProvider = new SshGraphProviderDecorator((DataSourceGraphProvider)t);
        } else if (clazz instanceof DataSourceTableDataProvider) {
            T t = provider;
            if (t == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.arcadeanalytics.provider.DataSourceTableDataProvider");
            }
            dataSourceProvider = new SshTableDataProviderDecorator((DataSourceTableDataProvider)t);
        } else {
            dataSourceProvider = provider;
        }
        return (T)dataSourceProvider;
    }

    /*
     * WARNING - void declaration
     */
    public DataSourceProviderFactory(@NotNull Class<T> clazz, @NotNull String pluginPath) {
        Map map;
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull((Object)pluginPath, (String)"pluginPath");
        this.clazz = clazz;
        this.log = LoggerFactory.getLogger(this.getClass());
        DataSourceProviderFactory dataSourceProviderFactory = this;
        boolean bl = false;
        dataSourceProviderFactory.dataProviders = map = (Map)new LinkedHashMap();
        this.log.info("services for:: {}", (Object)this.clazz.getSimpleName());
        Stream<Path> stream = Files.walk(Paths.get(pluginPath, new String[0]), new FileVisitOption[0]);
        Intrinsics.checkExpressionValueIsNotNull(stream, (String)"Files.walk(Paths.get(pluginPath))");
        Sequence $this$forEach$iv = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)StreamsKt.asSequence(stream), (Function1)1.INSTANCE), (Function1)new Function1<Path, ServiceLoader<T>>(){

            public final ServiceLoader<T> invoke(Path path) {
                log.info("scanning:: " + path.toUri().toURL());
                URLClassLoader urlClassLoader = URLClassLoader.newInstance(new URL[]{path.toUri().toURL()}, this.getClass().getClassLoader());
                return ServiceLoader.load(clazz, urlClassLoader);
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$onEach$iv;
            Object list$iv$iv;
            Iterable $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            Map map2;
            Map it;
            Collection<Map> collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            ServiceLoader loader = (ServiceLoader)element$iv;
            boolean bl2 = false;
            ServiceLoader serviceLoader = loader;
            Intrinsics.checkExpressionValueIsNotNull((Object)serviceLoader, (String)"loader");
            Iterable iterable = serviceLoader;
            Map<String, T> map3 = this.dataProviders;
            boolean $i$f$map = false;
            void var12_15 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$associateTo$iv$iv;
                DataSourceProvider dataSourceProvider = (DataSourceProvider)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                Iterable $this$associate$iv = it.supportedDataSourceTypes();
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                Iterable iterable2 = $this$associate$iv;
                Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map map4 = destination$iv$iv2;
                    String k = (String)element$iv$iv;
                    boolean bl4 = false;
                    Pair pair = TuplesKt.to((Object)k, (Object)it);
                    boolean bl5 = false;
                    map4.put(pair.getFirst(), pair.getSecond());
                }
                map2 = destination$iv$iv2;
                collection.add(map2);
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = collection;
            boolean $i$f$flatMap = false;
            $this$mapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (Map)element$iv$iv;
                boolean bl6 = false;
                list$iv$iv = it.entrySet();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            collection = (List)destination$iv$iv;
            $this$flatMap$iv = collection;
            $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                list$iv$iv = (Map.Entry)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl7 = false;
                map2 = TuplesKt.to(it.getKey(), it.getValue());
                collection.add(map2);
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = collection;
            boolean $i$f$onEach = false;
            var12_15 = $this$onEach$iv;
            boolean bl8 = false;
            boolean bl9 = false;
            void $this$apply$iv = var12_15;
            boolean bl10 = false;
            for (Object element$iv2 : $this$apply$iv) {
                Pair it2 = (Pair)element$iv2;
                boolean bl11 = false;
                this.log.info("found::  {} ", it2.getFirst());
            }
            collection = var12_15;
            map3.putAll(MapsKt.toMap(collection));
        }
    }

    public /* synthetic */ DataSourceProviderFactory(Class clazz, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "./plugins";
        }
        this(clazz, string);
    }
}

