/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider;

import com.arcadeanalytics.connectors.base.com.jcraft.jsch.JSch;
import com.arcadeanalytics.connectors.base.com.jcraft.jsch.JSchException;
import com.arcadeanalytics.connectors.base.com.jcraft.jsch.Session;
import com.arcadeanalytics.provider.DataSourceInfo;
import com.arcadeanalytics.provider.DataSourceProvider;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0004J\u0018\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0002J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/arcadeanalytics/provider/SshTunnelTemplate;", "Lcom/arcadeanalytics/provider/DataSourceProvider;", "()V", "buildTunnel", "Lkotlin/Pair;", "Lcom/arcadeanalytics/connectors/base/com/jcraft/jsch/Session;", "Lcom/arcadeanalytics/provider/DataSourceInfo;", "dataSourceInfo", "createLocalhostDataSource", "localPort", "", "findFreePort", "supportedDataSourceTypes", "", "", "Companion", "JschSlf4jLogger", "arcade-connectors-base"})
public abstract class SshTunnelTemplate
implements DataSourceProvider {
    private static final Logger log;
    private static final String DEFAULT_SSH_USER = "player";
    private static final int DEFAULT_SSH_PORT = 22;
    public static final Companion Companion;

    @NotNull
    protected final Pair<Session, DataSourceInfo> buildTunnel(@NotNull DataSourceInfo dataSourceInfo) {
        Intrinsics.checkParameterIsNotNull((Object)dataSourceInfo, (String)"dataSourceInfo");
        JSch.setLogger(new JschSlf4jLogger());
        JSch jsch = new JSch();
        int localPort = this.findFreePort();
        try {
            String privKeyFileName = System.getProperty("SSH_PRIV_KEY", ".ssh/id_rsa");
            String pubKeyFileName = System.getProperty("SSH_PUB_KEY", ".ssh/id_rsa.pub");
            byte[] privKey = Files.readAllBytes(Paths.get(privKeyFileName, new String[0]));
            byte[] pubKey = Files.readAllBytes(Paths.get(pubKeyFileName, new String[0]));
            String sshUser = Optional.ofNullable(dataSourceInfo.getSshUser()).orElse(DEFAULT_SSH_USER);
            jsch.addIdentity(sshUser, privKey, pubKey, null);
            Session session = jsch.getSession(dataSourceInfo.getSshUser(), dataSourceInfo.getGateway(), dataSourceInfo.getSshPort());
            session.setConfig("StrictHostKeyChecking", "no");
            session.connect();
            session.setPortForwardingL(localPort, dataSourceInfo.getServer(), dataSourceInfo.getPort());
            DataSourceInfo wrapper = this.createLocalhostDataSource(dataSourceInfo, localPort);
            return new Pair((Object)session, (Object)wrapper);
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException(e);
        }
        catch (JSchException e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final int findFreePort() {
        ServerSocket socket = null;
        socket = new ServerSocket(0);
        socket.setReuseAddress(true);
        int port = socket.getLocalPort();
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int n = port;
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return n;
        catch (IOException iOException) {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException2) {}
            }
            catch (Throwable throwable) {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException3) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        throw (Throwable)new IllegalStateException("Could not find a free TCP/IP port to open the ssh tunnel");
    }

    private final DataSourceInfo createLocalhostDataSource(DataSourceInfo dataSourceInfo, int localPort) {
        return new DataSourceInfo(dataSourceInfo.getId(), dataSourceInfo.getType(), dataSourceInfo.getName(), dataSourceInfo.getDescription(), "localhost", localPort, dataSourceInfo.getDatabase(), dataSourceInfo.getUsername(), dataSourceInfo.getPassword(), dataSourceInfo.getAggregationEnabled(), dataSourceInfo.getConnectionProperties(), false, "localhost", localPort, "");
    }

    @Override
    @NotNull
    public Set<String> supportedDataSourceTypes() {
        HashSet hashSet = Sets.newHashSet((Object[])new String[]{"SSH"});
        Intrinsics.checkExpressionValueIsNotNull((Object)hashSet, (String)"Sets.newHashSet(\"SSH\")");
        return hashSet;
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(SshTunnelTemplate.class);
        DEFAULT_SSH_USER = DEFAULT_SSH_USER;
        DEFAULT_SSH_PORT = 22;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\tH\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/arcadeanalytics/provider/SshTunnelTemplate$JschSlf4jLogger;", "Lcom/arcadeanalytics/connectors/base/com/jcraft/jsch/Logger;", "()V", "enabledMap", "Ljava/util/HashMap;", "", "Ljava/util/function/BooleanSupplier;", "logMap", "Ljava/util/function/Consumer;", "", "isEnabled", "", "level", "log", "", "message", "arcade-connectors-base"})
    public static final class JschSlf4jLogger
    implements com.arcadeanalytics.connectors.base.com.jcraft.jsch.Logger {
        private final HashMap<Integer, Consumer<String>> logMap = new HashMap();
        private final HashMap<Integer, BooleanSupplier> enabledMap = new HashMap();

        @Override
        public void log(int level, @NotNull String message) {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                Consumer<String> consumer = this.logMap.get(level);
                if (consumer == null) break block0;
                consumer.accept(message);
            }
        }

        @Override
        public boolean isEnabled(int level) {
            BooleanSupplier booleanSupplier = this.enabledMap.get(level);
            if (booleanSupplier == null) {
                Intrinsics.throwNpe();
            }
            return booleanSupplier.getAsBoolean();
        }

        public JschSlf4jLogger() {
            ((Map)this.logMap).put(0, 1.INSTANCE);
            ((Map)this.logMap).put(3, 2.INSTANCE);
            ((Map)this.logMap).put(4, 3.INSTANCE);
            ((Map)this.logMap).put(1, 4.INSTANCE);
            ((Map)this.logMap).put(2, 5.INSTANCE);
            ((Map)this.enabledMap).put(0, 6.INSTANCE);
            ((Map)this.enabledMap).put(3, 7.INSTANCE);
            ((Map)this.enabledMap).put(4, 8.INSTANCE);
            ((Map)this.enabledMap).put(1, 9.INSTANCE);
            ((Map)this.enabledMap).put(2, 10.INSTANCE);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/arcadeanalytics/provider/SshTunnelTemplate$Companion;", "", "()V", "DEFAULT_SSH_PORT", "", "DEFAULT_SSH_USER", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "arcade-connectors-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

