/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.connectors.base.me.alexpanov.net;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;

public final class FreePortFinder {
    public static final int MIN_PORT_NUMBER = 1100;
    public static final int MAX_PORT_NUMBER = 65535;
    private static final ServerSocket LOCK;
    private static AtomicInteger currentMinPort;

    private FreePortFinder() {
    }

    public static synchronized int findFreeLocalPort() {
        return FreePortFinder.findFreeLocalPort(null);
    }

    public static synchronized int findFreeLocalPort(InetAddress bindAddress) {
        int next = FreePortFinder.findFreeLocalPort(currentMinPort.get(), bindAddress);
        currentMinPort.set(next + 1);
        return next;
    }

    public static synchronized int findFreeLocalPort(int fromPort) {
        return FreePortFinder.findFreeLocalPort(fromPort, null);
    }

    public static synchronized int findFreeLocalPort(int fromPort, InetAddress bindAddress) {
        if (fromPort < currentMinPort.get() || fromPort > 65535) {
            throw new IllegalArgumentException("From port number not in valid range: " + fromPort);
        }
        for (int i = fromPort; i <= 65535; ++i) {
            if (!FreePortFinder.available(i, bindAddress)) continue;
            return i;
        }
        throw new NoSuchElementException("Could not find an available port above " + fromPort);
    }

    public static synchronized int findFreeLocalPortOnAddresses(InetAddress ... bindAddresses) {
        int fromPort = currentMinPort.get();
        if (fromPort < currentMinPort.get() || fromPort > 65535) {
            throw new IllegalArgumentException("From port number not in valid range: " + fromPort);
        }
        if (bindAddresses != null) {
            for (int j = fromPort; j <= 65535; ++j) {
                for (int i = 0; i < bindAddresses.length; ++i) {
                    if (!FreePortFinder.available(j, bindAddresses[i])) continue;
                    currentMinPort.set(j + 1);
                    return j;
                }
            }
        }
        throw new NoSuchElementException("Could not find an available port above " + fromPort);
    }

    public static boolean available(int port) throws IllegalArgumentException {
        return FreePortFinder.available(port, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean available(int port, InetAddress bindAddress) throws IllegalArgumentException {
        if (port < currentMinPort.get() || port > 65535) {
            throw new IllegalArgumentException("Invalid start currentMinPort: " + port);
        }
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = bindAddress != null ? new ServerSocket(port, 50, bindAddress) : new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = bindAddress != null ? new DatagramSocket(port, bindAddress) : new DatagramSocket(port);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    static {
        currentMinPort = new AtomicInteger(1100);
        int port = 1100;
        ServerSocket ss = null;
        while (ss == null) {
            try {
                ss = new ServerSocket(port);
            }
            catch (Exception e) {
                ss = null;
                port += 200;
            }
        }
        LOCK = ss;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    LOCK.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        currentMinPort.set(port + 1);
    }
}

