/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.connectors.base.com.jcraft.jsch.jce;

import com.arcadeanalytics.connectors.base.com.jcraft.jsch.Buffer;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;

public class SignatureRSA
implements com.arcadeanalytics.connectors.base.com.jcraft.jsch.SignatureRSA {
    Signature signature;
    KeyFactory keyFactory;

    public void init() throws Exception {
        this.signature = Signature.getInstance("SHA1withRSA");
        this.keyFactory = KeyFactory.getInstance("RSA");
    }

    public void setPubKey(byte[] e, byte[] n) throws Exception {
        RSAPublicKeySpec rsaPubKeySpec = new RSAPublicKeySpec(new BigInteger(n), new BigInteger(e));
        PublicKey pubKey = this.keyFactory.generatePublic(rsaPubKeySpec);
        this.signature.initVerify(pubKey);
    }

    public void setPrvKey(byte[] d, byte[] n) throws Exception {
        RSAPrivateKeySpec rsaPrivKeySpec = new RSAPrivateKeySpec(new BigInteger(n), new BigInteger(d));
        PrivateKey prvKey = this.keyFactory.generatePrivate(rsaPrivKeySpec);
        this.signature.initSign(prvKey);
    }

    public byte[] sign() throws Exception {
        byte[] sig = this.signature.sign();
        return sig;
    }

    public void update(byte[] foo) throws Exception {
        this.signature.update(foo);
    }

    public boolean verify(byte[] sig) throws Exception {
        int i = 0;
        int j = 0;
        Buffer buf = new Buffer(sig);
        if (new String(buf.getString()).equals("ssh-rsa")) {
            j = buf.getInt();
            i = buf.getOffSet();
            byte[] tmp = new byte[j];
            System.arraycopy(sig, i, tmp, 0, j);
            sig = tmp;
        }
        return this.signature.verify(sig);
    }
}

