/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.gremlin;

import com.arcadeanalytics.provider.CytoData;
import com.arcadeanalytics.provider.Data;
import com.arcadeanalytics.provider.DataSourceGraphDataProvider;
import com.arcadeanalytics.provider.DataSourceInfo;
import com.arcadeanalytics.provider.GraphData;
import com.arcadeanalytics.provider.Position;
import com.arcadeanalytics.provider.TypeMapperKt;
import com.arcadeanalytics.provider.gremlin.GremlinDataProvider;
import com.arcadeanalytics.provider.gremlin.GremlinUtilKt;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.apache.tinkerpop.gremlin.driver.ResultSet;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J?\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH\u0016\u00a2\u0006\u0002\u0010\u0011J;\u0010\u0012\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J \u0010\u0019\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0017H\u0016J(\u0010\u001c\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J#\u0010\u001f\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH\u0016\u00a2\u0006\u0002\u0010!J+\u0010\u001f\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u00a2\u0006\u0002\u0010\"J \u0010#\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0017H\u0016J0\u0010#\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0017H\u0016J#\u0010'\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH\u0002\u00a2\u0006\u0002\u0010(J\u0018\u0010)\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J0\u0010*\u001a\u00020+2\u001e\u0010,\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020/0.0-2\u0006\u00100\u001a\u00020+H\u0002J0\u00101\u001a\u0002022\u001e\u0010,\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020/0.0.2\u0006\u00100\u001a\u00020+H\u0002J\u000e\u00103\u001a\b\u0012\u0004\u0012\u00020\u000704H\u0016J\u0010\u00105\u001a\u0002062\u0006\u0010\b\u001a\u00020\tH\u0016J \u00107\u001a\u00020+2\u0006\u0010\b\u001a\u00020\t2\u0006\u00108\u001a\u0002092\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001c\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020/0-2\u0006\u0010;\u001a\u00020<H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/arcadeanalytics/provider/gremlin/GremlinDataProvider;", "Lcom/arcadeanalytics/provider/DataSourceGraphDataProvider;", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "arcadeIdToNativeId", "", "dataSource", "Lcom/arcadeanalytics/provider/DataSourceInfo;", "id", "edges", "Lcom/arcadeanalytics/provider/GraphData;", "fromIds", "", "edgesLabel", "toIds", "(Lcom/arcadeanalytics/provider/DataSourceInfo;[Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;)Lcom/arcadeanalytics/provider/GraphData;", "expand", "roots", "direction", "edgeLabel", "maxTraversal", "", "(Lcom/arcadeanalytics/provider/DataSourceInfo;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)Lcom/arcadeanalytics/provider/GraphData;", "fetchData", "query", "limit", "getGraphData", "client", "Lorg/apache/tinkerpop/gremlin/driver/Client;", "load", "ids", "(Lcom/arcadeanalytics/provider/DataSourceInfo;[Ljava/lang/String;)Lcom/arcadeanalytics/provider/GraphData;", "(Lcom/arcadeanalytics/provider/DataSourceInfo;[Ljava/lang/String;Lorg/apache/tinkerpop/gremlin/driver/Client;)Lcom/arcadeanalytics/provider/GraphData;", "loadFromClass", "className", "propName", "propValue", "loadQuery", "(Lcom/arcadeanalytics/provider/DataSourceInfo;[Ljava/lang/String;)Ljava/lang/String;", "nativeIdToArcadeId", "populateClasses", "Lcom/arcadeanalytics/provider/CytoData;", "classes", "", "", "", "element", "populateProperties", "", "supportedDataSourceTypes", "", "testConnection", "", "toCytoData", "result", "Lorg/apache/tinkerpop/gremlin/driver/Result;", "transformToMap", "doc", "Lorg/apache/tinkerpop/gremlin/structure/Element;", "arcade-connectors-gremlin"})
public final class GremlinDataProvider
implements DataSourceGraphDataProvider {
    private final Logger log = LoggerFactory.getLogger(GremlinDataProvider.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public GraphData fetchData(@NotNull DataSourceInfo dataSource, @NotNull String query, int limit) {
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        Cluster cluster = GremlinUtilKt.getCluster(dataSource);
        Client client = ((Client)cluster.connect()).init();
        try {
            Client client2 = client;
            Intrinsics.checkExpressionValueIsNotNull((Object)client2, (String)"client");
            GraphData graphData = this.getGraphData(dataSource, query, limit, client2);
            return graphData;
        }
        catch (Exception e) {
            throw (Throwable)new RuntimeException(e);
        }
        finally {
            client.close();
            cluster.close();
        }
    }

    private final GraphData getGraphData(DataSourceInfo dataSource, String query, int limit, Client client) {
        String[] ids2;
        HashSet<CytoData> cytoNodes = new HashSet<CytoData>();
        HashSet cytoEdges = new HashSet();
        HashMap edgeClasses = new HashMap();
        HashMap nodeClasses = new HashMap();
        this.log.info("fetching data from '{}' with query '{}' ", (Object)dataSource.getId(), (Object)query);
        ResultSet resultSet = client.submit(query);
        Intrinsics.checkExpressionValueIsNotNull((Object)resultSet, (String)"client.submit(query)");
        String[] $this$toTypedArray$iv = (String[])SequencesKt.toSet((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.take((Sequence)CollectionsKt.asSequence((Iterable)resultSet), (int)limit), (Function1)((Function1)new Function1<Result, CytoData>(this, dataSource, client){
            final /* synthetic */ GremlinDataProvider this$0;
            final /* synthetic */ DataSourceInfo $dataSource;
            final /* synthetic */ Client $client;

            @NotNull
            public final CytoData invoke(Result r) {
                Result result = r;
                Intrinsics.checkExpressionValueIsNotNull((Object)result, (String)"r");
                return GremlinDataProvider.access$toCytoData(this.this$0, this.$dataSource, result, this.$client);
            }
            {
                this.this$0 = gremlinDataProvider;
                this.$dataSource = dataSourceInfo;
                this.$client = client;
                super(1);
            }
        })), (Function1)((Function1)new Function1<CytoData, List<? extends String>>(this, cytoNodes, nodeClasses, cytoEdges, edgeClasses){
            final /* synthetic */ GremlinDataProvider this$0;
            final /* synthetic */ HashSet $cytoNodes;
            final /* synthetic */ HashMap $nodeClasses;
            final /* synthetic */ HashSet $cytoEdges;
            final /* synthetic */ HashMap $edgeClasses;

            @NotNull
            public final List<String> invoke(@NotNull CytoData data) {
                List list;
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                if (Intrinsics.areEqual((Object)data.getGroup(), (Object)"nodes")) {
                    this.$cytoNodes.add(data);
                    GremlinDataProvider.access$populateClasses(this.this$0, this.$nodeClasses, data);
                    list = CollectionsKt.emptyList();
                } else {
                    this.$cytoEdges.add(data);
                    GremlinDataProvider.access$populateClasses(this.this$0, this.$edgeClasses, data);
                    list = CollectionsKt.listOf((Object[])new String[]{data.getData().getSource(), data.getData().getTarget()});
                }
                return list;
            }
            {
                this.this$0 = gremlinDataProvider;
                this.$cytoNodes = hashSet;
                this.$nodeClasses = hashMap;
                this.$cytoEdges = hashSet2;
                this.$edgeClasses = hashMap2;
                super(1);
            }
        })), (Function1)getGraphData.ids.3.INSTANCE));
        boolean $i$f$toTypedArray = false;
        String[] thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        $this$toTypedArray$iv = ids2 = stringArray;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        boolean bl = false;
        if (!(thisCollection$iv.length == 0)) {
            GraphData load = this.load(dataSource, ids2, client);
            Sequence $this$forEach$iv = CollectionsKt.asSequence((Iterable)load.getNodes());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CytoData n = (CytoData)element$iv;
                boolean bl2 = false;
                cytoNodes.add(n);
                this.populateClasses(nodeClasses, n);
            }
        }
        GraphData graphData = new GraphData((Map)nodeClasses, (Map)edgeClasses, (Set)cytoNodes, (Set)cytoEdges, false, 16, null);
        this.log.info("fetched {} nodes and {} edges ", (Object)cytoNodes.size(), (Object)cytoEdges.size());
        return graphData;
    }

    private final CytoData toCytoData(DataSourceInfo dataSource, Result result, Client client) {
        CytoData cytoData;
        Data data;
        String string;
        Data data2;
        String string2;
        String string3;
        String string4;
        String string5;
        Element element;
        Element element2 = result.getElement();
        String id = this.nativeIdToArcadeId(dataSource, element2.id().toString());
        Element element3 = element2;
        Intrinsics.checkExpressionValueIsNotNull((Object)element3, (String)"element");
        Map<String, Object> record = this.transformToMap(element3);
        HashMap ins = new HashMap();
        record.put("@in", ins);
        HashMap outs = new HashMap();
        record.put("@out", outs);
        if (record.containsKey("id")) {
            Object object = record.get("id");
            if (object == null) {
                Intrinsics.throwNpe();
            }
            record.put("_id_", object);
            record.remove("id");
        }
        if ((element = element2) instanceof Vertex) {
            Sequence $this$groupingBy$iv;
            ResultSet resultSet = client.submit("g.V('" + element2.id() + "').outE()");
            Intrinsics.checkExpressionValueIsNotNull((Object)resultSet, (String)"client.submit(\"g.V('${element.id()}').outE()\")");
            Sequence sequence = SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)resultSet), (Function1)toCytoData.cyto.1.INSTANCE), (Function1)toCytoData.cyto.2.INSTANCE);
            HashMap hashMap = outs;
            boolean $i$f$groupingBy = false;
            Grouping grouping = (Grouping)new Grouping<String, String>($this$groupingBy$iv){
                final /* synthetic */ Sequence $this_groupingBy;
                {
                    this.$this_groupingBy = $receiver;
                }

                @NotNull
                public Iterator<String> sourceIterator() {
                    return this.$this_groupingBy.iterator();
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 * WARNING - void declaration
                 */
                public Object keyOf(Object element) {
                    void var2_2;
                    String it = (String)element;
                    boolean bl = false;
                    return var2_2;
                }
            };
            hashMap.putAll(GroupingKt.eachCount((Grouping)grouping));
            ResultSet resultSet2 = client.submit("g.V('" + element2.id() + "').inE()");
            Intrinsics.checkExpressionValueIsNotNull((Object)resultSet2, (String)"client.submit(\"g.V('${element.id()}').inE()\")");
            $this$groupingBy$iv = SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)resultSet2), (Function1)toCytoData.cyto.4.INSTANCE), (Function1)toCytoData.cyto.5.INSTANCE);
            hashMap = ins;
            $i$f$groupingBy = false;
            grouping = (Grouping)new Grouping<String, String>($this$groupingBy$iv){
                final /* synthetic */ Sequence $this_groupingBy;
                {
                    this.$this_groupingBy = $receiver;
                }

                @NotNull
                public Iterator<String> sourceIterator() {
                    return this.$this_groupingBy.iterator();
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 * WARNING - void declaration
                 */
                public Object keyOf(Object element) {
                    void var2_2;
                    String it = (String)element;
                    boolean bl = false;
                    return var2_2;
                }
            };
            hashMap.putAll(GroupingKt.eachCount((Grouping)grouping));
            Collection collection = ins.values();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"ins.values");
            int edgeCount2 = SequencesKt.sumOfInt((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)toCytoData.cyto.edgeCount.1.INSTANCE));
            Collection collection2 = outs.values();
            Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"outs.values");
            record.put("@edgeCount", edgeCount2 += SequencesKt.sumOfInt((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)collection2), (Function1)toCytoData.cyto.7.INSTANCE)));
            Data data3 = new Data(id, null, null, null, record, 14, null);
            String string6 = element2.label();
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"element.label()");
            string5 = null;
            string4 = null;
            string3 = null;
            string2 = null;
            data2 = null;
            string = "nodes";
            data = data3;
            CytoData cytoData2 = new CytoData(string6, string, data, (Position)data2, string2, string3, string4, string5, 248, null);
            cytoData = cytoData2;
        } else if (element instanceof Edge) {
            String sourceId = ((Edge)element2).outVertex().id().toString();
            String source = this.nativeIdToArcadeId(dataSource, sourceId);
            String targetId = ((Edge)element2).inVertex().id().toString();
            String target = this.nativeIdToArcadeId(dataSource, targetId);
            Data data4 = new Data(id, null, source, target, record, 2, null);
            String string7 = element2.label();
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"element.label()");
            string2 = null;
            data2 = null;
            string = null;
            data = null;
            Position position = null;
            String string8 = "edges";
            Data data5 = data4;
            CytoData cytoData3 = new CytoData(string7, string8, data5, position, data, string, (String)data2, string2, 248, null);
            cytoData = cytoData3;
        } else {
            this.log.info("element not mappable:: " + element2);
            String string9 = element2.label();
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"element.label()");
            String string10 = null;
            String string11 = null;
            string5 = null;
            string4 = null;
            string3 = null;
            string2 = "unk";
            data2 = new Data(id, null, null, null, null, 30, null);
            CytoData cytoData4 = new CytoData(string9, string2, data2, string3, string4, string5, string11, string10, 248, null);
            cytoData = cytoData4;
        }
        CytoData cyto2 = cytoData;
        return cyto2;
    }

    private final CytoData populateClasses(Map<String, Map<String, Object>> classes, CytoData element) {
        if (classes.get(element.getClasses()) == null) {
            String string = element.getClasses();
            HashMap hashMap = Maps.newHashMap();
            Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"Maps.newHashMap()");
            classes.put(string, hashMap);
        }
        this.populateProperties(classes, element);
        return element;
    }

    private final void populateProperties(Map<String, ? extends Map<String, ? extends Object>> classes, CytoData element) {
        Map<String, ? extends Object> properties = classes.get(element.getClasses());
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)element.getData().getRecord().keySet()), (Function1)populateProperties.1.INSTANCE), (Function1)populateProperties.2.INSTANCE), (Function1)populateProperties.3.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String f = (String)element$iv;
            boolean bl = false;
            Map<String, ? extends Object> map = properties;
            if (map == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Map<kotlin.String, kotlin.Any>");
            }
            map.putIfAbsent(f, TypeMapperKt.mapType((String)"STRING"));
        }
    }

    private final Map<String, Object> transformToMap(Element doc) {
        HashMap record = Maps.newHashMap();
        Set<String> set = doc.keys();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"doc.keys()");
        Sequence $this$forEach$iv = CollectionsKt.asSequence((Iterable)set);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String k = (String)element$iv;
            boolean bl = false;
            HashMap hashMap = record;
            Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"record");
            ((Map)hashMap).put(k, doc.properties(k).next().value());
        }
        HashMap hashMap = record;
        Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"record");
        return hashMap;
    }

    @NotNull
    public GraphData load(@NotNull DataSourceInfo dataSource, @NotNull String[] ids2) {
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        Intrinsics.checkParameterIsNotNull((Object)ids2, (String)"ids");
        String query = this.loadQuery(dataSource, ids2);
        return this.fetchData(dataSource, query, ids2.length);
    }

    private final GraphData load(DataSourceInfo dataSource, String[] ids2, Client client) {
        String query = this.loadQuery(dataSource, ids2);
        return this.getGraphData(dataSource, query, ids2.length, client);
    }

    @NotNull
    public GraphData loadFromClass(@NotNull DataSourceInfo dataSource, @NotNull String className, int limit) {
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
        String query = "g.V().hasLabel(" + GremlinUtilKt.splitMultilabel(className) + ").limit(" + limit + ')';
        return this.fetchData(dataSource, query, limit);
    }

    @NotNull
    public GraphData loadFromClass(@NotNull DataSourceInfo dataSource, @NotNull String className, @NotNull String propName, @NotNull String propValue, int limit) {
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
        Intrinsics.checkParameterIsNotNull((Object)propName, (String)"propName");
        Intrinsics.checkParameterIsNotNull((Object)propValue, (String)"propValue");
        String query = "g.V().hasLabel(" + GremlinUtilKt.splitMultilabel(className) + ").has('" + propName + "', eq('" + propValue + "')).limit(" + limit + ')';
        return this.fetchData(dataSource, query, limit);
    }

    private final String loadQuery(DataSourceInfo dataSource, String[] ids2) {
        String[] stringArray = ids2;
        boolean bl = false;
        String[] stringArray2 = stringArray;
        boolean bl2 = false;
        boolean bl3 = !(stringArray2.length == 0);
        bl = false;
        boolean bl4 = false;
        bl4 = false;
        bl2 = false;
        if (!bl3) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.log.debug("load ids {} ", (Object[])Arrays.copyOf(ids2, ids2.length));
        String joinedIds2 = SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])ids2), (Function1)((Function1)new Function1<String, String>(this, dataSource){
            final /* synthetic */ GremlinDataProvider this$0;
            final /* synthetic */ DataSourceInfo $dataSource;

            @NotNull
            public final String invoke(@NotNull String id) {
                Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                return GremlinDataProvider.access$arcadeIdToNativeId(this.this$0, this.$dataSource, id);
            }
            {
                this.this$0 = gremlinDataProvider;
                this.$dataSource = dataSourceInfo;
                super(1);
            }
        })), (Function1)loadQuery.joinedIds.2.INSTANCE), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        return "g.V(" + joinedIds2 + ')';
    }

    private final String nativeIdToArcadeId(DataSourceInfo dataSource, String id) {
        String string;
        String string2 = dataSource.getType();
        switch (string2.hashCode()) {
            case -1469759516: {
                if (string2.equals("GREMLIN_ORIENTDB")) {
                    string = "" + dataSource.getId() + '_' + StringsKt.replace$default((String)StringsKt.removePrefix((String)id, (CharSequence)"#"), (String)":", (String)"_", (boolean)false, (int)4, null);
                    break;
                }
            }
            default: {
                string = "" + dataSource.getId() + '_' + id;
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String arcadeIdToNativeId(DataSourceInfo dataSource, String id) {
        String string;
        String string2 = dataSource.getType();
        switch (string2.hashCode()) {
            case -1469759516: {
                if (string2.equals("GREMLIN_ORIENTDB")) {
                    void $this$prefixIfAbsent$iv;
                    String string3 = StringsKt.removePrefix((String)id, (CharSequence)("" + dataSource.getId() + '_'));
                    String prefix$iv = "#";
                    boolean $i$f$prefixIfAbsent = false;
                    string = StringsKt.replace$default((String)(StringsKt.startsWith$default((String)$this$prefixIfAbsent$iv, (String)prefix$iv, (boolean)false, (int)2, null) ? $this$prefixIfAbsent$iv : prefix$iv + (String)$this$prefixIfAbsent$iv), (String)"_", (String)":", (boolean)false, (int)4, null);
                    break;
                }
            }
            default: {
                string = StringsKt.removePrefix((String)id, (CharSequence)("" + dataSource.getId() + '_'));
            }
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public GraphData expand(@NotNull DataSourceInfo dataSource, @NotNull String[] roots, @NotNull String direction, @NotNull String edgeLabel, int maxTraversal) {
        block5: {
            Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
            Intrinsics.checkParameterIsNotNull((Object)roots, (String)"roots");
            Intrinsics.checkParameterIsNotNull((Object)direction, (String)"direction");
            Intrinsics.checkParameterIsNotNull((Object)edgeLabel, (String)"edgeLabel");
            edgeLabel = edgeLabel;
            query = this.loadQuery(dataSource, roots);
            if (StringUtils.isNotEmpty(edgeLabel)) {
                v0 = StringUtils.wrap(edgeLabel, '\"');
                Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"wrap(edgeLabel, '\"')");
                edgeLabel = v0;
            }
            var8_8 = direction;
            var10_9 = new StringBuilder().append(query);
            var9_10 = false;
            v1 = var8_8.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"(this as java.lang.String).toLowerCase()");
            var8_8 = var11_11 = v1;
            switch (var8_8.hashCode()) {
                case 3365: {
                    if (!var8_8.equals("in")) ** break;
                    break;
                }
                case 110414: {
                    if (!var8_8.equals("out")) ** break;
                    v2 = ".outE(" + edgeLabel + ')';
                    break block5;
                }
            }
            v2 = ".inE(" + edgeLabel + ')';
            break block5;
            v2 = ".bothE(" + edgeLabel + ')';
        }
        query = var10_9.append(v2).toString();
        return this.fetchData(dataSource, query, maxTraversal);
    }

    @NotNull
    public GraphData edges(@NotNull DataSourceInfo dataSource, @NotNull String[] fromIds, @NotNull String[] edgesLabel, @NotNull String[] toIds) {
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        Intrinsics.checkParameterIsNotNull((Object)fromIds, (String)"fromIds");
        Intrinsics.checkParameterIsNotNull((Object)edgesLabel, (String)"edgesLabel");
        Intrinsics.checkParameterIsNotNull((Object)toIds, (String)"toIds");
        String string = "Not yet implemented";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    public boolean testConnection(@NotNull DataSourceInfo dataSource) {
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        try {
            this.log.info("testing connection to :: '{}' ", (Object)dataSource.getServer());
            Cluster cluster = GremlinUtilKt.getCluster(dataSource);
            cluster.availableHosts().stream().forEach(testConnection.1.INSTANCE);
            Client client = ((Client)cluster.connect()).init();
            client.submit("g.V().count()");
            client.close();
            cluster.close();
            this.log.info("connection works fine:: '{}' ", (Object)dataSource.getServer());
            return true;
        }
        catch (Exception e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    @NotNull
    public Set<String> supportedDataSourceTypes() {
        HashSet hashSet = Sets.newHashSet((Object[])new String[]{"GREMLIN_ORIENTDB", "GREMLIN_NEPTUNE", "GREMLIN_JANUSGRAPH"});
        Intrinsics.checkExpressionValueIsNotNull((Object)hashSet, (String)"Sets.newHashSet(\"GREMLIN\u2026E\", \"GREMLIN_JANUSGRAPH\")");
        return hashSet;
    }

    public static final /* synthetic */ CytoData access$toCytoData(GremlinDataProvider $this, DataSourceInfo dataSource, Result result, Client client) {
        return $this.toCytoData(dataSource, result, client);
    }

    public static final /* synthetic */ CytoData access$populateClasses(GremlinDataProvider $this, Map classes, CytoData element) {
        return $this.populateClasses(classes, element);
    }

    public static final /* synthetic */ String access$arcadeIdToNativeId(GremlinDataProvider $this, DataSourceInfo dataSource, String id) {
        return $this.arcadeIdToNativeId(dataSource, id);
    }
}

