/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.gremlin;

import com.arcadeanalytics.data.Sprite;
import com.arcadeanalytics.data.SpritePlayer;
import com.arcadeanalytics.provider.DataSourceGraphProvider;
import com.arcadeanalytics.provider.DataSourceInfo;
import com.arcadeanalytics.provider.gremlin.GremlinUtilKt;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.apache.tinkerpop.gremlin.driver.ResultSet;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GremlinGraphProvider
implements DataSourceGraphProvider {
    private final Logger log = LoggerFactory.getLogger(GremlinGraphProvider.class);
    private final Pattern allFields = Pattern.compile(".*");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void provideTo(DataSourceInfo dataSource, SpritePlayer player) {
        Cluster cluster = GremlinUtilKt.getCluster(dataSource);
        Client client = ((Client)cluster.connect()).init();
        try {
            this.provideNodes(dataSource, player, client);
            this.provideEdges(dataSource, player, client);
            client.close();
        }
        finally {
            cluster.close();
            client.close();
            player.end();
        }
    }

    private void provideNodes(DataSourceInfo dataSource, SpritePlayer processor, Client client) {
        long nodes = client.submit("g.V().count()").one().getLong();
        long fetched = 0L;
        long skip = 0L;
        long limit = Math.min(nodes, 1000L);
        this.log.info("start indexing of data-source {} - total nodes:: {} ", (Object)dataSource.getId(), (Object)nodes);
        while (fetched < nodes) {
            ResultSet resultSet = client.submit("g.V().range(" + skip + " , " + limit + ")");
            for (Result r : resultSet) {
                Vertex element = r.getVertex();
                Sprite sprite = new Sprite();
                element.keys().stream().flatMap(key -> IteratorUtils.stream(element.properties((String)key))).forEach(v -> sprite.add(v.label(), v.value()));
                sprite.add("_a_id", dataSource.getId() + "_" + this.cleanOrientId(element.id().toString())).add("_a_type", "node").add("@class", element.label());
                processor.play(sprite);
                ++fetched;
            }
            skip = limit;
            limit += 10000L;
        }
    }

    private void provideEdges(DataSourceInfo dataSource, SpritePlayer processor, Client client) {
        long edges = client.submit("g.E().count()").one().getLong();
        long fetched = 0L;
        long skip = 0L;
        long limit = Math.min(edges, 1000L);
        this.log.info("start indexing of data-source {} - total edges:: {} ", (Object)dataSource.getId(), (Object)edges);
        while (fetched < edges) {
            ResultSet resultSet = client.submit("g.E().range(" + skip + " , " + limit + ")");
            for (Result r : resultSet) {
                Element element = r.getElement();
                if (!element.keys().isEmpty()) {
                    Sprite sprite = new Sprite();
                    element.keys().forEach(k -> sprite.add(k, element.value((String)k).toString()));
                    sprite.add("_a_id", dataSource.getId() + "_" + this.cleanOrientId(element.id().toString())).add("_a_type", "edge").add("@class", element.label());
                    processor.play(sprite);
                }
                ++fetched;
            }
            skip = limit;
            limit += 10000L;
        }
    }

    @NotNull
    private String cleanOrientId(String id) {
        return StringUtils.removeStart(id, "#").replace(":", "_");
    }

    @NotNull
    public Set<String> supportedDataSourceTypes() {
        return Sets.newHashSet((Object[])new String[]{"GREMLIN_ORIENTDB", "GREMLIN_NEPTUNE", "GREMLIN_JANUSGRAPH"});
    }
}

