/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.gremlin;

import com.arcadeanalytics.provider.DataSourceInfo;
import com.arcadeanalytics.provider.DataSourceMetadata;
import com.arcadeanalytics.provider.DataSourceMetadataProvider;
import com.arcadeanalytics.provider.TypeClass;
import com.arcadeanalytics.provider.TypeProperty;
import com.arcadeanalytics.provider.gremlin.GremlinMetadataProvider;
import com.arcadeanalytics.provider.gremlin.GremlinUtilKt;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.apache.tinkerpop.gremlin.driver.ResultSet;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00130\u0012j\u0002`\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00160\u0012j\u0002`\u00172\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00160\u0012j\u0002`\u00192\u0006\u0010\n\u001a\u00020\u000bJ(\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00130\u0012j\u0002`\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\u001cH\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/arcadeanalytics/provider/gremlin/GremlinMetadataProvider;", "Lcom/arcadeanalytics/provider/DataSourceMetadataProvider;", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "countEdgeLabel", "", "label", "", "client", "Lorg/apache/tinkerpop/gremlin/driver/Client;", "countNodeLabel", "fetchMetadata", "Lcom/arcadeanalytics/provider/DataSourceMetadata;", "dataSource", "Lcom/arcadeanalytics/provider/DataSourceInfo;", "mapEdgeProperties", "", "Lcom/arcadeanalytics/provider/TypeProperty;", "Lcom/arcadeanalytics/provider/TypeProperties;", "mapEdgesClasses", "Lcom/arcadeanalytics/provider/TypeClass;", "Lcom/arcadeanalytics/provider/EdgesClasses;", "mapNodeClasses", "Lcom/arcadeanalytics/provider/NodesClasses;", "mapNodeProperties", "supportedDataSourceTypes", "", "arcade-connectors-gremlin"})
public final class GremlinMetadataProvider
implements DataSourceMetadataProvider {
    private final Logger log = LoggerFactory.getLogger(GremlinMetadataProvider.class);

    @NotNull
    public Set<String> supportedDataSourceTypes() {
        return SetsKt.setOf((Object[])new String[]{"GREMLIN_ORIENTDB", "GREMLIN_NEPTUNE", "GREMLIN_JANUSGRAPH"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public DataSourceMetadata fetchMetadata(@NotNull DataSourceInfo dataSource) {
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        this.log.info("fetching metadata for dataSource {} ", (Object)dataSource.getId());
        Cluster cluster = GremlinUtilKt.getCluster(dataSource);
        Client client = ((Client)cluster.connect()).init();
        try {
            Client client2 = client;
            Intrinsics.checkExpressionValueIsNotNull((Object)client2, (String)"client");
            Map<String, TypeClass> nodeClasses = this.mapNodeClasses(client2);
            Map<String, TypeClass> edgesClasses = this.mapEdgesClasses(client);
            DataSourceMetadata dataSourceMetadata = new DataSourceMetadata(nodeClasses, edgesClasses);
            return dataSourceMetadata;
        }
        finally {
            client.close();
            cluster.close();
        }
    }

    @NotNull
    public final Map<String, TypeClass> mapNodeClasses(@NotNull Client client) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        ResultSet resultSet = client.submit("g.V().label().groupCount()");
        Intrinsics.checkExpressionValueIsNotNull((Object)resultSet, (String)"client.submit(\"g.V().label().groupCount()\")");
        return MapsKt.toMap((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.map((Sequence)SequencesKt.onEach((Sequence)CollectionsKt.asSequence((Iterable)resultSet), (Function1)mapNodeClasses.1.INSTANCE), (Function1)mapNodeClasses.2.INSTANCE), (Function1)mapNodeClasses.3.INSTANCE), (Function1)((Function1)new Function1<Map.Entry<? extends String, ? extends Long>, TypeClass>(this, client){
            final /* synthetic */ GremlinMetadataProvider this$0;
            final /* synthetic */ Client $client;

            @NotNull
            public final TypeClass invoke(@NotNull Map.Entry<String, Long> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return new TypeClass(it.getKey(), ((Number)it.getValue()).longValue(), GremlinMetadataProvider.access$mapNodeProperties(this.this$0, it.getKey(), this.$client));
            }
            {
                this.this$0 = gremlinMetadataProvider;
                this.$client = client;
                super(1);
            }
        })), (Function1)mapNodeClasses.5.INSTANCE));
    }

    private final Map<String, TypeProperty> mapNodeProperties(String label, Client client) {
        ResultSet resultSet = client.submit("g.V().hasLabel(" + GremlinUtilKt.splitMultilabel(label) + ").limit(1).next()");
        Intrinsics.checkExpressionValueIsNotNull((Object)resultSet, (String)"client.submit(\"\"\"g.V().h\u2026el)}).limit(1).next()\"\"\")");
        return MapsKt.toMap((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)resultSet), (Function1)mapNodeProperties.1.INSTANCE), (Function1)mapNodeProperties.2.INSTANCE), (Function1)mapNodeProperties.3.INSTANCE));
    }

    @NotNull
    public final Map<String, TypeClass> mapEdgesClasses(@NotNull Client client) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        ResultSet resultSet = client.submit("g.E().label().dedup()");
        Intrinsics.checkExpressionValueIsNotNull((Object)resultSet, (String)"client.submit(\"g.E().label().dedup()\")");
        return MapsKt.toMap((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)resultSet), (Function1)mapEdgesClasses.1.INSTANCE), (Function1)((Function1)new Function1<String, TypeClass>(this, client){
            final /* synthetic */ GremlinMetadataProvider this$0;
            final /* synthetic */ Client $client;

            @NotNull
            public final TypeClass invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return new TypeClass(it, GremlinMetadataProvider.access$countEdgeLabel(this.this$0, it, this.$client), GremlinMetadataProvider.access$mapEdgeProperties(this.this$0, it, this.$client));
            }
            {
                this.this$0 = gremlinMetadataProvider;
                this.$client = client;
                super(1);
            }
        })), (Function1)mapEdgesClasses.3.INSTANCE));
    }

    private final Map<String, TypeProperty> mapEdgeProperties(String label, Client client) {
        ResultSet resultSet = client.submit("g.E().hasLabel(" + GremlinUtilKt.splitMultilabel(label) + " ).limit(1).next()");
        Intrinsics.checkExpressionValueIsNotNull((Object)resultSet, (String)"client.submit(\"\"\"g.E().h\u2026l)} ).limit(1).next()\"\"\")");
        return MapsKt.toMap((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)resultSet), (Function1)mapEdgeProperties.1.INSTANCE), (Function1)mapEdgeProperties.2.INSTANCE), (Function1)mapEdgeProperties.3.INSTANCE));
    }

    private final long countNodeLabel(String label, Client client) {
        Result result = client.submit("g.V().hasLabel(" + GremlinUtilKt.splitMultilabel(label) + ").count()").one();
        Intrinsics.checkExpressionValueIsNotNull((Object)result, (String)"client.submit(\"\"\"g.V().h\u2026\")\n                .one()");
        return result.getLong();
    }

    private final long countEdgeLabel(String label, Client client) {
        Result result = client.submit("g.E().hasLabel(" + GremlinUtilKt.splitMultilabel(label) + ").count()").one();
        Intrinsics.checkExpressionValueIsNotNull((Object)result, (String)"client.submit(\"\"\"g.E().h\u2026\")\n                .one()");
        return result.getLong();
    }

    public static final /* synthetic */ Map access$mapNodeProperties(GremlinMetadataProvider $this, String label, Client client) {
        return $this.mapNodeProperties(label, client);
    }

    public static final /* synthetic */ long access$countEdgeLabel(GremlinMetadataProvider $this, String label, Client client) {
        return $this.countEdgeLabel(label, client);
    }

    public static final /* synthetic */ Map access$mapEdgeProperties(GremlinMetadataProvider $this, String label, Client client) {
        return $this.mapEdgeProperties(label, client);
    }
}

