/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.gremlin;

import com.arcadeanalytics.provider.DataSourceInfo;
import java.util.HashMap;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.GraphSONMessageSerializerV1d0;
import org.apache.tinkerpop.gremlin.driver.ser.GryoMessageSerializerV3d0;
import org.apache.tinkerpop.gremlin.orientdb.io.OrientIoRegistry;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoMapper;
import org.janusgraph.graphdb.tinkerpop.JanusGraphIoRegistry;
import org.jetbrains.annotations.NotNull;

public class GremlinSerializerFactory {
    @NotNull
    public static MessageSerializer createSerializer(DataSourceInfo dataSource) {
        String type;
        switch (type = dataSource.getType()) {
            case "GREMLIN_ORIENTDB": {
                return new GryoMessageSerializerV3d0(GryoMapper.build().addRegistry(OrientIoRegistry.getInstance()));
            }
            case "GREMLIN_NEPTUNE": {
                return new GryoMessageSerializerV3d0();
            }
            case "GREMLIN_JANUSGRAPH": {
                return new GryoMessageSerializerV3d0(GryoMapper.build().addRegistry(JanusGraphIoRegistry.getInstance()));
            }
            case "GREMLIN_COSMOSDB": {
                GraphSONMessageSerializerV1d0 seriallizer = new GraphSONMessageSerializerV1d0();
                HashMap<String, Object> conf = new HashMap<String, Object>();
                conf.put("serializeResultToString", true);
                seriallizer.configure(conf, null);
                return seriallizer;
            }
        }
        throw new RuntimeException("requested type not implemented yet:: " + type);
    }
}

