/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.directmemory;

import com.orientechnologies.common.directmemory.OByteBufferPoolMXBean;
import com.orientechnologies.common.directmemory.ODirectMemoryAllocator;
import com.orientechnologies.common.directmemory.OPointer;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class OByteBufferPool
implements OByteBufferPoolMXBean {
    private static final boolean TRACK = OGlobalConfiguration.DIRECT_MEMORY_TRACK_MODE.getValueAsBoolean();
    private static final AtomicReference<OByteBufferPool> INSTANCE_HOLDER = new AtomicReference();
    private final int poolSize;
    private final int pageSize;
    private final ConcurrentHashMap<OPointer, PointerTracker> pointerMapping = new ConcurrentHashMap();
    private final ConcurrentLinkedQueue<OPointer> pointersPool = new ConcurrentLinkedQueue();
    private final AtomicInteger pointersPoolSize = new AtomicInteger();
    private final ODirectMemoryAllocator allocator;

    public static OByteBufferPool instance(OContextConfiguration contextConfiguration) {
        OByteBufferPool instance = INSTANCE_HOLDER.get();
        if (instance != null) {
            return instance;
        }
        int bufferSize = contextConfiguration != null ? contextConfiguration.getValueAsInteger(OGlobalConfiguration.DISK_CACHE_PAGE_SIZE) : OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger();
        OByteBufferPool newInstance = new OByteBufferPool(bufferSize * 1024);
        if (INSTANCE_HOLDER.compareAndSet(null, newInstance)) {
            return newInstance;
        }
        return INSTANCE_HOLDER.get();
    }

    public OByteBufferPool(int pageSize) {
        this.pageSize = pageSize;
        this.allocator = ODirectMemoryAllocator.instance();
        this.poolSize = OGlobalConfiguration.DIRECT_MEMORY_POOL_LIMIT.getValueAsInteger();
    }

    public OByteBufferPool(int pageSize, ODirectMemoryAllocator allocator, int poolSize) {
        this.pageSize = pageSize;
        this.allocator = allocator;
        this.poolSize = poolSize;
    }

    public final OPointer acquireDirect(boolean clear) {
        OPointer pointer = this.pointersPool.poll();
        if (pointer != null) {
            this.pointersPoolSize.decrementAndGet();
        } else {
            pointer = this.allocator.allocate(this.pageSize, -1);
        }
        if (clear) {
            pointer.clear();
        }
        ByteBuffer buffer = pointer.getNativeByteBuffer();
        buffer.position(0);
        if (TRACK) {
            this.pointerMapping.put(pointer, this.generatePointer());
        }
        return pointer;
    }

    public final void release(OPointer pointer) {
        long poolSize;
        if (TRACK) {
            this.pointerMapping.remove(pointer);
        }
        if ((poolSize = (long)this.pointersPoolSize.incrementAndGet()) > (long)this.poolSize) {
            this.pointersPoolSize.decrementAndGet();
            this.allocator.deallocate(pointer);
        } else {
            this.pointersPool.add(pointer);
        }
    }

    @Override
    public final int getPoolSize() {
        return this.pointersPoolSize.get();
    }

    public void checkMemoryLeaks() {
        boolean detected = false;
        if (TRACK) {
            for (Map.Entry entry : this.pointerMapping.entrySet()) {
                OLogManager.instance().errorNoDb(this, "DIRECT-TRACK: unreleased direct memory pointer `%X` detected.", ((PointerTracker)entry.getValue()).allocation, System.identityHashCode(entry.getKey()));
                detected = true;
            }
        }
        assert (!detected);
    }

    public void clear() {
        for (OPointer pointer : this.pointersPool) {
            this.allocator.deallocate(pointer);
        }
        this.pointersPool.clear();
        this.pointersPoolSize.set(0);
        for (OPointer pointer : this.pointerMapping.keySet()) {
            this.allocator.deallocate(pointer);
        }
        this.pointerMapping.clear();
    }

    private PointerTracker generatePointer() {
        return new PointerTracker(new Exception());
    }

    private static final class PointerTracker {
        private final Exception allocation;

        PointerTracker(Exception allocation) {
            this.allocation = allocation;
        }
    }
}

