/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.orient.client.remote.OCollectionNetworkSerializer;
import com.orientechnologies.orient.client.remote.OSBTreeBonsaiRemote;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.client.remote.message.OSBTCreateTreeRequest;
import com.orientechnologies.orient.client.remote.message.OSBTCreateTreeResponse;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OLinkSerializer;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.index.sbtreebonsai.local.OSBTreeBonsai;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OSBTreeCollectionManagerAbstract;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class OSBTreeCollectionManagerRemote
extends OSBTreeCollectionManagerAbstract {
    private final OCollectionNetworkSerializer networkSerializer;
    private boolean remoteCreationAllowed = false;
    private volatile ThreadLocal<Map<UUID, WeakReference<ORidBag>>> pendingCollections = new PendingCollectionsThreadLocal();

    public OSBTreeCollectionManagerRemote(OStorage storage) {
        super(storage);
        this.networkSerializer = new OCollectionNetworkSerializer();
    }

    OSBTreeCollectionManagerRemote(OStorage storage, OCollectionNetworkSerializer networkSerializer) {
        super(storage);
        this.networkSerializer = networkSerializer;
    }

    @Override
    public void onShutdown() {
        this.pendingCollections = null;
        super.onShutdown();
    }

    @Override
    public void onStartup() {
        super.onStartup();
        if (this.pendingCollections == null) {
            this.pendingCollections = new PendingCollectionsThreadLocal();
        }
    }

    protected OSBTreeBonsaiRemote<OIdentifiable, Integer> createTree(OAtomicOperation atomicOperation, int clusterId) {
        if (this.remoteCreationAllowed) {
            OStorageRemote storage = (OStorageRemote)ODatabaseRecordThreadLocal.instance().get().getStorage().getUnderlying();
            OSBTCreateTreeRequest request = new OSBTCreateTreeRequest(clusterId);
            OSBTCreateTreeResponse response = storage.networkOperationNoRetry(request, "Cannot create sb-tree bonsai");
            OBonsaiCollectionPointer pointer = response.getCollenctionPointer();
            OLinkSerializer keySerializer = OLinkSerializer.INSTANCE;
            OIntegerSerializer valueSerializer = OIntegerSerializer.INSTANCE;
            return new OSBTreeBonsaiRemote<OIdentifiable, Integer>(pointer, keySerializer, valueSerializer);
        }
        throw new UnsupportedOperationException("Creation of SB-Tree from remote storage is not allowed");
    }

    @Override
    protected OSBTreeBonsai<OIdentifiable, Integer> loadTree(OBonsaiCollectionPointer collectionPointer) {
        OLinkSerializer keySerializer = OLinkSerializer.INSTANCE;
        OIntegerSerializer valueSerializer = OIntegerSerializer.INSTANCE;
        return new OSBTreeBonsaiRemote<OIdentifiable, Integer>(collectionPointer, keySerializer, valueSerializer);
    }

    @Override
    public UUID listenForChanges(ORidBag collection) {
        UUID id = collection.getTemporaryId();
        if (id == null) {
            id = UUID.randomUUID();
        }
        this.pendingCollections.get().put(id, new WeakReference<ORidBag>(collection));
        return id;
    }

    @Override
    public void updateCollectionPointer(UUID uuid, OBonsaiCollectionPointer pointer) {
        WeakReference<ORidBag> reference = this.pendingCollections.get().get(uuid);
        if (reference == null) {
            OLogManager.instance().warn((Object)this, "Update of collection pointer is received but collection is not registered", new Object[0]);
            return;
        }
        ORidBag collection = (ORidBag)reference.get();
        if (collection != null) {
            collection.notifySaved(pointer);
        }
    }

    @Override
    public void clearPendingCollections() {
        this.pendingCollections.get().clear();
    }

    @Override
    public Map<UUID, OBonsaiCollectionPointer> changedIds() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearChangedIds() {
        throw new UnsupportedOperationException();
    }

    private static class PendingCollectionsThreadLocal
    extends ThreadLocal<Map<UUID, WeakReference<ORidBag>>> {
        private PendingCollectionsThreadLocal() {
        }

        @Override
        protected Map<UUID, WeakReference<ORidBag>> initialValue() {
            return new HashMap<UUID, WeakReference<ORidBag>>();
        }
    }
}

